/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import herddb.core.TableSpaceManager;
import herddb.model.Column;
import herddb.model.DMLStatement;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.model.planner.PlannerOp;
import herddb.utils.Wrapper;
import java.util.concurrent.CompletableFuture;

public class SimpleUpdateOp
implements PlannerOp {
    private final DMLStatement statement;

    public SimpleUpdateOp(DMLStatement update) {
        this.statement = update;
    }

    @Override
    public String getTablespace() {
        return this.statement.getTableSpace();
    }

    @Override
    public CompletableFuture<StatementExecutionResult> executeAsync(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) {
        return tableSpaceManager.executeStatementAsync(this.statement, context, transactionContext);
    }

    public <T> T unwrap(Class<T> clazz) {
        Object unwrapped = this.statement.unwrap(clazz);
        if (unwrapped != null) {
            return (T)unwrapped;
        }
        return (T)Wrapper.unwrap((Object)this, clazz);
    }

    @Override
    public boolean isSimpleStatementWrapper() {
        return true;
    }

    public String toString() {
        return "SimpleUpdateOp{statement=" + this.statement + '}';
    }

    @Override
    public Column[] getOutputSchema() {
        return new Column[0];
    }
}

