/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.core.MaterializedRecordSet;
import herddb.core.SimpleDataScanner;
import herddb.core.TableSpaceManager;
import herddb.model.Column;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.ScanResult;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.model.planner.EnumerableDataScanner;
import herddb.model.planner.JoinKey;
import herddb.model.planner.PlannerOp;
import herddb.utils.DataAccessor;
import java.util.Arrays;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.EnumerableDefaults;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"})
public class SemiJoinOp
implements PlannerOp {
    private final int[] leftKeys;
    private final PlannerOp left;
    private final int[] rightKeys;
    private final PlannerOp right;
    private final String[] fieldNames;
    private final Column[] columns;

    public SemiJoinOp(String[] fieldNames, Column[] columns, int[] leftKeys, PlannerOp left, int[] rightKeys, PlannerOp right) {
        this.fieldNames = fieldNames;
        this.columns = columns;
        this.leftKeys = leftKeys;
        this.left = left.optimize();
        this.rightKeys = rightKeys;
        this.right = right.optimize();
    }

    @Override
    public String getTablespace() {
        return this.left.getTablespace();
    }

    @Override
    public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        SimpleDataScanner materialized;
        MaterializedRecordSet recordSet;
        ScanResult resLeft = (ScanResult)this.left.execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
        transactionContext = new TransactionContext(resLeft.transactionId);
        ScanResult resRight = (ScanResult)this.right.execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
        DataScanner leftScanner = resLeft.dataScanner;
        DataScanner rightScanner = resRight.dataScanner;
        if (!leftScanner.isRewindSupported()) {
            try {
                recordSet = tableSpaceManager.getDbmanager().getRecordSetFactory().createRecordSet(leftScanner.getFieldNames(), leftScanner.getSchema());
                leftScanner.forEach(d -> recordSet.add((DataAccessor)d));
                recordSet.writeFinished();
                materialized = new SimpleDataScanner(leftScanner.getTransaction(), recordSet);
                leftScanner.close();
                leftScanner = materialized;
            }
            catch (DataScannerException err) {
                throw new StatementExecutionException(err);
            }
        }
        if (!rightScanner.isRewindSupported()) {
            try {
                recordSet = tableSpaceManager.getDbmanager().getRecordSetFactory().createRecordSet(rightScanner.getFieldNames(), rightScanner.getSchema());
                rightScanner.forEach(d -> recordSet.add((DataAccessor)d));
                recordSet.writeFinished();
                materialized = new SimpleDataScanner(rightScanner.getTransaction(), recordSet);
                rightScanner.close();
                rightScanner = materialized;
            }
            catch (DataScannerException err) {
                throw new StatementExecutionException(err);
            }
        }
        long resTransactionId = resRight.transactionId;
        Enumerable result = EnumerableDefaults.semiJoin(leftScanner.createRewindOnCloseEnumerable(), rightScanner.createRewindOnCloseEnumerable(), JoinKey.keyExtractor(this.leftKeys), JoinKey.keyExtractor(this.rightKeys));
        EnumerableDataScanner joinedScanner = new EnumerableDataScanner(rightScanner.getTransaction(), this.fieldNames, this.columns, (Enumerable<DataAccessor>)result, leftScanner, rightScanner);
        return new ScanResult(resTransactionId, joinedScanner);
    }

    public String toString() {
        return "SemiJoinOp {leftKey = " + Arrays.toString(this.leftKeys) + " rightKey = " + Arrays.toString(this.rightKeys) + "\n  left = " + this.left + "\n  right = " + this.right + '}';
    }

    @Override
    public Column[] getOutputSchema() {
        return this.columns;
    }
}

