/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.core.MaterializedRecordSet;
import herddb.core.SimpleDataScanner;
import herddb.core.TableSpaceManager;
import herddb.model.Column;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.ScanResult;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.model.planner.ConcatenatedDataAccessor;
import herddb.model.planner.EnumerableDataScanner;
import herddb.model.planner.JoinKey;
import herddb.model.planner.PlannerOp;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.EnumerableDefaults;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.function.Predicate2;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"})
public class JoinOp
implements PlannerOp {
    private final int[] leftKeys;
    private final PlannerOp left;
    private final int[] rightKeys;
    private final PlannerOp right;
    private final String[] fieldNames;
    private final Column[] columns;
    private final boolean generateNullsOnLeft;
    private final boolean generateNullsOnRight;
    private final boolean mergeJoin;
    private final List<CompiledSQLExpression> nonEquiConditions;

    public JoinOp(String[] fieldNames, Column[] columns, int[] leftKeys, PlannerOp left, int[] rightKeys, PlannerOp right, boolean generateNullsOnLeft, boolean generateNullsOnRight, boolean mergeJoin, List<CompiledSQLExpression> nonEquiConditions) {
        this.fieldNames = fieldNames;
        this.columns = columns;
        this.leftKeys = leftKeys;
        this.left = left.optimize();
        this.rightKeys = rightKeys;
        this.right = right.optimize();
        this.generateNullsOnLeft = generateNullsOnLeft;
        this.generateNullsOnRight = generateNullsOnRight;
        this.nonEquiConditions = nonEquiConditions;
        this.mergeJoin = mergeJoin;
    }

    @Override
    public String getTablespace() {
        return this.left.getTablespace();
    }

    @Override
    public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        SimpleDataScanner materialized;
        MaterializedRecordSet recordSet;
        Predicate2 predicate;
        ScanResult resLeft = (ScanResult)this.left.execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
        transactionContext = new TransactionContext(resLeft.transactionId);
        ScanResult resRight = (ScanResult)this.right.execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
        long resTransactionId = resRight.transactionId;
        DataScanner leftScanner = resLeft.dataScanner;
        String[] fieldNamesFromLeft = leftScanner.getFieldNames();
        String[] fieldNamesFromRight = resRight.dataScanner.getFieldNames();
        Function2<DataAccessor, DataAccessor, DataAccessor> resultProjection = this.resultProjection(fieldNamesFromLeft, fieldNamesFromRight);
        DataScanner rightScanner = resRight.dataScanner;
        if (this.nonEquiConditions != null && !this.nonEquiConditions.isEmpty()) {
            if (this.mergeJoin) {
                throw new IllegalStateException("Unspected nonEquiConditions " + this.nonEquiConditions + "for merge join");
            }
            predicate = (t0, t1) -> {
                DataAccessor da0 = (DataAccessor)t0;
                DataAccessor da1 = (DataAccessor)t1;
                DataAccessor currentRow = (DataAccessor)resultProjection.apply((Object)da0, (Object)da1);
                for (CompiledSQLExpression exp : this.nonEquiConditions) {
                    Object result = exp.evaluate(currentRow, context);
                    boolean asBoolean = SQLRecordPredicateFunctions.toBoolean((Object)result);
                    if (asBoolean) continue;
                    return false;
                }
                return true;
            };
        } else {
            predicate = null;
        }
        if (!this.mergeJoin && !leftScanner.isRewindSupported()) {
            try {
                recordSet = tableSpaceManager.getDbmanager().getRecordSetFactory().createRecordSet(leftScanner.getFieldNames(), leftScanner.getSchema());
                leftScanner.forEach(d -> recordSet.add((DataAccessor)d));
                recordSet.writeFinished();
                materialized = new SimpleDataScanner(leftScanner.getTransaction(), recordSet);
                leftScanner.close();
                leftScanner = materialized;
            }
            catch (DataScannerException err) {
                throw new StatementExecutionException(err);
            }
        }
        if (!this.mergeJoin && !rightScanner.isRewindSupported()) {
            try {
                recordSet = tableSpaceManager.getDbmanager().getRecordSetFactory().createRecordSet(rightScanner.getFieldNames(), rightScanner.getSchema());
                rightScanner.forEach(d -> recordSet.add((DataAccessor)d));
                recordSet.writeFinished();
                materialized = new SimpleDataScanner(rightScanner.getTransaction(), recordSet);
                rightScanner.close();
                rightScanner = materialized;
            }
            catch (DataScannerException err) {
                throw new StatementExecutionException(err);
            }
        }
        Enumerable result = this.mergeJoin ? EnumerableDefaults.mergeJoin(leftScanner.createNonRewindableEnumerable(), rightScanner.createNonRewindableEnumerable(), JoinKey.keyExtractor(this.leftKeys), JoinKey.keyExtractor(this.rightKeys), resultProjection, (boolean)this.generateNullsOnLeft, (boolean)this.generateNullsOnRight) : EnumerableDefaults.hashJoin(leftScanner.createRewindOnCloseEnumerable(), rightScanner.createRewindOnCloseEnumerable(), JoinKey.keyExtractor(this.leftKeys), JoinKey.keyExtractor(this.rightKeys), resultProjection, null, (boolean)this.generateNullsOnLeft, (boolean)this.generateNullsOnRight, (Predicate2)predicate);
        EnumerableDataScanner joinedScanner = new EnumerableDataScanner(rightScanner.getTransaction(), this.fieldNames, this.columns, (Enumerable<DataAccessor>)result, leftScanner, rightScanner);
        return new ScanResult(resTransactionId, joinedScanner);
    }

    private Function2<DataAccessor, DataAccessor, DataAccessor> resultProjection(String[] fieldNamesFromLeft, String[] fieldNamesFromRight) {
        DataAccessor nullsOnLeft = DataAccessor.ALL_NULLS((String[])fieldNamesFromLeft);
        DataAccessor nullsOnRight = DataAccessor.ALL_NULLS((String[])fieldNamesFromRight);
        return (a, b) -> new ConcatenatedDataAccessor(this.fieldNames, a != null ? a : nullsOnLeft, b != null ? b : nullsOnRight);
    }

    public String toString() {
        return "JoinOp{fieldNames=" + Arrays.toString(this.fieldNames) + ", columns=" + Arrays.toString(this.columns) + ",\ngenerateNullsOnLeft=" + this.generateNullsOnLeft + ", generateNullsOnRight=" + this.generateNullsOnRight + ", mergeJoin=" + this.mergeJoin + ",\nleftKeys=" + Arrays.toString(this.leftKeys) + ",left=" + this.left + ",\nrightKeys=" + Arrays.toString(this.rightKeys) + ", right=" + this.right + '}';
    }

    @Override
    public Column[] getOutputSchema() {
        return this.columns;
    }

    public PlannerOp getLeft() {
        return this.left;
    }

    public PlannerOp getRight() {
        return this.right;
    }
}

