/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import herddb.core.TableSpaceManager;
import herddb.model.Column;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.ScanResult;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.model.planner.FilteredTableScanOp;
import herddb.model.planner.PlannerOp;
import herddb.model.planner.TableScanOp;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;
import herddb.utils.Wrapper;

public class FilterOp
implements PlannerOp {
    private final PlannerOp input;
    private final CompiledSQLExpression condition;

    public FilterOp(PlannerOp input, CompiledSQLExpression condition) {
        this.input = input.optimize();
        this.condition = condition;
    }

    public <T> T unwrap(Class<T> clazz) {
        Object unwrapped = this.input.unwrap(clazz);
        if (unwrapped != null) {
            return (T)unwrapped;
        }
        return (T)Wrapper.unwrap((Object)this, clazz);
    }

    public PlannerOp getInput() {
        return this.input;
    }

    public CompiledSQLExpression getCondition() {
        return this.condition;
    }

    @Override
    public String getTablespace() {
        return this.input.getTablespace();
    }

    @Override
    public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        try {
            StatementExecutionResult input = this.input.execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
            ScanResult downstreamScanResult = (ScanResult)input;
            DataScanner inputScanner = downstreamScanResult.dataScanner;
            FilteredDataScanner filtered = new FilteredDataScanner(inputScanner, this.condition, context);
            return new ScanResult(downstreamScanResult.transactionId, filtered);
        }
        catch (DataScannerException ex) {
            throw new StatementExecutionException(ex);
        }
    }

    @Override
    public PlannerOp optimize() {
        if (this.input instanceof TableScanOp) {
            return new FilteredTableScanOp(this, (TableScanOp)this.input);
        }
        return this;
    }

    public String toString() {
        return String.format("FilterOp {input=[ %s ] condition=[ %s] }", this.input.toString(), this.condition.toString());
    }

    @Override
    public Column[] getOutputSchema() {
        return this.input.getOutputSchema();
    }

    static final class FilteredDataScanner
    extends DataScanner {
        final DataScanner inputScanner;
        final StatementEvaluationContext context;
        final CompiledSQLExpression condition;
        DataAccessor next;

        FilteredDataScanner(DataScanner inputScanner, CompiledSQLExpression condition, StatementEvaluationContext context) throws DataScannerException {
            super(inputScanner.getTransaction(), inputScanner.getFieldNames(), inputScanner.getSchema());
            this.inputScanner = inputScanner;
            this.context = context;
            this.condition = condition;
            this.fetchNext();
        }

        private void fetchNext() throws DataScannerException {
            DataAccessor candidate;
            Object evaluate;
            do {
                if (this.inputScanner.hasNext()) continue;
                this.next = null;
                return;
            } while (!SQLRecordPredicateFunctions.toBoolean((Object)(evaluate = this.condition.evaluate(candidate = this.inputScanner.next(), this.context))));
            this.next = candidate;
        }

        @Override
        public boolean hasNext() throws DataScannerException {
            return this.next != null;
        }

        @Override
        public DataAccessor next() throws DataScannerException {
            DataAccessor res = this.next;
            if (res == null) {
                throw new DataScannerException("illegal state");
            }
            this.fetchNext();
            return res;
        }

        @Override
        public void rewind() throws DataScannerException {
            this.inputScanner.rewind();
            this.fetchNext();
        }

        @Override
        public boolean isRewindSupported() {
            return this.inputScanner.isRewindSupported();
        }

        @Override
        public void close() throws DataScannerException {
            try {
                this.inputScanner.close();
            }
            finally {
                super.close();
            }
        }
    }
}

