/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import herddb.codec.RecordSerializer;
import herddb.core.TableSpaceManager;
import herddb.model.Column;
import herddb.model.DMLStatement;
import herddb.model.DMLStatementExecutionResult;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.ScanResult;
import herddb.model.Statement;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.Table;
import herddb.model.TableAwareStatement;
import herddb.model.TransactionContext;
import herddb.model.commands.DeleteStatement;
import herddb.model.planner.PlannerOp;
import herddb.model.predicates.RawKeyEquals;
import herddb.utils.Bytes;
import herddb.utils.Wrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public class DeleteOp
implements PlannerOp {
    private final String tableSpace;
    private final String tableName;
    private final PlannerOp input;

    public DeleteOp(String tableSpace, String tableName, PlannerOp input) {
        this.tableSpace = tableSpace;
        this.tableName = tableName;
        this.input = input.optimize();
    }

    @Override
    public String getTablespace() {
        return this.tableSpace;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompletableFuture<StatementExecutionResult> executeAsync(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) {
        boolean returnValues = false;
        StatementExecutionResult input = this.input.execute(tableSpaceManager, transactionContext, context, true, true);
        ScanResult downstreamScanResult = (ScanResult)input;
        Table table = tableSpaceManager.getTableManager(this.tableName).getTable();
        long transactionId = transactionContext.transactionId;
        ArrayList<DeleteStatement> statements = new ArrayList<DeleteStatement>();
        try (DataScanner inputScanner = downstreamScanResult.dataScanner;){
            Object row;
            while (inputScanner.hasNext()) {
                row = inputScanner.next();
                long transactionIdFromScanner = inputScanner.getTransactionId();
                if (transactionIdFromScanner > 0L && transactionIdFromScanner != transactionId) {
                    transactionId = transactionIdFromScanner;
                    transactionContext = new TransactionContext(transactionId);
                }
                Bytes key = RecordSerializer.serializeIndexKey(row, table, table.getPrimaryKey());
                DeleteStatement deleteStatement = new DeleteStatement(this.tableSpace, this.tableName, null, new RawKeyEquals(key));
                statements.add(deleteStatement);
            }
            if (statements.isEmpty()) {
                row = CompletableFuture.completedFuture(new DMLStatementExecutionResult(transactionId, 0, null, null));
                return row;
            }
            if (statements.size() == 1) {
                row = tableSpaceManager.executeStatementAsync((Statement)statements.get(0), context, transactionContext);
                return row;
            }
            CompletableFuture<StatementExecutionResult> finalResult = new CompletableFuture<StatementExecutionResult>();
            AtomicInteger updateCounts = new AtomicInteger();
            AtomicReference lastKey = new AtomicReference();
            AtomicReference lastNewValue = new AtomicReference();
            DMLStatement firstStatement = (DMLStatement)statements.get(0);
            class ComputeNext
            implements BiConsumer<StatementExecutionResult, Throwable> {
                int current;
                final /* synthetic */ CompletableFuture val$finalResult;
                final /* synthetic */ AtomicInteger val$updateCounts;
                final /* synthetic */ AtomicReference val$lastKey;
                final /* synthetic */ AtomicReference val$lastNewValue;
                final /* synthetic */ List val$statements;
                final /* synthetic */ TableSpaceManager val$tableSpaceManager;
                final /* synthetic */ StatementEvaluationContext val$context;

                public ComputeNext(int current) {
                    this.val$finalResult = completableFuture;
                    this.val$updateCounts = atomicInteger;
                    this.val$lastKey = atomicReference;
                    this.val$lastNewValue = atomicReference2;
                    this.val$statements = list;
                    this.val$tableSpaceManager = tableSpaceManager;
                    this.val$context = statementEvaluationContext;
                    this.current = current;
                }

                @Override
                public void accept(StatementExecutionResult res, Throwable error) {
                    if (error != null) {
                        this.val$finalResult.completeExceptionally(error);
                        return;
                    }
                    DMLStatementExecutionResult dml = (DMLStatementExecutionResult)res;
                    this.val$updateCounts.addAndGet(dml.getUpdateCount());
                    long newTransactionId = res.transactionId;
                    if (this.current == this.val$statements.size()) {
                        DMLStatementExecutionResult finalDMLResult = new DMLStatementExecutionResult(newTransactionId, this.val$updateCounts.get(), (Bytes)this.val$lastKey.get(), (Bytes)this.val$lastNewValue.get());
                        this.val$finalResult.complete(finalDMLResult);
                        return;
                    }
                    DMLStatement nextStatement = (DMLStatement)this.val$statements.get(this.current);
                    TransactionContext transactionContext = new TransactionContext(newTransactionId);
                    CompletableFuture<StatementExecutionResult> nextPromise = this.val$tableSpaceManager.executeStatementAsync(nextStatement, this.val$context, transactionContext);
                    nextPromise.whenComplete((BiConsumer)new ComputeNext(this.current + 1));
                }
            }
            tableSpaceManager.executeStatementAsync(firstStatement, context, transactionContext).whenComplete((BiConsumer)new ComputeNext(1));
            CompletableFuture<StatementExecutionResult> completableFuture = finalResult;
            return completableFuture;
        }
        catch (DataScannerException err) {
            throw new StatementExecutionException(err);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(TableAwareStatement.class)) {
            return (T)new TableAwareStatement(this.tableName, this.tableSpace){};
        }
        return (T)Wrapper.unwrap((Object)this, clazz);
    }

    public String toString() {
        return String.format("DeleteOp {input = %s }", this.input.toString());
    }

    @Override
    public Column[] getOutputSchema() {
        return new Column[0];
    }
}

