/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.core.MaterializedRecordSet;
import herddb.core.RecordSetFactory;
import herddb.core.SimpleDataScanner;
import herddb.core.TableSpaceManager;
import herddb.model.Column;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.ScanResult;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.model.Tuple;
import herddb.model.planner.PlannerOp;
import herddb.sql.AggregatedColumnCalculator;
import herddb.sql.expressions.AccessCurrentRowExpression;
import herddb.sql.functions.BuiltinFunctions;
import herddb.utils.DataAccessor;
import herddb.utils.Wrapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"})
public class AggregateOp
implements PlannerOp {
    private final PlannerOp input;
    private final String[] fieldnames;
    private final Column[] columns;
    private final String[] aggtypes;
    private final List<Integer> groupedFiledsIndexes;
    private final List<List<Integer>> argLists;

    public AggregateOp(PlannerOp input, String[] fieldnames, Column[] columns, String[] aggtypes, List<List<Integer>> argLists, List<Integer> groupedFieldsIndexes) {
        this.input = input;
        this.fieldnames = fieldnames;
        this.columns = columns;
        this.aggtypes = aggtypes;
        this.groupedFiledsIndexes = groupedFieldsIndexes;
        this.argLists = argLists;
    }

    @Override
    public String getTablespace() {
        return this.input.getTablespace();
    }

    @Override
    public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        StatementExecutionResult input = this.input.execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
        ScanResult downstreamScanResult = (ScanResult)input;
        DataScanner inputScanner = downstreamScanResult.dataScanner;
        AggregatedDataScanner filtered = new AggregatedDataScanner(inputScanner, context, tableSpaceManager.getDbmanager().getRecordSetFactory());
        return new ScanResult(downstreamScanResult.transactionId, filtered);
    }

    public <T> T unwrap(Class<T> clazz) {
        Object unwrapped = this.input.unwrap(clazz);
        if (unwrapped != null) {
            return (T)unwrapped;
        }
        return (T)Wrapper.unwrap((Object)this, clazz);
    }

    public String toString() {
        return "AggregateOp{fieldnames=" + Arrays.toString(this.fieldnames) + ", columns=" + Arrays.toString(this.columns) + ", aggtypes=" + Arrays.toString(this.aggtypes) + ", groupedFiledsIndexes=" + this.groupedFiledsIndexes + ", argLists=" + this.argLists + "\ninput=" + this.input + '}';
    }

    @Override
    public Column[] getOutputSchema() {
        return this.columns;
    }

    private class AggregatedDataScanner
    extends DataScanner {
        private final DataScanner wrapped;
        private DataScanner aggregatedScanner;
        private final StatementEvaluationContext context;
        private final RecordSetFactory recordSetFactory;

        public AggregatedDataScanner(DataScanner wrapped, StatementEvaluationContext context, RecordSetFactory recordSetFactory) throws StatementExecutionException {
            super(wrapped.getTransaction(), AggregateOp.this.fieldnames, AggregateOp.this.columns);
            this.wrapped = wrapped;
            this.context = context;
            this.recordSetFactory = recordSetFactory;
        }

        private Key key(DataAccessor tuple) throws DataScannerException {
            Object[] values = new Object[AggregateOp.this.groupedFiledsIndexes.size()];
            int i = 0;
            Iterator iterator = AggregateOp.this.groupedFiledsIndexes.iterator();
            while (iterator.hasNext()) {
                int posInUpstreamRow = (Integer)iterator.next();
                Object value = tuple.get(posInUpstreamRow);
                values[i++] = value;
            }
            return new Key(values);
        }

        /*
         * WARNING - void declaration
         */
        private void compute() throws DataScannerException {
            try {
                if (!AggregateOp.this.groupedFiledsIndexes.isEmpty()) {
                    HashMap<Object, Group> groups = new HashMap<Object, Group>();
                    while (this.wrapped.hasNext()) {
                        void var4_8;
                        DataAccessor tuple = this.wrapped.next();
                        Key key = this.key(tuple);
                        Group group = (Group)groups.get(key);
                        if (group == null) {
                            Group group2 = this.createGroup();
                            groups.put(key, group2);
                        }
                        for (AggregatedColumnCalculator cc : var4_8.columns) {
                            cc.consume(tuple);
                        }
                    }
                    MaterializedRecordSet results = this.recordSetFactory.createFixedSizeRecordSet(groups.values().size(), this.getFieldNames(), this.getSchema());
                    for (Map.Entry entry : groups.entrySet()) {
                        Key key = (Key)entry.getKey();
                        Group group = (Group)entry.getValue();
                        AggregatedColumnCalculator[] columns = group.columns;
                        Object[] values = new Object[AggregateOp.this.fieldnames.length];
                        int k = 0;
                        for (Object field : key.values) {
                            values[k++] = field;
                        }
                        for (AggregatedColumnCalculator cc : columns) {
                            values[k++] = cc.getValue();
                        }
                        Tuple tuple = new Tuple(AggregateOp.this.fieldnames, values);
                        results.add((DataAccessor)tuple);
                    }
                    results.writeFinished();
                    this.aggregatedScanner = new SimpleDataScanner(this.wrapped.getTransaction(), results);
                } else {
                    Group group = this.createGroup();
                    AggregatedColumnCalculator[] columns = group.columns;
                    while (this.wrapped.hasNext()) {
                        DataAccessor tuple = this.wrapped.next();
                        for (AggregatedColumnCalculator cc : columns) {
                            cc.consume(tuple);
                        }
                    }
                    Object[] values = new Object[AggregateOp.this.fieldnames.length];
                    boolean bl = false;
                    for (AggregatedColumnCalculator cc : columns) {
                        values[++var4_15] = cc.getValue();
                    }
                    Tuple tuple = new Tuple(AggregateOp.this.fieldnames, values);
                    MaterializedRecordSet results = this.recordSetFactory.createFixedSizeRecordSet(1, this.getFieldNames(), this.getSchema());
                    results.add((DataAccessor)tuple);
                    results.writeFinished();
                    this.aggregatedScanner = new SimpleDataScanner(this.wrapped.getTransaction(), results);
                }
            }
            catch (StatementExecutionException err) {
                throw new DataScannerException((Throwable)((Object)err));
            }
        }

        private Group createGroup() throws DataScannerException, StatementExecutionException {
            AggregatedColumnCalculator[] columns = new AggregatedColumnCalculator[AggregateOp.this.aggtypes.length];
            int firstIndexAggregatedColumn = AggregateOp.this.fieldnames.length - AggregateOp.this.aggtypes.length;
            for (int i = 0; i < AggregateOp.this.aggtypes.length; ++i) {
                String aggtype = AggregateOp.this.aggtypes[i];
                String fieldName = AggregateOp.this.fieldnames[i];
                List argList = (List)AggregateOp.this.argLists.get(i);
                int type = ((AggregateOp)AggregateOp.this).columns[firstIndexAggregatedColumn + i].type;
                AccessCurrentRowExpression param = argList.isEmpty() ? null : new AccessCurrentRowExpression((Integer)argList.get(0), type);
                AggregatedColumnCalculator calculator = BuiltinFunctions.getColumnCalculator(aggtype.toLowerCase(), fieldName, type, param, this.context);
                if (calculator == null) {
                    throw new StatementExecutionException("not implemented aggregation type " + aggtype);
                }
                columns[i] = calculator;
            }
            return new Group(columns);
        }

        @Override
        public boolean hasNext() throws DataScannerException {
            if (this.aggregatedScanner == null) {
                this.compute();
            }
            return this.aggregatedScanner.hasNext();
        }

        @Override
        public DataAccessor next() throws DataScannerException {
            if (this.aggregatedScanner == null) {
                this.compute();
            }
            return this.aggregatedScanner.next();
        }

        @Override
        public void close() throws DataScannerException {
            this.wrapped.close();
            if (this.aggregatedScanner != null) {
                this.aggregatedScanner.close();
            }
            super.close();
        }

        private class Key {
            final Object[] values;

            public Key(Object[] values) {
                this.values = values;
            }

            public int hashCode() {
                int hash = 7;
                hash = 71 * hash + Arrays.deepHashCode(this.values);
                return hash;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                return Arrays.deepEquals(this.values, other.values);
            }
        }
    }

    private static class Group {
        AggregatedColumnCalculator[] columns;

        public Group(AggregatedColumnCalculator[] columns) {
            this.columns = columns;
        }
    }
}

