/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.commands;

import herddb.model.Column;
import herddb.model.Predicate;
import herddb.model.Projection;
import herddb.model.ScanLimits;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import herddb.model.TableAwareStatement;
import herddb.model.TupleComparator;
import herddb.model.planner.SortOp;
import java.util.Arrays;

public class ScanStatement
extends TableAwareStatement {
    private Predicate predicate;
    private Projection projection;
    private TupleComparator comparator;
    private ScanLimits limits;
    private Table tableDef;
    private boolean allowExecutionFromFollower = false;

    public ScanStatement(String tableSpace, Table table, Predicate predicate) {
        this(tableSpace, table, Projection.IDENTITY(table.columnNames, table.columns), predicate);
    }

    public ScanStatement(String tableSpace, Table table, Projection projection, Predicate predicate) {
        this(tableSpace, table.name, projection, predicate, null, null);
        this.tableDef = table;
    }

    public ScanStatement(String tableSpace, String table, Projection projection, Predicate predicate, TupleComparator comparator, ScanLimits limits) {
        super(table, tableSpace);
        this.predicate = predicate;
        this.projection = projection;
        this.comparator = comparator;
        this.limits = limits;
    }

    public Table getTableDef() {
        return this.tableDef;
    }

    public ScanLimits getLimits() {
        return this.limits;
    }

    public TupleComparator getComparator() {
        return this.comparator;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public boolean getAllowExecutionFromFollower() {
        return this.allowExecutionFromFollower;
    }

    public void setAllowExecutionFromFollower(boolean allowExecutionFromFollower) {
        this.allowExecutionFromFollower = allowExecutionFromFollower;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void setComparator(TupleComparator comparator) {
        this.comparator = comparator;
    }

    public void setLimits(ScanLimits limits) {
        this.limits = limits;
    }

    public String toString() {
        String comparatorString = "";
        if (this.comparator != null) {
            comparatorString = this.comparator instanceof SortOp ? "SortOp" : this.comparator.toString();
        }
        String schema = Arrays.toString(this.getSchema());
        if (this.limits != null) {
            return "ScanStatement{table=" + this.table + ",predicate=" + this.predicate + ",proj=" + this.projection + ", comparator=" + comparatorString + ",limits=" + this.limits.toStringForScan() + ", schema=" + schema + '}';
        }
        return "ScanStatement{table=" + this.table + ",predicate=" + this.predicate + ",proj=" + this.projection + ", comparator=" + comparatorString + ", schema=" + schema + '}';
    }

    @Override
    public void validateContext(StatementEvaluationContext context) throws StatementExecutionException {
        if (this.predicate != null) {
            this.predicate.validateContext(context);
        }
    }

    public void setTableDef(Table table) {
        this.tableDef = table;
    }

    @Override
    public int estimateObjectSizeForCache() {
        int res = super.estimateObjectSizeForCache() + 4;
        if (this.predicate != null) {
            res += this.predicate.estimateObjectSizeForCache();
        }
        if (this.limits != null) {
            res += 16;
        }
        if (this.comparator != null) {
            res += 16;
        }
        if (this.projection != null) {
            res += 16;
        }
        return res;
    }

    public Column[] getSchema() {
        if (this.projection != null) {
            return this.projection.getColumns();
        }
        return this.tableDef.getColumns();
    }
}

