/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import herddb.core.HerdDBInternalException;
import herddb.log.CommitLogResult;
import herddb.log.LogNotAvailableException;
import herddb.log.LogSequenceNumber;
import herddb.model.Index;
import herddb.model.Record;
import herddb.model.Table;
import herddb.utils.Bytes;
import herddb.utils.ExtendedDataInputStream;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.ILocalLockManager;
import herddb.utils.LockHandle;
import herddb.utils.SimpleByteArrayInputStream;
import herddb.utils.VisibleByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.map.HashedMap;

public class Transaction {
    public final long transactionId;
    public final String tableSpace;
    public final Map<String, HashedMap> locks;
    public final Map<String, Map<Bytes, Record>> changedRecords;
    public final Map<String, Map<Bytes, Record>> newRecords;
    public final Map<String, Set<Bytes>> deletedRecords;
    public Map<String, Table> newTables;
    public Map<String, Index> newIndexes;
    public Set<String> droppedTables;
    public Set<String> droppedIndexes;
    public LogSequenceNumber lastSequenceNumber;
    public final long localCreationTimestamp;
    private final List<CommitLogResult> deferredWrites = new ArrayList<CommitLogResult>();
    public volatile long lastActivityTs = System.currentTimeMillis();
    private final AtomicInteger refCount = new AtomicInteger();
    private static final Logger LOG = Logger.getLogger(Transaction.class.getName());

    public Transaction(long transactionId, String tableSpace, CommitLogResult lastSequenceNumber) {
        this.transactionId = transactionId;
        this.tableSpace = tableSpace;
        this.locks = new HashMap<String, HashedMap>();
        this.changedRecords = new HashMap<String, Map<Bytes, Record>>();
        this.newRecords = new HashMap<String, Map<Bytes, Record>>();
        this.deletedRecords = new HashMap<String, Set<Bytes>>();
        this.lastSequenceNumber = lastSequenceNumber.deferred ? null : lastSequenceNumber.getLogSequenceNumber();
        this.localCreationTimestamp = System.currentTimeMillis();
    }

    public void increaseRefcount() {
        this.refCount.incrementAndGet();
    }

    public void decreaseRefCount() {
        int res = this.refCount.decrementAndGet();
        if (res < 0) {
            LOG.log(Level.SEVERE, "transaction {0} on tablespace {1} has {2} pending activities", new Object[]{this.transactionId, this.tableSpace, res});
            throw new IllegalStateException(String.format("transaction {0} on tablespace {1} has {2} pending activities", this.transactionId, this.tableSpace, res));
        }
    }

    public boolean hasPendingActivities() {
        return this.refCount.get() > 0;
    }

    public int getRefCount() {
        return this.refCount.get();
    }

    public void touch() {
        this.lastActivityTs = System.currentTimeMillis();
    }

    public LockHandle lookupLock(String tableName, Bytes key) {
        HashedMap ll = this.locks.get(tableName);
        if (ll == null || ll.isEmpty()) {
            return null;
        }
        return (LockHandle)ll.get((Object)key);
    }

    public void registerLockOnTable(String tableName, LockHandle handle) {
        HashedMap ll = this.locks.get(tableName);
        if (ll == null) {
            ll = new HashedMap();
            this.locks.put(tableName, ll);
        }
        ll.put((Object)handle.key, (Object)handle);
    }

    public synchronized void registerNewTable(Table table, CommitLogResult writeResult) {
        if (this.updateLastSequenceNumber(writeResult)) {
            return;
        }
        if (this.newTables == null) {
            this.newTables = new HashMap<String, Table>();
        }
        this.newTables.put(table.name, table);
        if (this.droppedTables == null) {
            this.droppedTables = new HashSet<String>();
        }
        this.droppedTables.remove(table.name);
    }

    private boolean updateLastSequenceNumber(CommitLogResult writeResult) throws LogNotAvailableException {
        this.touch();
        if (writeResult.deferred) {
            this.deferredWrites.add(writeResult);
            return false;
        }
        LogSequenceNumber sequenceNumber = writeResult.getLogSequenceNumber();
        if (this.lastSequenceNumber != null && this.lastSequenceNumber.after(sequenceNumber)) {
            return true;
        }
        this.lastSequenceNumber = sequenceNumber;
        return false;
    }

    public synchronized void registerNewIndex(Index index, CommitLogResult writeResult) {
        if (this.updateLastSequenceNumber(writeResult)) {
            return;
        }
        if (this.newIndexes == null) {
            this.newIndexes = new HashMap<String, Index>();
        }
        this.newIndexes.put(index.name, index);
        if (this.droppedIndexes == null) {
            this.droppedIndexes = new HashSet<String>();
        }
        this.droppedIndexes.remove(index.name);
    }

    public synchronized void registerInsertOnTable(String tableName, Bytes key, Bytes value, CommitLogResult writeResult) {
        boolean removed;
        if (this.updateLastSequenceNumber(writeResult)) {
            return;
        }
        Set<Bytes> deleted = this.deletedRecords.get(tableName);
        if (deleted != null && (removed = deleted.remove(key))) {
            this.registerRecordUpdate(tableName, key, value, writeResult);
            return;
        }
        Map<Bytes, Record> ll = this.newRecords.get(tableName);
        if (ll == null) {
            ll = new HashMap<Bytes, Record>();
            this.newRecords.put(tableName, ll);
        }
        ll.put(key, new Record(key, value));
    }

    public void releaseLocksOnTable(String tableName, ILocalLockManager lockManager) {
        Map ll = (Map)this.locks.get(tableName);
        if (ll != null) {
            for (LockHandle l : ll.values()) {
                lockManager.releaseLock(l);
            }
        }
    }

    public void unregisterUpgradedLocksOnTable(String tableName, LockHandle lock) {
        Map ll = (Map)this.locks.get(tableName);
        if (ll != null) {
            Iterator it = ll.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry next = it.next();
                if (next.getValue() != lock) continue;
                it.remove();
                break;
            }
        }
    }

    public synchronized boolean registerRecordUpdate(String tableName, Bytes key, Bytes value, CommitLogResult writeResult) {
        if (this.updateLastSequenceNumber(writeResult)) {
            return false;
        }
        Map<Bytes, Record> newRecordsForTable = this.newRecords.get(tableName);
        if (newRecordsForTable != null && newRecordsForTable.containsKey(key)) {
            if (value == null) {
                newRecordsForTable.remove(key);
            } else {
                newRecordsForTable.put(key, new Record(key, value));
            }
            return true;
        }
        Map<Bytes, Record> ll = this.changedRecords.get(tableName);
        if (ll == null) {
            ll = new HashMap<Bytes, Record>();
            this.changedRecords.put(tableName, ll);
        }
        if (value == null) {
            ll.remove(key);
        } else {
            ll.put(key, new Record(key, value));
        }
        return false;
    }

    public synchronized void registerDeleteOnTable(String tableName, Bytes key, CommitLogResult writeResult) {
        if (!writeResult.deferred && this.lastSequenceNumber != null && this.lastSequenceNumber.after(writeResult.getLogSequenceNumber())) {
            return;
        }
        boolean wasANewRecord = this.registerRecordUpdate(tableName, key, null, writeResult);
        if (wasANewRecord) {
            return;
        }
        Set<Bytes> ll = this.deletedRecords.get(tableName);
        if (ll == null) {
            ll = new HashSet<Bytes>();
            this.deletedRecords.put(tableName, ll);
        }
        ll.add(key);
    }

    public boolean recordDeleted(String tableName, Bytes key) {
        Set<Bytes> deleted = this.deletedRecords.get(tableName);
        return deleted != null && deleted.contains(key);
    }

    public Record recordInserted(String tableName, Bytes key) {
        Map<Bytes, Record> inserted = this.newRecords.get(tableName);
        if (inserted == null) {
            return null;
        }
        return inserted.get(key);
    }

    public Record recordUpdated(String tableName, Bytes key) {
        Map<Bytes, Record> updated = this.changedRecords.get(tableName);
        if (updated == null) {
            return null;
        }
        return updated.get(key);
    }

    public Collection<Record> getNewRecordsForTable(String tableName) {
        Map<Bytes, Record> inserted = this.newRecords.get(tableName);
        if (inserted == null || inserted.isEmpty()) {
            return null;
        }
        return inserted.values();
    }

    public String toString() {
        return "Transaction{transactionId=" + this.transactionId + ", tableSpace=" + this.tableSpace + ", refcount " + this.refCount + ", locks=" + this.locks.size() + ", changedRecords=" + this.changedRecords.size() + ", newRecords=" + this.newRecords.size() + ", deletedRecords=" + this.deletedRecords.size() + ", newTables=" + this.newTables + ", newIndexes=" + this.newIndexes + '}';
    }

    public synchronized void registerDropTable(String tableName, CommitLogResult writeResult) {
        if (this.updateLastSequenceNumber(writeResult)) {
            return;
        }
        if (this.newTables == null) {
            this.newTables = new HashMap<String, Table>();
        }
        this.newTables.remove(tableName);
        if (this.droppedTables == null) {
            this.droppedTables = new HashSet<String>();
        }
        this.droppedTables.add(tableName);
    }

    public synchronized void registerDropIndex(String indexName, CommitLogResult writeResult) {
        if (this.updateLastSequenceNumber(writeResult)) {
            return;
        }
        if (this.newIndexes == null) {
            this.newIndexes = new HashMap<String, Index>();
        }
        this.newIndexes.remove(indexName);
        if (this.droppedIndexes == null) {
            this.droppedIndexes = new HashSet<String>();
        }
        this.droppedIndexes.add(indexName);
    }

    public boolean isTableDropped(String tableName) {
        return this.droppedTables != null && this.droppedTables.contains(tableName) && (this.newTables == null || !this.newTables.containsKey(tableName));
    }

    public boolean isIndexDropped(String indexName) {
        return this.droppedIndexes != null && this.droppedIndexes.contains(indexName) && (this.newIndexes == null || !this.newIndexes.containsKey(indexName));
    }

    public byte[] serialize() {
        VisibleByteArrayOutputStream oo = new VisibleByteArrayOutputStream(1024);
        try (ExtendedDataOutputStream ooo = new ExtendedDataOutputStream((OutputStream)oo);){
            this.serialize(ooo);
        }
        catch (IOException impossible) {
            throw new HerdDBInternalException((Throwable)impossible);
        }
        return oo.toByteArray();
    }

    public synchronized void serialize(ExtendedDataOutputStream out) throws IOException {
        out.writeVLong(1L);
        out.writeVLong(0L);
        out.writeZLong(this.transactionId);
        if (this.lastSequenceNumber != null) {
            out.writeZLong(this.lastSequenceNumber.ledgerId);
            out.writeZLong(this.lastSequenceNumber.offset);
        } else {
            out.writeZLong(0L);
            out.writeZLong(0L);
        }
        out.writeVInt(this.changedRecords.size());
        for (Map.Entry<String, Map<Bytes, Record>> entry : this.changedRecords.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeVInt(entry.getValue().size());
            for (Record r : entry.getValue().values()) {
                out.writeArray(r.key);
                out.writeArray(r.value);
            }
        }
        out.writeVInt(this.newRecords.size());
        for (Map.Entry<String, Map<Bytes, Record>> entry : this.newRecords.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeVInt(entry.getValue().size());
            for (Record r : entry.getValue().values()) {
                out.writeArray(r.key);
                out.writeArray(r.value);
            }
        }
        out.writeVInt(this.deletedRecords.size());
        for (Map.Entry<String, Object> entry : this.deletedRecords.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeVInt(((Set)entry.getValue()).size());
            for (Bytes key : (Set)entry.getValue()) {
                out.writeArray(key);
            }
        }
        if (this.newTables == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.newTables.size());
            for (Table table : this.newTables.values()) {
                out.writeArray(table.serialize());
            }
        }
        if (this.droppedTables == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.droppedTables.size());
            for (String string : this.droppedTables) {
                out.writeUTF(string);
            }
        }
        if (this.newIndexes == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.newIndexes.size());
            for (Index index : this.newIndexes.values()) {
                out.writeArray(index.serialize());
            }
        }
        if (this.droppedIndexes == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.droppedIndexes.size());
            for (String string : this.droppedIndexes) {
                out.writeUTF(string);
            }
        }
    }

    public static Transaction deserialize(String tableSpace, byte[] buf) {
        try {
            return Transaction.deserialize(tableSpace, new ExtendedDataInputStream((InputStream)new SimpleByteArrayInputStream(buf)));
        }
        catch (IOException err) {
            throw new HerdDBInternalException((Throwable)err);
        }
    }

    public static Transaction deserialize(String tableSpace, ExtendedDataInputStream in) throws IOException {
        byte[] data;
        Record record;
        Bytes bKey;
        byte[] value;
        byte[] key;
        int k;
        Cloneable records;
        int numRecords;
        String table;
        int i;
        long version = in.readVLong();
        long flags = in.readVLong();
        if (version != 1L || flags != 0L) {
            throw new IOException("corrupted transaction file");
        }
        long id = in.readZLong();
        long ledgerId = in.readZLong();
        long offset = in.readZLong();
        LogSequenceNumber lastSequenceNumber = new LogSequenceNumber(ledgerId, offset);
        Transaction t = new Transaction(id, tableSpace, new CommitLogResult(lastSequenceNumber, false, true));
        int size = in.readVInt();
        for (i = 0; i < size; ++i) {
            table = in.readUTF();
            numRecords = in.readVInt();
            records = new HashMap();
            for (k = 0; k < numRecords; ++k) {
                key = in.readArray();
                value = in.readArray();
                bKey = Bytes.from_array((byte[])key);
                record = new Record(bKey, Bytes.from_array((byte[])value));
                records.put(bKey, record);
            }
            t.changedRecords.put(table, (Map<Bytes, Record>)((Object)records));
        }
        size = in.readVInt();
        for (i = 0; i < size; ++i) {
            table = in.readUTF();
            numRecords = in.readVInt();
            records = new HashMap();
            for (k = 0; k < numRecords; ++k) {
                key = in.readArray();
                value = in.readArray();
                bKey = Bytes.from_array((byte[])key);
                record = new Record(bKey, Bytes.from_array((byte[])value));
                records.put(bKey, record);
            }
            t.newRecords.put(table, (Map<Bytes, Record>)((Object)records));
        }
        size = in.readVInt();
        for (i = 0; i < size; ++i) {
            table = in.readUTF();
            numRecords = in.readVInt();
            records = new HashSet();
            for (k = 0; k < numRecords; ++k) {
                key = in.readArray();
                records.add(Bytes.from_array((byte[])key));
            }
            t.deletedRecords.put(table, (Set<Bytes>)((Object)records));
        }
        size = in.readVInt();
        if (size > 0) {
            t.newTables = new HashMap<String, Table>();
            for (i = 0; i < size; ++i) {
                data = in.readArray();
                Table table2 = Table.deserialize(data);
                t.newTables.put(table2.name, table2);
            }
        }
        if ((size = in.readVInt()) > 0) {
            t.droppedTables = new HashSet<String>();
            for (i = 0; i < size; ++i) {
                t.droppedTables.add(in.readUTF());
            }
        }
        if ((size = in.readVInt()) > 0) {
            t.newIndexes = new HashMap<String, Index>();
            for (i = 0; i < size; ++i) {
                data = in.readArray();
                Index index = Index.deserialize(data);
                t.newIndexes.put(index.name, index);
            }
        }
        if ((size = in.readVInt()) > 0) {
            t.droppedIndexes = new HashSet<String>();
            for (i = 0; i < size; ++i) {
                t.droppedIndexes.add(in.readUTF());
            }
        }
        return t;
    }

    public void releaseLockOnKey(String tableName, Bytes key, ILocalLockManager locksManager) {
        LockHandle lock;
        Map ll = (Map)this.locks.get(tableName);
        if (ll != null && (lock = (LockHandle)ll.remove(key)) != null) {
            locksManager.releaseLock(lock);
        }
    }

    public boolean isNewTable(String name) {
        return this.newTables != null && this.newTables.containsKey(name);
    }

    public boolean isOnTable(String name) {
        return this.locks.containsKey(name) || this.newIndexes != null && this.newIndexes.containsKey(name) || this.newRecords.containsKey(name) || this.deletedRecords.containsKey(name) || this.droppedTables != null && this.droppedTables.contains(name) || this.newTables != null && this.newTables.containsKey(name);
    }

    public void sync() throws LogNotAvailableException {
        this.touch();
        for (CommitLogResult result : this.deferredWrites) {
            LogSequenceNumber number = result.getLogSequenceNumber();
            if (this.lastSequenceNumber != null && !number.after(this.lastSequenceNumber)) continue;
            this.lastSequenceNumber = number;
        }
    }

    public void sync(LogSequenceNumber sequenceNumber) throws LogNotAvailableException {
        this.sync();
        if (this.lastSequenceNumber != null && !sequenceNumber.after(this.lastSequenceNumber)) {
            throw new IllegalStateException("Corrupted transaction, syncing on a position smaller (" + sequenceNumber + ") than transaction last sequence number (" + this.lastSequenceNumber + ")");
        }
        this.lastSequenceNumber = sequenceNumber;
    }

    public boolean isAbandoned(long timestamp) {
        return this.lastActivityTs < timestamp;
    }
}

