/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import herddb.utils.SimpleByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class TableSpaceReplicaState {
    public static final int MODE_LEADER = 1;
    public static final int MODE_FOLLOWER = 2;
    public static final int MODE_STOPPED = 3;
    public final String uuid;
    public final String nodeId;
    public final long timestamp;
    public final int mode;

    public TableSpaceReplicaState(String uuid, String nodeId, long timestamp, int mode) {
        this.uuid = uuid;
        this.nodeId = nodeId;
        this.timestamp = timestamp;
        this.mode = mode;
    }

    public static TableSpaceReplicaState deserialize(byte[] data) throws IOException {
        return TableSpaceReplicaState.deserialize(new DataInputStream((InputStream)new SimpleByteArrayInputStream(data)));
    }

    public static TableSpaceReplicaState deserialize(DataInputStream in) throws IOException {
        in.readInt();
        String uuid = in.readUTF();
        String nodeId = in.readUTF();
        long timestamp = in.readLong();
        int mode = in.readInt();
        return new TableSpaceReplicaState(uuid, nodeId, timestamp, mode);
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream oo = new ByteArrayOutputStream();
        try (DataOutputStream doo = new DataOutputStream(oo);){
            this.serialize(doo);
        }
        return oo.toByteArray();
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeUTF(this.uuid);
        out.writeUTF(this.nodeId);
        out.writeLong(this.timestamp);
        out.writeInt(this.mode);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "TableSpaceReplicaState{uuid=" + this.uuid + ", nodeId=" + this.nodeId + ", timestamp=" + this.timestamp + ", mode=" + this.mode + '}';
    }

    public static String modeToSQLString(int mode) {
        switch (mode) {
            case 1: {
                return "leader";
            }
            case 2: {
                return "follower";
            }
            case 3: {
                return "stopped";
            }
        }
        return "mode?" + mode;
    }

    public static class Builder {
        private String nodeId;
        private String uuid;
        private long timestamp;
        private int mode;

        private Builder() {
        }

        public Builder cloning(TableSpaceReplicaState other) {
            this.uuid = other.uuid;
            this.nodeId = other.nodeId;
            this.timestamp = other.timestamp;
            this.mode = other.mode;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder mode(int mode) {
            this.mode = mode;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public TableSpaceReplicaState build() {
            if (this.uuid == null) {
                throw new IllegalArgumentException("uuid is not defined");
            }
            if (this.nodeId == null) {
                throw new IllegalArgumentException("nodeId is not defined");
            }
            if (this.timestamp <= 0L) {
                throw new IllegalArgumentException("timestamp is not defined");
            }
            if (this.mode <= 0) {
                throw new IllegalArgumentException("mode is not defined");
            }
            return new TableSpaceReplicaState(this.uuid, this.nodeId, this.timestamp, this.mode);
        }
    }
}

