/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import herddb.utils.ExtendedDataInputStream;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.SimpleByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class TableSpace {
    public static final String DEFAULT = "herd";
    public static final String ANY_NODE = "*";
    public final String uuid;
    public final String name;
    public final String leaderId;
    public final Set<String> replicas;
    public final int expectedReplicaCount;
    public final long maxLeaderInactivityTime;
    public final Object metadataStorageVersion;
    public final long metadataStorageCreationTime;

    private TableSpace(String uuid, String name, String leaderId, Set<String> replicas, int expectedReplicaCount, long maxLeaderInactivityTime, Object metadataStorageVersion, long metadataStorageCreationTime) {
        this.name = name;
        this.uuid = uuid;
        this.leaderId = leaderId;
        this.replicas = replicas;
        this.expectedReplicaCount = expectedReplicaCount;
        this.metadataStorageVersion = metadataStorageVersion;
        this.maxLeaderInactivityTime = maxLeaderInactivityTime;
        this.metadataStorageCreationTime = metadataStorageCreationTime;
    }

    public boolean isNodeAssignedToTableSpace(String nodeId) {
        return this.replicas.contains(nodeId) || this.replicas.contains(ANY_NODE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TableSpace deserialize(byte[] data, Object metadataStorageVersion, long metadataStorageCreationTime) throws IOException {
        return TableSpace.deserialize(new ExtendedDataInputStream((InputStream)new SimpleByteArrayInputStream(data)), metadataStorageVersion, metadataStorageCreationTime);
    }

    public static TableSpace deserialize(ExtendedDataInputStream in, Object metadataStorageVersion, long metadataStorageCreationTime) throws IOException {
        long version = in.readVLong();
        long flags = in.readVLong();
        if (version != 1L || flags != 0L) {
            throw new IOException("corrupted tablespace file");
        }
        String uuid = in.readUTF();
        String name = in.readUTF();
        String leaderId = in.readUTF();
        int expectedReplicaCount = in.readVInt();
        int numreplicas = in.readVInt();
        HashSet<String> replicas = new HashSet<String>();
        for (int i = 0; i < numreplicas; ++i) {
            replicas.add(in.readUTF());
        }
        long maxLeaderInactivityTime = in.readVLong();
        return new TableSpace(uuid, name, leaderId, replicas, expectedReplicaCount, maxLeaderInactivityTime, metadataStorageVersion, metadataStorageCreationTime);
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream oo = new ByteArrayOutputStream();
        try (ExtendedDataOutputStream doo = new ExtendedDataOutputStream((OutputStream)oo);){
            this.serialize(doo);
        }
        return oo.toByteArray();
    }

    public void serialize(ExtendedDataOutputStream out) throws IOException {
        out.writeVLong(1L);
        out.writeVLong(0L);
        out.writeUTF(this.uuid);
        out.writeUTF(this.name);
        out.writeUTF(this.leaderId);
        out.writeVInt(this.expectedReplicaCount);
        out.writeVInt(this.replicas.size());
        for (String replica : this.replicas) {
            out.writeUTF(replica);
        }
        out.writeVLong(this.maxLeaderInactivityTime);
    }

    public String toString() {
        return "TableSpace{uuid=" + this.uuid + ", name=" + this.name + ", leaderId=" + this.leaderId + ", replicas=" + this.replicas + ", expectedReplicaCount=" + this.expectedReplicaCount + ", maxLeaderInactivityTime=" + this.maxLeaderInactivityTime + ", metadataStorageVersion=" + this.metadataStorageVersion + '}';
    }

    public static class Builder {
        private final Set<String> replicas = new HashSet<String>();
        private String name;
        private String uuid;
        private String leaderId;
        private int expectedReplicaCount = 1;
        private long maxLeaderInactivityTime = 0L;

        private Builder() {
        }

        public Builder cloning(TableSpace tableSpace) {
            this.uuid = tableSpace.uuid;
            this.name = tableSpace.name;
            this.replicas.clear();
            this.replicas.addAll(tableSpace.replicas);
            this.leaderId = tableSpace.leaderId;
            this.expectedReplicaCount = tableSpace.expectedReplicaCount;
            this.maxLeaderInactivityTime = tableSpace.maxLeaderInactivityTime;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder expectedReplicaCount(int expectedReplicaCount) {
            this.expectedReplicaCount = expectedReplicaCount;
            return this;
        }

        public Builder maxLeaderInactivityTime(long maxLeaderInactivityTime) {
            this.maxLeaderInactivityTime = maxLeaderInactivityTime;
            return this;
        }

        public Builder replica(String id) {
            this.replicas.add(id);
            return this;
        }

        public Builder replicas(Set<String> replicas) {
            this.replicas.clear();
            this.replicas.addAll(replicas);
            return this;
        }

        public Builder leader(String id) {
            this.leaderId = id;
            return this;
        }

        public TableSpace build() {
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID().toString().replace("-", "");
            }
            if (this.uuid.isEmpty()) {
                throw new IllegalArgumentException("uuid is not defined");
            }
            if (this.name == null || this.name.isEmpty()) {
                throw new IllegalArgumentException("name is not defined");
            }
            if (this.replicas.isEmpty()) {
                throw new IllegalArgumentException("not replica defined");
            }
            if (this.leaderId == null || this.leaderId.isEmpty()) {
                this.leaderId = this.replicas.iterator().next();
            }
            if (!this.replicas.contains(this.leaderId) && !this.replicas.contains(TableSpace.ANY_NODE)) {
                throw new IllegalArgumentException("leader " + this.leaderId + " must be in replica list " + this.replicas);
            }
            if (this.expectedReplicaCount <= 0) {
                throw new IllegalArgumentException("expectedReplicaCount must be > 0");
            }
            if (this.maxLeaderInactivityTime > 0L && this.maxLeaderInactivityTime < 5000L) {
                throw new IllegalArgumentException("maxLeaderInactivityTime must be >= 5000");
            }
            return new TableSpace(this.uuid, this.name, this.leaderId, Collections.unmodifiableSet(this.replicas), this.expectedReplicaCount, this.maxLeaderInactivityTime, null, 0L);
        }
    }
}

