/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import herddb.model.MissingJDBCParameterException;
import herddb.model.ScanLimits;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;

public class ScanLimitsImpl
implements ScanLimits {
    private final int maxRows;
    private final int offset;
    private final int maxRowsJdbcParameterIndex;

    public ScanLimitsImpl(int maxRows, int offset) {
        this.maxRows = maxRows;
        this.offset = offset;
        this.maxRowsJdbcParameterIndex = 0;
    }

    public ScanLimitsImpl(int maxRows, int offset, int maxRowsJdbcParameterIndex) {
        this.maxRows = maxRows;
        this.offset = offset;
        this.maxRowsJdbcParameterIndex = maxRowsJdbcParameterIndex;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getMaxRowsJdbcParameterIndex() {
        return this.maxRowsJdbcParameterIndex;
    }

    public String toString() {
        return "ScanLimits{maxRows=" + this.maxRows + ", offset=" + this.offset + '}';
    }

    @Override
    public String toStringForScan() {
        return this.toString();
    }

    @Override
    public int computeMaxRows(StatementEvaluationContext context) throws StatementExecutionException {
        if (this.maxRowsJdbcParameterIndex <= 0) {
            return this.maxRows;
        }
        try {
            Object limit = context.getJdbcParameter(this.maxRowsJdbcParameterIndex - 1);
            if (limit == null) {
                throw new StatementExecutionException("Invalid LIMIT with NULL JDBC Parameter");
            }
            if (limit instanceof Number) {
                return ((Number)limit).intValue();
            }
            try {
                return Integer.parseInt(limit + "");
            }
            catch (IllegalArgumentException ee) {
                throw new StatementExecutionException("Invalid LIMIT JDBC Parameter: value is " + limit);
            }
        }
        catch (IndexOutOfBoundsException err) {
            throw new MissingJDBCParameterException(this.maxRowsJdbcParameterIndex);
        }
    }

    @Override
    public int computeOffset(StatementEvaluationContext context) throws StatementExecutionException {
        return this.offset;
    }
}

