/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import herddb.model.Column;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import herddb.model.Tuple;
import herddb.model.planner.ProjectOp;
import herddb.utils.DataAccessor;

public interface Projection {
    public static Projection IDENTITY(String[] fieldNames, Column[] columns) {
        return new ProjectOp.IdentityProjection(fieldNames, columns);
    }

    public static Projection PRIMARY_KEY(final Table table) {
        final Column[] columns = new Column[table.primaryKey.length];
        int i = 0;
        for (String pk : table.primaryKey) {
            columns[i++] = table.getColumn(pk);
        }
        return new Projection(){

            @Override
            public Column[] getColumns() {
                return table.columns;
            }

            @Override
            public String[] getFieldNames() {
                return table.primaryKey;
            }

            public Tuple map(DataAccessor tuple, StatementEvaluationContext context) throws StatementExecutionException {
                Object[] values = new Object[columns.length];
                for (int i = 0; i < values.length; ++i) {
                    Object v;
                    values[i] = v = tuple.get(columns[i].name);
                }
                return new Tuple(table.primaryKey, values);
            }
        };
    }

    public Column[] getColumns();

    public String[] getFieldNames();

    public DataAccessor map(DataAccessor var1, StatementEvaluationContext var2) throws StatementExecutionException;
}

