/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.model.Column;
import herddb.model.ColumnsList;
import herddb.model.Table;
import herddb.utils.ExtendedDataInputStream;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.SimpleByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public class Index
implements ColumnsList {
    public static final String TYPE_HASH = "hash";
    public static final String TYPE_BRIN = "brin";
    private static final int PROPERTY_UNIQUE = 1;
    public final String name;
    public final String uuid;
    public final String table;
    public final String type;
    public final String tablespace;
    public final Column[] columns;
    public final String[] columnNames;
    public final Map<String, Column> columnByName = new HashMap<String, Column>();
    public final boolean unique;

    @Override
    public String[] getPrimaryKey() {
        return this.columnNames;
    }

    @Override
    public boolean allowNullsForIndexedValues() {
        return true;
    }

    private Index(String uuid, String name, String table, String tablespace, String type, Column[] columns, boolean unique) {
        this.name = name;
        this.unique = unique;
        this.uuid = uuid;
        this.table = table;
        this.tablespace = tablespace;
        this.columns = columns;
        this.type = type;
        this.columnNames = new String[columns.length];
        int i = 0;
        for (Column c : columns) {
            this.columnNames[i++] = c.name;
            this.columnByName.put(c.name, c);
        }
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public Column getColumn(String name) {
        return this.columnByName.get(name);
    }

    public static Builder builder() {
        return new Builder();
    }

    @SuppressFBWarnings(value={"OS_OPEN_STREAM"})
    public static Index deserialize(byte[] data) {
        try {
            SimpleByteArrayInputStream ii = new SimpleByteArrayInputStream(data);
            ExtendedDataInputStream dii = new ExtendedDataInputStream((InputStream)ii);
            long iversion = dii.readVLong();
            long iflags = dii.readVLong();
            if (iversion != 1L || iflags != 0L) {
                throw new IOException("corrupted index file");
            }
            String tablespace = dii.readUTF();
            String name = dii.readUTF();
            String uuid = dii.readUTF();
            String table = dii.readUTF();
            int properties = dii.readVInt();
            boolean unique = false;
            if ((properties & 1) == 1) {
                unique = true;
            }
            String type = dii.readUTF();
            int ncols = dii.readVInt();
            Column[] columns = new Column[ncols];
            for (int i = 0; i < ncols; ++i) {
                long cversion = dii.readVLong();
                long cflags = dii.readVLong();
                if (cversion != 1L || cflags != 0L) {
                    throw new IOException("corrupted index file");
                }
                String cname = dii.readUTF();
                int ctype = dii.readVInt();
                int serialPosition = dii.readVInt();
                dii.readVInt();
                columns[i] = Column.column(cname, ctype, serialPosition);
            }
            return new Index(uuid, name, table, tablespace, type, columns, unique);
        }
        catch (IOException err) {
            throw new IllegalArgumentException(err);
        }
    }

    public byte[] serialize() {
        ByteArrayOutputStream oo = new ByteArrayOutputStream();
        try (ExtendedDataOutputStream doo = new ExtendedDataOutputStream((OutputStream)oo);){
            doo.writeVLong(1L);
            doo.writeVLong(0L);
            doo.writeUTF(this.tablespace);
            doo.writeUTF(this.name);
            doo.writeUTF(this.uuid);
            doo.writeUTF(this.table);
            int properties = 0;
            if (this.unique) {
                properties |= 1;
            }
            doo.writeVInt(properties);
            doo.writeUTF(this.type);
            doo.writeVInt(this.columns.length);
            for (Column c : this.columns) {
                doo.writeVLong(1L);
                doo.writeVLong(0L);
                doo.writeUTF(c.name);
                doo.writeVInt(c.type);
                doo.writeVInt(c.serialPosition);
                doo.writeVInt(0);
            }
        }
        catch (IOException ee) {
            throw new RuntimeException(ee);
        }
        return oo.toByteArray();
    }

    public String toString() {
        return this.type + "INDEX{name=" + this.table + '.' + this.name + " (" + Arrays.toString(this.columnNames) + ")";
    }

    public static class Builder {
        private final List<Column> columns = new ArrayList<Column>();
        private String name;
        private String uuid;
        private String table;
        private String type = "hash";
        private String tablespace = "herd";
        private boolean unique;

        private Builder() {
        }

        public Builder onTable(Table table) {
            this.table = table.name;
            this.tablespace = table.tablespace;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder unique(boolean unique) {
            this.unique = unique;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder table(String table) {
            this.table = table;
            return this;
        }

        public Builder tablespace(String tablespace) {
            this.tablespace = tablespace;
            return this;
        }

        public Builder column(String name, int type) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException();
            }
            if (this.columns.stream().filter(c -> c.name.equals(name)).findAny().isPresent()) {
                throw new IllegalArgumentException("column " + name + " already exists");
            }
            this.columns.add(Column.column(name, type, 0));
            return this;
        }

        public Index build() {
            if (this.table == null || this.table.isEmpty()) {
                throw new IllegalArgumentException("table is not defined");
            }
            if (!Index.TYPE_HASH.equals(this.type) && !Index.TYPE_BRIN.equals(this.type)) {
                throw new IllegalArgumentException("only index type hash,brin are supported");
            }
            if (this.columns.isEmpty()) {
                throw new IllegalArgumentException("specify at least one column to index");
            }
            if (this.name == null || this.name.isEmpty()) {
                this.name = this.table + "_" + this.columns.stream().map(s -> s.name.toLowerCase()).collect(Collectors.joining("_"));
            }
            if (this.uuid == null || this.uuid.isEmpty()) {
                this.uuid = UUID.randomUUID().toString();
            }
            return new Index(this.uuid, this.name, this.table, this.tablespace, this.type, this.columns.toArray(new Column[this.columns.size()]), this.unique);
        }
    }
}

