/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public final class ForeignKeyDef {
    public static final int ACTION_NO_ACTION = 0;
    public static final int ACTION_CASCADE = 1;
    public static final int ACTION_SETNULL = 2;
    public final String name;
    public final String parentTableId;
    public final String[] columns;
    public final String[] parentTableColumns;
    public final int onUpdateAction;
    public final int onDeleteAction;

    public static Builder builder() {
        return new Builder();
    }

    private ForeignKeyDef(String name, String parentTableId, String[] columns, String[] parentTableColumns, int onUpdateAction, int onDeleteAction) {
        this.name = name;
        this.parentTableId = parentTableId;
        this.columns = columns;
        this.parentTableColumns = parentTableColumns;
        this.onUpdateAction = onUpdateAction;
        this.onDeleteAction = onDeleteAction;
    }

    public static class Builder {
        private String name = UUID.randomUUID().toString();
        private String parentTableId;
        private final List<String> columns = new ArrayList<String>();
        private final List<String> parentTableColumns = new ArrayList<String>();
        private int onUpdateAction;
        private int onDeleteAction;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder parentTableId(String parentTableId) {
            this.parentTableId = parentTableId;
            return this;
        }

        public Builder column(String column) {
            this.columns.add(column);
            return this;
        }

        public Builder parentTableColumn(String parentTableColumn) {
            this.parentTableColumns.add(parentTableColumn);
            return this;
        }

        public Builder onUpdateAction(int onUpdateAction) {
            this.onUpdateAction = onUpdateAction;
            return this;
        }

        public Builder onDeleteAction(int onDeleteCascadeAction) {
            this.onDeleteAction = onDeleteCascadeAction;
            return this;
        }

        public ForeignKeyDef build() {
            if (this.parentTableId == null || this.parentTableId.isEmpty()) {
                throw new IllegalArgumentException("parentTableId must be set");
            }
            if (this.onUpdateAction != 0 && this.onUpdateAction != 2) {
                throw new IllegalArgumentException("invalid onUpdateAction " + this.onDeleteAction);
            }
            if (this.onDeleteAction != 0 && this.onDeleteAction != 1 && this.onDeleteAction != 2) {
                throw new IllegalArgumentException("invalid onDeleteAction " + this.onDeleteAction);
            }
            if (this.parentTableColumns.size() != this.columns.size()) {
                throw new IllegalArgumentException("the number of columns in child and parent table must be the same");
            }
            if (this.columns.isEmpty()) {
                throw new IllegalArgumentException("a foreign key constaint must refer to at least one column");
            }
            return new ForeignKeyDef(this.name, this.parentTableId, this.columns.toArray(new String[0]), this.parentTableColumns.toArray(new String[0]), this.onUpdateAction, this.onDeleteAction);
        }
    }
}

