/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.core.HerdDBInternalException;
import herddb.model.Column;
import herddb.model.DataScannerException;
import herddb.model.StatementExecutionException;
import herddb.model.Transaction;
import herddb.utils.DataAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public abstract class DataScanner
implements AutoCloseable {
    private final Column[] schema;
    private final String[] fieldNames;
    public Transaction transaction;
    private boolean closed;
    private boolean enumeratorOpened = false;

    public DataScanner(Transaction transaction, String[] fieldNames, Column[] schema) {
        this.schema = schema;
        this.transaction = transaction;
        this.fieldNames = fieldNames != null ? fieldNames : Column.buildFieldNamesList(schema);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public long getTransactionId() {
        return this.transaction != null ? this.transaction.transactionId : 0L;
    }

    public Column[] getSchema() {
        return this.schema;
    }

    public abstract boolean hasNext() throws DataScannerException;

    public abstract DataAccessor next() throws DataScannerException;

    public boolean isClosed() {
        return this.closed;
    }

    public void forEach(Consumer<DataAccessor> consumer) throws DataScannerException {
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }

    @Override
    public void close() throws DataScannerException {
        this.closed = true;
    }

    public List<DataAccessor> consume() throws DataScannerException {
        ArrayList<DataAccessor> records = new ArrayList<DataAccessor>();
        this.forEach(records::add);
        return records;
    }

    public List<DataAccessor> consumeAndClose() throws DataScannerException {
        List<DataAccessor> res = this.consume();
        this.close();
        return res;
    }

    public List<DataAccessor> consume(int fetchSize) throws DataScannerException {
        ArrayList<DataAccessor> records = new ArrayList<DataAccessor>();
        while (fetchSize-- > 0 && this.hasNext()) {
            records.add(this.next());
        }
        return records;
    }

    public boolean isFinished() throws DataScannerException {
        return !this.hasNext();
    }

    public boolean isRewindSupported() {
        return false;
    }

    public void rewind() throws DataScannerException {
        throw new RuntimeException("not supported for " + this.getClass());
    }

    public Enumerable<DataAccessor> createRewindOnCloseEnumerable() {
        return this.createEnumerable(true);
    }

    public Enumerable<DataAccessor> createNonRewindableEnumerable() {
        return this.createEnumerable(false);
    }

    private Enumerable<DataAccessor> createEnumerable(final boolean rewindOnClose) {
        return new AbstractEnumerable<DataAccessor>(){

            public Enumerator<DataAccessor> enumerator() {
                return DataScanner.this.asEnumerator(rewindOnClose);
            }
        };
    }

    private Enumerator<DataAccessor> asEnumerator(final boolean rewindOnClose) {
        if (this.enumeratorOpened) {
            try {
                this.rewind();
            }
            catch (DataScannerException ex) {
                throw new StatementExecutionException(ex);
            }
        }
        this.enumeratorOpened = true;
        if (rewindOnClose && !this.isRewindSupported()) {
            throw new HerdDBInternalException("This datascanner (" + this.getClass() + ") is not rewindable");
        }
        return new Enumerator<DataAccessor>(){
            private DataAccessor current;

            public DataAccessor current() {
                return this.current;
            }

            public boolean moveNext() {
                try {
                    if (DataScanner.this.hasNext()) {
                        this.current = DataScanner.this.next();
                        return true;
                    }
                    return false;
                }
                catch (DataScannerException ex) {
                    throw new HerdDBInternalException((Throwable)ex);
                }
            }

            public void reset() {
                try {
                    DataScanner.this.rewind();
                }
                catch (DataScannerException ex) {
                    throw new HerdDBInternalException((Throwable)ex);
                }
            }

            public void close() {
                if (rewindOnClose && !DataScanner.this.closed && DataScanner.this.isRewindSupported()) {
                    try {
                        DataScanner.this.rewind();
                    }
                    catch (DataScannerException ex) {
                        throw new HerdDBInternalException((Throwable)ex);
                    }
                }
            }
        };
    }
}

