/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import herddb.utils.Bytes;
import java.util.Objects;

public class Column {
    public final int serialPosition;
    public final String name;
    public final int type;
    public final Bytes defaultValue;

    public static String[] buildFieldNamesList(Column[] schema) {
        String[] result = new String[schema.length];
        for (int i = 0; i < schema.length; ++i) {
            result[i] = schema[i].name;
        }
        return result;
    }

    private Column(String name, int type, int serialPosition, Bytes defaultValue) {
        this.name = name;
        this.type = type;
        this.serialPosition = serialPosition;
        this.defaultValue = defaultValue;
    }

    public static Column column(String name, int type) {
        return new Column(name, type, -1, null);
    }

    public static Column column(String name, int type, Bytes defaultValue) {
        return new Column(name, type, -1, defaultValue);
    }

    public static Column column(String name, int type, int serialPosition) {
        return new Column(name, type, serialPosition, null);
    }

    public static Column column(String name, int type, int serialPosition, Bytes defaultValue) {
        return new Column(name, type, serialPosition, defaultValue);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "{name=" + this.name + ", type=" + this.type + '}';
    }

    public static String defaultValueToString(Column c) {
        if (c.defaultValue == null) {
            return "NULL";
        }
        switch (c.type) {
            case 7: 
            case 17: {
                return "'" + c.defaultValue.to_boolean() + "'";
            }
            case 2: 
            case 12: {
                return c.defaultValue.to_int() + "";
            }
            case 1: 
            case 13: {
                return c.defaultValue.to_long() + "";
            }
            case 6: 
            case 16: {
                return c.defaultValue.to_double() + "";
            }
            case 0: 
            case 11: {
                return "'" + c.defaultValue.to_string() + "'";
            }
            case 4: 
            case 15: {
                return c.defaultValue.to_string();
            }
        }
        return "NULL";
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Column other = (Column)obj;
        if (this.serialPosition != other.serialPosition) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.defaultValue, other.defaultValue);
    }
}

