/*
 * Decompiled with CFR 0.152.
 */
package herddb.mem;

import herddb.metadata.MetadataStorageManager;
import herddb.metadata.MetadataStorageManagerException;
import herddb.model.DDLException;
import herddb.model.NodeMetadata;
import herddb.model.TableSpace;
import herddb.model.TableSpaceAlreadyExistsException;
import herddb.model.TableSpaceDoesNotExistException;
import herddb.model.TableSpaceReplicaState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MemoryMetadataStorageManager
extends MetadataStorageManager {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, TableSpace> tableSpaces = new HashMap<String, TableSpace>();
    private final ConcurrentMap<String, Map<String, TableSpaceReplicaState>> statesForTableSpace = new ConcurrentHashMap<String, Map<String, TableSpaceReplicaState>>();
    private final List<NodeMetadata> nodes = new ArrayList<NodeMetadata>();

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.tableSpaces.clear();
            this.nodes.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public List<NodeMetadata> listNodes() throws MetadataStorageManagerException {
        this.lock.readLock().lock();
        try {
            ArrayList<NodeMetadata> arrayList = new ArrayList<NodeMetadata>(this.nodes);
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void registerNode(NodeMetadata nodeMetadata) throws MetadataStorageManagerException {
        this.lock.writeLock().lock();
        try {
            if (this.nodes.stream().filter(s -> s.nodeId.equals(nodeMetadata.nodeId)).findAny().isPresent()) {
                throw new MetadataStorageManagerException("node " + nodeMetadata.nodeId + " already exists");
            }
            this.nodes.add(nodeMetadata);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Collection<String> listTableSpaces() {
        this.lock.readLock().lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.tableSpaces.keySet());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public TableSpace describeTableSpace(String name) {
        name = name.toLowerCase();
        this.lock.readLock().lock();
        try {
            TableSpace tableSpace = this.tableSpaces.get(name);
            return tableSpace;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void registerTableSpace(TableSpace tableSpace) throws DDLException {
        this.validateTableSpace(tableSpace);
        this.lock.writeLock().lock();
        try {
            if (this.tableSpaces.putIfAbsent(tableSpace.name.toLowerCase(), tableSpace) != null) {
                throw new TableSpaceAlreadyExistsException(tableSpace.name.toLowerCase());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void dropTableSpace(String name, TableSpace previous) throws DDLException, MetadataStorageManagerException {
        this.lock.writeLock().lock();
        try {
            this.tableSpaces.remove(name.toLowerCase());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateTableSpace(TableSpace tableSpace, TableSpace previous) throws DDLException {
        this.validateTableSpace(tableSpace);
        this.lock.writeLock().lock();
        try {
            TableSpace prev = this.tableSpaces.get(tableSpace.name.toLowerCase());
            if (prev == null) {
                throw new TableSpaceDoesNotExistException(tableSpace.name.toLowerCase());
            }
            this.tableSpaces.put(tableSpace.name.toLowerCase(), tableSpace);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void start() {
    }

    @Override
    public boolean ensureDefaultTableSpace(String localNodeId, String initialReplicaList, long maxLeaderInactivityTime, int expectedReplicaCount) throws MetadataStorageManagerException {
        this.lock.writeLock().lock();
        try {
            TableSpace exists = this.tableSpaces.get("herd");
            if (exists == null) {
                TableSpace defaultTableSpace = TableSpace.builder().leader(localNodeId).replica(localNodeId).name("herd").build();
                this.registerTableSpace(defaultTableSpace);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (DDLException err) {
            throw new MetadataStorageManagerException((Throwable)((Object)err));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public List<TableSpaceReplicaState> getTableSpaceReplicaState(String tableSpaceUuid) throws MetadataStorageManagerException {
        Map result = (Map)this.statesForTableSpace.get(tableSpaceUuid);
        if (result == null) {
            return Collections.emptyList();
        }
        return new ArrayList<TableSpaceReplicaState>(result.values());
    }

    @Override
    public void updateTableSpaceReplicaState(TableSpaceReplicaState state) throws MetadataStorageManagerException {
        Map failed;
        ConcurrentHashMap<String, TableSpaceReplicaState> result = (ConcurrentHashMap<String, TableSpaceReplicaState>)this.statesForTableSpace.get(state.uuid);
        if (result == null && (failed = (Map)this.statesForTableSpace.putIfAbsent(state.uuid, result = new ConcurrentHashMap<String, TableSpaceReplicaState>())) != null) {
            throw new MetadataStorageManagerException("concurrent modification to " + state.uuid + " tableSpace");
        }
        result.put(state.nodeId, state);
    }
}

