/*
 * Decompiled with CFR 0.152.
 */
package herddb.mem;

import herddb.core.MemoryManager;
import herddb.core.PostCheckpointAction;
import herddb.core.RecordSetFactory;
import herddb.index.ConcurrentMapKeyToPageIndex;
import herddb.index.KeyToPageIndex;
import herddb.log.LogSequenceNumber;
import herddb.mem.MemoryRecordSetFactory;
import herddb.model.Index;
import herddb.model.Record;
import herddb.model.Table;
import herddb.model.Transaction;
import herddb.storage.DataPageDoesNotExistException;
import herddb.storage.DataStorageManager;
import herddb.storage.DataStorageManagerException;
import herddb.storage.FullTableScanConsumer;
import herddb.storage.IndexStatus;
import herddb.storage.TableStatus;
import herddb.utils.ByteArrayCursor;
import herddb.utils.Bytes;
import herddb.utils.ExtendedDataInputStream;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.SimpleByteArrayInputStream;
import herddb.utils.VisibleByteArrayOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemoryDataStorageManager
extends DataStorageManager {
    private static final Logger LOGGER = Logger.getLogger(MemoryDataStorageManager.class.getName());
    private final ConcurrentHashMap<String, Page> pages = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Bytes> indexpages = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, byte[]> tableStatuses = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, byte[]> indexStatuses = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<Table>> tablesByTablespace = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<Index>> indexesByTablespace = new ConcurrentHashMap();
    private static final Pattern LOG_SEQUENCE_PATTERN = Pattern.compile("(?<ledgerId>\\d+)\\.(?<offset>\\d+)");

    @Override
    public int getActualNumberOfPages(String tableSpace, String tableName) throws DataStorageManagerException {
        int res = 0;
        String prefix = tableSpace + "." + tableName + "_";
        for (String key : this.pages.keySet()) {
            if (!key.startsWith(prefix)) continue;
            ++res;
        }
        return res;
    }

    public Page getPage(String tableSpace, String tableName, Long pageId) {
        return this.pages.get(tableSpace + "." + tableName + "_" + pageId);
    }

    @Override
    public List<Record> readPage(String tableSpace, String tableName, Long pageId) throws DataPageDoesNotExistException {
        Page page = this.pages.get(tableSpace + "." + tableName + "_" + pageId);
        if (page == null) {
            throw new DataPageDoesNotExistException("No such page: " + tableSpace + "." + tableName + " page " + pageId);
        }
        return page.records;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <X> X readIndexPage(String tableSpace, String indexName, Long pageId, DataStorageManager.DataReader<X> reader) throws DataStorageManagerException {
        Bytes page = this.indexpages.get(tableSpace + "." + indexName + "_" + pageId);
        if (page == null) {
            throw new DataStorageManagerException("No such page: " + tableSpace + "." + indexName + " page " + pageId);
        }
        try (ByteArrayCursor ein = page.newCursor();){
            X x = reader.read(ein);
            return x;
        }
        catch (IOException e) {
            throw new DataStorageManagerException(e);
        }
    }

    @Override
    public void initTablespace(String tableSpace) throws DataStorageManagerException {
    }

    @Override
    public void initIndex(String tableSpace, String indexName) throws DataStorageManagerException {
    }

    @Override
    public void initTable(String tableSpace, String uuid) throws DataStorageManagerException {
    }

    private LogSequenceNumber evaluateLogSequenceNumber(String string) {
        Matcher matcher = LOG_SEQUENCE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        try {
            long ledgerId = Long.parseLong(matcher.group("ledgerId"));
            long offset = Long.parseLong(matcher.group("offset"));
            return new LogSequenceNumber(ledgerId, offset);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public TableStatus getLatestTableStatus(String tableSpace, String tableName) throws DataStorageManagerException {
        TableStatus latestStatus;
        LogSequenceNumber max = null;
        String prefix = tableSpace + "." + tableName + "_";
        for (String status : this.tableStatuses.keySet()) {
            LogSequenceNumber log;
            if (!status.startsWith(prefix) || (log = this.evaluateLogSequenceNumber(prefix)) == null || max != null && !log.after(max)) continue;
            max = log;
        }
        if (max == null) {
            latestStatus = TableStatus.buildTableStatusForNewCreatedTable(tableName);
        } else {
            byte[] data = this.tableStatuses.get(this.checkpointName(tableSpace, tableName, max));
            if (data == null) {
                latestStatus = TableStatus.buildTableStatusForNewCreatedTable(tableName);
            } else {
                try (SimpleByteArrayInputStream input = new SimpleByteArrayInputStream(data);
                     ExtendedDataInputStream dataIn = new ExtendedDataInputStream((InputStream)input);){
                    latestStatus = TableStatus.deserialize(dataIn);
                }
                catch (IOException err) {
                    throw new DataStorageManagerException(err);
                }
            }
        }
        return latestStatus;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public TableStatus getTableStatus(String tableSpace, String tableName, LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        String checkPoint = this.checkpointName(tableSpace, tableName, sequenceNumber);
        byte[] data = this.tableStatuses.get(checkPoint);
        if (data == null) {
            throw new DataStorageManagerException("no such tablee checkpoint: " + checkPoint);
        }
        try (SimpleByteArrayInputStream input = new SimpleByteArrayInputStream(data);){
            TableStatus tableStatus;
            try (ExtendedDataInputStream dataIn = new ExtendedDataInputStream((InputStream)input);){
                tableStatus = TableStatus.deserialize(dataIn);
            }
            return tableStatus;
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public IndexStatus getIndexStatus(String tableSpace, String indexName, LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        String checkPoint = this.checkpointName(tableSpace, indexName, sequenceNumber);
        byte[] data = this.indexStatuses.get(checkPoint);
        if (data == null) {
            throw new DataStorageManagerException("no such index checkpoint: " + checkPoint);
        }
        try (SimpleByteArrayInputStream input = new SimpleByteArrayInputStream(data);){
            IndexStatus indexStatus;
            try (ExtendedDataInputStream dataIn = new ExtendedDataInputStream((InputStream)input);){
                indexStatus = IndexStatus.deserialize(dataIn);
            }
            return indexStatus;
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
    }

    @Override
    public void fullTableScan(String tableSpace, String tableName, FullTableScanConsumer consumer) throws DataStorageManagerException {
        TableStatus status = this.getLatestTableStatus(tableSpace, tableName);
        this.fullTableScan(tableSpace, tableName, status, consumer);
    }

    @Override
    public void fullTableScan(String tableSpace, String tableName, LogSequenceNumber sequenceNumber, FullTableScanConsumer consumer) throws DataStorageManagerException {
        TableStatus status = this.getTableStatus(tableSpace, tableName, sequenceNumber);
        this.fullTableScan(tableSpace, tableName, status, consumer);
    }

    private void fullTableScan(String tableSpace, String tableName, TableStatus status, FullTableScanConsumer consumer) {
        consumer.acceptTableStatus(status);
        ArrayList<Long> activePages = new ArrayList<Long>(status.activePages.keySet());
        activePages.sort(null);
        Iterator iterator = activePages.iterator();
        while (iterator.hasNext()) {
            long idpage = (Long)iterator.next();
            List<Record> records = this.readPage(tableSpace, tableName, idpage);
            consumer.acceptPage(idpage, records);
        }
        consumer.endTable();
    }

    @Override
    public void writePage(String tableSpace, String tableName, long pageId, Collection<Record> newPage) throws DataStorageManagerException {
        Page page = new Page(new ArrayList<Record>(newPage));
        Page prev = this.pages.putIfAbsent(tableSpace + "." + tableName + "_" + pageId, page);
        if (prev != null) {
            throw new DataStorageManagerException("pages are immutable");
        }
    }

    @Override
    public void writeIndexPage(String tableSpace, String indexName, long pageId, DataStorageManager.DataWriter writer) throws DataStorageManagerException {
        Bytes page_wrapper;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
             ExtendedDataOutputStream eout = new ExtendedDataOutputStream((OutputStream)out);){
            writer.write(eout);
            eout.flush();
            page_wrapper = Bytes.from_array((byte[])out.toByteArray());
        }
        catch (IOException ex) {
            throw new DataStorageManagerException(ex);
        }
        this.indexpages.put(tableSpace + "." + indexName + "_" + pageId, page_wrapper);
    }

    @Override
    public List<PostCheckpointAction> tableCheckpoint(String tableSpace, String tableName, TableStatus tableStatus, boolean pin) throws DataStorageManagerException {
        long pageId;
        Object key2;
        Map<Long, Integer> pins = this.pinTableAndGetPages(tableSpace, tableName, tableStatus, pin);
        Set<LogSequenceNumber> checkpoints = this.pinTableAndGetCheckpoints(tableSpace, tableName, tableStatus, pin);
        ArrayList<Long> pagesForTable = new ArrayList<Long>();
        final String prefix = tableSpace + "." + tableName + "_";
        for (Object key2 : this.pages.keySet()) {
            if (!((String)key2).startsWith(prefix) || pins.containsKey(pageId = Long.parseLong(((String)key2).substring(prefix.length())))) continue;
            pagesForTable.add(pageId);
        }
        pagesForTable.removeAll(tableStatus.activePages.keySet());
        ArrayList<PostCheckpointAction> result = new ArrayList<PostCheckpointAction>();
        key2 = pagesForTable.iterator();
        while (key2.hasNext()) {
            pageId = (Long)key2.next();
            result.add(new PostCheckpointAction(tableSpace, tableName, "drop page " + pageId){

                @Override
                public void run() {
                    MemoryDataStorageManager.this.pages.remove(prefix + pageId);
                    LOGGER.log(Level.SEVERE, "removing " + prefix + pageId);
                }
            });
        }
        for (final String oldStatus : this.tableStatuses.keySet()) {
            LogSequenceNumber log;
            if (!oldStatus.startsWith(prefix) || (log = this.evaluateLogSequenceNumber(prefix)) != null && checkpoints.contains(log)) continue;
            result.add(new PostCheckpointAction(tableSpace, tableName, "drop table checkpoint " + oldStatus){

                @Override
                public void run() {
                    MemoryDataStorageManager.this.tableStatuses.remove(oldStatus);
                }
            });
        }
        VisibleByteArrayOutputStream oo = new VisibleByteArrayOutputStream(1024);
        try (ExtendedDataOutputStream dataOutputKeys = new ExtendedDataOutputStream((OutputStream)oo);){
            tableStatus.serialize(dataOutputKeys);
            dataOutputKeys.flush();
            oo.write(oo.xxhash64());
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
        this.tableStatuses.put(this.checkpointName(tableSpace, tableName, tableStatus.sequenceNumber), oo.toByteArray());
        return result;
    }

    @Override
    public List<PostCheckpointAction> indexCheckpoint(String tableSpace, String indexName, IndexStatus indexStatus, boolean pin) throws DataStorageManagerException {
        long pageId;
        Object key2;
        Map<Long, Integer> pins = this.pinIndexAndGetPages(tableSpace, indexName, indexStatus, pin);
        Set<LogSequenceNumber> checkpoints = this.pinIndexAndGetCheckpoints(tableSpace, indexName, indexStatus, pin);
        ArrayList<Long> pagesForIndex = new ArrayList<Long>();
        final String prefix = tableSpace + "." + indexName + "_";
        for (Object key2 : this.indexpages.keySet()) {
            if (!((String)key2).startsWith(prefix) || pins.containsKey(pageId = Long.parseLong(((String)key2).substring(prefix.length())))) continue;
            pagesForIndex.add(pageId);
        }
        pagesForIndex.removeAll(indexStatus.activePages);
        ArrayList<PostCheckpointAction> result = new ArrayList<PostCheckpointAction>();
        key2 = pagesForIndex.iterator();
        while (key2.hasNext()) {
            pageId = (Long)key2.next();
            result.add(new PostCheckpointAction(tableSpace, indexName, "drop page " + pageId){

                @Override
                public void run() {
                    MemoryDataStorageManager.this.indexpages.remove(prefix + pageId);
                }
            });
        }
        for (final String oldStatus : this.indexStatuses.keySet()) {
            LogSequenceNumber log;
            if (!oldStatus.startsWith(prefix) || (log = this.evaluateLogSequenceNumber(prefix)) != null && checkpoints.contains(log)) continue;
            result.add(new PostCheckpointAction(tableSpace, indexName, "drop index checkpoint " + oldStatus){

                @Override
                public void run() {
                    MemoryDataStorageManager.this.indexStatuses.remove(oldStatus);
                }
            });
        }
        VisibleByteArrayOutputStream oo = new VisibleByteArrayOutputStream(1024);
        try (ExtendedDataOutputStream dataOutputKeys = new ExtendedDataOutputStream((OutputStream)oo);){
            indexStatus.serialize(dataOutputKeys);
            dataOutputKeys.flush();
            oo.write(oo.xxhash64());
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
        this.indexStatuses.put(this.checkpointName(tableSpace, indexName, indexStatus.sequenceNumber), oo.toByteArray());
        return result;
    }

    @Override
    public void start() throws DataStorageManagerException {
    }

    @Override
    public void close() throws DataStorageManagerException {
        this.pages.clear();
        this.indexpages.clear();
        this.tableStatuses.clear();
        this.indexStatuses.clear();
        this.tablesByTablespace.clear();
        this.indexesByTablespace.clear();
    }

    @Override
    public void eraseTablespaceData(String tableSpace) throws DataStorageManagerException {
        this.tablesByTablespace.remove(tableSpace);
    }

    @Override
    public List<Table> loadTables(LogSequenceNumber sequenceNumber, String tableSpace) throws DataStorageManagerException {
        List<Table> res = this.tablesByTablespace.get(tableSpace);
        if (res != null) {
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Index> loadIndexes(LogSequenceNumber sequenceNumber, String tableSpace) throws DataStorageManagerException {
        List<Index> res = this.indexesByTablespace.get(tableSpace);
        if (res != null) {
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<PostCheckpointAction> writeTables(String tableSpace, LogSequenceNumber sequenceNumber, List<Table> tables, List<Index> indexlist, boolean prepareActions) throws DataStorageManagerException {
        this.tablesByTablespace.merge(tableSpace, tables, new BiFunction<List<Table>, List<Table>, List<Table>>(){

            @Override
            public List<Table> apply(List<Table> before, List<Table> after) {
                if (before == null) {
                    return after;
                }
                ArrayList<Table> result = new ArrayList<Table>();
                result.addAll(before);
                result.addAll(after);
                return result;
            }
        });
        this.indexesByTablespace.merge(tableSpace, indexlist, new BiFunction<List<Index>, List<Index>, List<Index>>(){

            @Override
            public List<Index> apply(List<Index> before, List<Index> after) {
                if (before == null) {
                    return after;
                }
                ArrayList<Index> result = new ArrayList<Index>();
                result.addAll(before);
                result.addAll(after);
                return result;
            }
        });
        return Collections.emptyList();
    }

    @Override
    public Collection<PostCheckpointAction> writeCheckpointSequenceNumber(String tableSpace, LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        return Collections.emptyList();
    }

    @Override
    public LogSequenceNumber getLastcheckpointSequenceNumber(String tableSpace) throws DataStorageManagerException {
        return LogSequenceNumber.START_OF_TIME;
    }

    @Override
    public void dropTable(String tablespace, String name) throws DataStorageManagerException {
        List<Table> tables = this.tablesByTablespace.get(tablespace);
        if (tables != null) {
            Iterator<Table> it = tables.iterator();
            while (it.hasNext()) {
                Table table = it.next();
                if (!table.name.equals(name)) continue;
                it.remove();
            }
        }
    }

    @Override
    public void truncateIndex(String tableSpaceUUID, String name) throws DataStorageManagerException {
        this.dropIndex(tableSpaceUUID, name);
    }

    @Override
    public void dropIndex(String tablespace, String name) throws DataStorageManagerException {
        List<Index> indexes = this.indexesByTablespace.get(tablespace);
        if (indexes != null) {
            Iterator<Index> it = indexes.iterator();
            while (it.hasNext()) {
                Index index = it.next();
                if (!index.name.equals(name)) continue;
                it.remove();
            }
        }
    }

    @Override
    public KeyToPageIndex createKeyToPageMap(String tablespace, String name, MemoryManager memoryManager) {
        return new ConcurrentMapKeyToPageIndex(new ConcurrentHashMap<Bytes, Long>());
    }

    @Override
    public void releaseKeyToPageMap(String tablespace, String name, KeyToPageIndex keyToPage) {
        if (keyToPage != null) {
            ConcurrentMapKeyToPageIndex impl = (ConcurrentMapKeyToPageIndex)keyToPage;
            impl.getMap().clear();
        }
    }

    @Override
    public RecordSetFactory createRecordSetFactory() {
        return new MemoryRecordSetFactory();
    }

    @Override
    public void cleanupAfterTableBoot(String tablespace, String name, Set<Long> activePagesAtBoot) {
    }

    @Override
    public void loadTransactions(LogSequenceNumber sequenceNumber, String tableSpace, Consumer<Transaction> consumer) throws DataStorageManagerException {
    }

    @Override
    public Collection<PostCheckpointAction> writeTransactionsAtCheckpoint(String tableSpace, LogSequenceNumber sequenceNumber, Collection<Transaction> transactions) throws DataStorageManagerException {
        try {
            for (Transaction t : transactions) {
                t.serialize(new ExtendedDataOutputStream((OutputStream)new ByteArrayOutputStream()));
            }
            return Collections.emptyList();
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
    }

    private String checkpointName(String tableSpace, String name, LogSequenceNumber sequenceNumber) {
        return tableSpace + "." + name + "_" + sequenceNumber.ledgerId + "." + sequenceNumber.offset;
    }

    public static final class Page {
        private final List<Record> records;

        public Page(List<Record> records) {
            this.records = records;
        }

        public List<Record> getRecords() {
            return this.records;
        }

        public String toString() {
            return "Page{records=" + this.records.size();
        }
    }
}

