/*
 * Decompiled with CFR 0.152.
 */
package herddb.log;

import herddb.utils.Bytes;

public final class LogSequenceNumber {
    public final long ledgerId;
    public final long offset;
    public static final LogSequenceNumber START_OF_TIME = new LogSequenceNumber(-1L, -1L);

    public LogSequenceNumber(long ledgerId, long offset) {
        this.ledgerId = ledgerId;
        this.offset = offset;
    }

    public int hashCode() {
        int hash = 3;
        hash = 19 * hash + (int)(this.ledgerId ^ this.ledgerId >>> 32);
        hash = 19 * hash + (int)(this.offset ^ this.offset >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogSequenceNumber other = (LogSequenceNumber)obj;
        if (this.ledgerId != other.ledgerId) {
            return false;
        }
        return this.offset == other.offset;
    }

    public String toString() {
        return "(" + this.ledgerId + ',' + this.offset + ')';
    }

    public boolean after(LogSequenceNumber snapshotSequenceNumber) {
        if (this.ledgerId < snapshotSequenceNumber.ledgerId) {
            return false;
        }
        if (this.ledgerId == snapshotSequenceNumber.ledgerId) {
            return this.offset > snapshotSequenceNumber.offset;
        }
        return true;
    }

    public boolean isStartOfTime() {
        return this.ledgerId == -1L && this.offset == -1L;
    }

    public byte[] serialize() {
        byte[] array = new byte[16];
        Bytes.putLong((byte[])array, (int)0, (long)this.ledgerId);
        Bytes.putLong((byte[])array, (int)8, (long)this.offset);
        return array;
    }

    public static LogSequenceNumber deserialize(byte[] array) {
        return new LogSequenceNumber(Bytes.toLong((byte[])array, (int)0), Bytes.toLong((byte[])array, (int)8));
    }
}

