/*
 * Decompiled with CFR 0.152.
 */
package herddb.index.brin;

import herddb.codec.RecordSerializer;
import herddb.core.AbstractIndexManager;
import herddb.core.AbstractTableManager;
import herddb.core.HerdDBInternalException;
import herddb.core.MemoryManager;
import herddb.core.PostCheckpointAction;
import herddb.core.TableSpaceManager;
import herddb.index.IndexOperation;
import herddb.index.SecondaryIndexPrefixScan;
import herddb.index.SecondaryIndexRangeScan;
import herddb.index.SecondaryIndexSeek;
import herddb.index.brin.BlockRangeIndex;
import herddb.index.brin.BlockRangeIndexMetadata;
import herddb.index.brin.IndexDataStorage;
import herddb.log.CommitLog;
import herddb.log.LogSequenceNumber;
import herddb.model.Index;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import herddb.model.TableContext;
import herddb.sql.SQLRecordKeyFunction;
import herddb.storage.DataStorageManager;
import herddb.storage.DataStorageManagerException;
import herddb.storage.IndexStatus;
import herddb.utils.ByteArrayCursor;
import herddb.utils.Bytes;
import herddb.utils.DataAccessor;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.SystemProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class BRINIndexManager
extends AbstractIndexManager {
    private static final boolean VALIDATE_CHECKPOINT_METADATA = SystemProperties.getBooleanSystemProperty((String)"herddb.index.brin.validatecheckpointmetadata", (boolean)true);
    private static final Logger LOGGER = Logger.getLogger(BRINIndexManager.class.getName());
    LogSequenceNumber bootSequenceNumber;
    private final AtomicLong newPageId = new AtomicLong(1L);
    private final BlockRangeIndex<Bytes, Bytes> data;
    private final IndexDataStorage<Bytes, Bytes> storageLayer = new IndexDataStorageImpl();

    public BRINIndexManager(Index index, MemoryManager memoryManager, AbstractTableManager tableManager, CommitLog log, DataStorageManager dataStorageManager, TableSpaceManager tableSpaceManager, String tableSpaceUUID, long transaction, int writeLockTimeout, int readLockTimeout) {
        super(index, tableManager, dataStorageManager, tableSpaceManager.getTableSpaceUUID(), log, transaction, writeLockTimeout, readLockTimeout);
        this.data = new BlockRangeIndex<Bytes, Bytes>(memoryManager.getMaxLogicalPageSize(), memoryManager.getDataPageReplacementPolicy(), this.storageLayer);
    }

    @Override
    protected boolean doStart(LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        IndexStatus status;
        LOGGER.log(Level.FINE, " start BRIN index {0} uuid {1}", new Object[]{this.index.name, this.index.uuid});
        this.dataStorageManager.initIndex(this.tableSpaceUUID, this.index.uuid);
        this.bootSequenceNumber = sequenceNumber;
        if (LogSequenceNumber.START_OF_TIME.equals(sequenceNumber)) {
            this.data.boot(BlockRangeIndexMetadata.empty());
            LOGGER.log(Level.FINE, "loaded empty index {0}", new Object[]{this.index.name});
            return true;
        }
        try {
            status = this.dataStorageManager.getIndexStatus(this.tableSpaceUUID, this.index.uuid, sequenceNumber);
        }
        catch (DataStorageManagerException e) {
            LOGGER.log(Level.SEVERE, "cannot load index {0} due to {1}, it will be rebuilt", new Object[]{this.index.name, e});
            return false;
        }
        try {
            PageContents metadataBlock = PageContents.deserialize(status.indexData);
            this.data.boot(new BlockRangeIndexMetadata(metadataBlock.metadata));
        }
        catch (IOException e) {
            throw new DataStorageManagerException(e);
        }
        catch (UnsupportedMetadataVersionException e) {
            LOGGER.log(Level.SEVERE, "cannot load index {0} due to an old metadata version ({1}) found, it will be rebuilt", new Object[]{this.index.name, e.version});
            return false;
        }
        this.newPageId.set(status.newPageId);
        LOGGER.log(Level.INFO, "loaded index {0} {1} blocks", new Object[]{this.index.name, this.data.getNumBlocks()});
        return true;
    }

    @Override
    public void rebuild() throws DataStorageManagerException {
        long _start = System.currentTimeMillis();
        LOGGER.log(Level.FINE, "building index {0}", this.index.name);
        this.dataStorageManager.initIndex(this.tableSpaceUUID, this.index.uuid);
        this.data.reset();
        Table table = this.tableManager.getTable();
        AtomicLong count = new AtomicLong();
        this.tableManager.scanForIndexRebuild(r -> {
            DataAccessor values = r.getDataAccessor(table);
            Bytes key = RecordSerializer.serializeIndexKey(values, table, table.primaryKey);
            Bytes indexKey = RecordSerializer.serializeIndexKey(values, this.index, this.index.columnNames);
            this.recordInserted(key, indexKey);
            count.incrementAndGet();
        });
        long _stop = System.currentTimeMillis();
        if (count.intValue() > 0) {
            LOGGER.log(Level.INFO, "building index {0} took {1}, scanned {2} records", new Object[]{this.index.name, _stop - _start + " ms", count});
        }
    }

    @Override
    public List<PostCheckpointAction> checkpoint(LogSequenceNumber sequenceNumber, boolean pin) throws DataStorageManagerException {
        try {
            BlockRangeIndexMetadata<Bytes> metadata = this.data.checkpoint();
            if (VALIDATE_CHECKPOINT_METADATA) {
                boolean invalid = false;
                Long nextID = null;
                for (BlockRangeIndexMetadata.BlockMetadata<Bytes> blockData : metadata.getBlocksMetadata()) {
                    if (blockData.nextBlockId != null) {
                        if (nextID == null) {
                            LOGGER.log(Level.WARNING, "Wrong next block on index {0}, expected notingh but {0} found", new Object[]{this.index.name, blockData.nextBlockId});
                            invalid = true;
                        } else if (nextID.longValue() != blockData.nextBlockId.longValue()) {
                            LOGGER.log(Level.WARNING, "Wrong next block on index {0}, expected {1} but {2} found", new Object[]{this.index.name, nextID, blockData.nextBlockId});
                            invalid = true;
                        }
                    } else if (nextID != null) {
                        LOGGER.log(Level.WARNING, "Wrong next block on index {0}, expected {1} but nothing found", new Object[]{this.index.name, nextID});
                        invalid = true;
                    }
                    nextID = blockData.blockId;
                }
                if (invalid) {
                    LOGGER.log(Level.WARNING, this.data.generateDetailedInternalStatus());
                }
            }
            PageContents page = new PageContents();
            page.type = 9;
            page.metadata = metadata.getBlocksMetadata();
            byte[] contents = page.serialize();
            HashSet<Long> activePages = new HashSet<Long>();
            page.metadata.forEach(b -> activePages.add(b.pageId));
            IndexStatus indexStatus = new IndexStatus(this.index.name, sequenceNumber, this.newPageId.get(), activePages, contents);
            ArrayList<PostCheckpointAction> result = new ArrayList<PostCheckpointAction>();
            result.addAll(this.dataStorageManager.indexCheckpoint(this.tableSpaceUUID, this.index.uuid, indexStatus, pin));
            LOGGER.log(Level.INFO, "checkpoint index {0} finished: logpos {1}, {2} blocks", new Object[]{this.index.name, sequenceNumber, Integer.toString(page.metadata.size())});
            LOGGER.log(Level.FINE, "checkpoint index {0} finished: logpos {1}, pages {2}", new Object[]{this.index.name, sequenceNumber, activePages});
            return result;
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
    }

    @Override
    public void unpinCheckpoint(LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        this.dataStorageManager.unPinIndexCheckpoint(this.tableSpaceUUID, this.index.uuid, sequenceNumber);
    }

    @Override
    protected Stream<Bytes> scanner(IndexOperation operation, StatementEvaluationContext context, TableContext tableContext) throws StatementExecutionException {
        if (operation instanceof SecondaryIndexSeek) {
            SecondaryIndexSeek sis = (SecondaryIndexSeek)operation;
            SQLRecordKeyFunction value = sis.value;
            byte[] refvalue = value.computeNewValue(null, context, tableContext);
            return this.data.query(Bytes.from_array((byte[])refvalue));
        }
        if (operation instanceof SecondaryIndexPrefixScan) {
            SecondaryIndexPrefixScan sis = (SecondaryIndexPrefixScan)operation;
            SQLRecordKeyFunction value = sis.value;
            byte[] refvalue = value.computeNewValue(null, context, tableContext);
            Bytes firstKey = Bytes.from_array((byte[])refvalue);
            Bytes lastKey = firstKey.next();
            return this.data.query(firstKey, lastKey);
        }
        if (operation instanceof SecondaryIndexRangeScan) {
            SQLRecordKeyFunction maxKey;
            Bytes firstKey = null;
            Bytes lastKey = null;
            SecondaryIndexRangeScan sis = (SecondaryIndexRangeScan)operation;
            SQLRecordKeyFunction minKey = sis.minValue;
            if (minKey != null) {
                byte[] refminvalue = minKey.computeNewValue(null, context, tableContext);
                firstKey = Bytes.from_array((byte[])refminvalue);
            }
            if ((maxKey = sis.maxValue) != null) {
                byte[] refmaxvalue = maxKey.computeNewValue(null, context, tableContext);
                lastKey = Bytes.from_array((byte[])refmaxvalue);
            }
            LOGGER.log(Level.FINE, "range scan on {0}.{1}, from {2} to {1}", new Object[]{this.index.table, this.index.name, firstKey, lastKey});
            return this.data.query(firstKey, lastKey);
        }
        throw new UnsupportedOperationException("unsuppported index access type " + operation);
    }

    @Override
    public void recordDeleted(Bytes key, Bytes indexKey) {
        if (indexKey == null) {
            return;
        }
        this.data.delete(indexKey, key);
    }

    @Override
    public void recordInserted(Bytes key, Bytes indexKey) {
        if (indexKey == null) {
            return;
        }
        this.data.put(indexKey, key);
    }

    @Override
    public void recordUpdated(Bytes key, Bytes indexKeyRemoved, Bytes indexKeyAdded) {
        if (Objects.equals(indexKeyRemoved, indexKeyAdded)) {
            return;
        }
        if (indexKeyAdded != null) {
            this.data.put(indexKeyAdded, key);
        }
        if (indexKeyRemoved != null) {
            this.data.delete(indexKeyRemoved, key);
        }
    }

    @Override
    public void truncate() throws DataStorageManagerException {
        this.data.reset();
        this.truncateIndexData();
    }

    @Override
    public boolean valueAlreadyMapped(Bytes key, Bytes primaryKey) throws DataStorageManagerException {
        if (primaryKey == null) {
            return this.data.containsKey(key);
        }
        List<Bytes> current = this.data.search(key);
        return !current.isEmpty() && !current.contains(primaryKey);
    }

    @Override
    public void close() {
        this.data.clear();
    }

    public int getNumBlocks() {
        return this.data.getNumBlocks();
    }

    private class IndexDataStorageImpl
    implements IndexDataStorage<Bytes, Bytes> {
        private IndexDataStorageImpl() {
        }

        @Override
        public List<Map.Entry<Bytes, Bytes>> loadDataPage(long pageId) throws IOException {
            try {
                PageContents contents = BRINIndexManager.this.dataStorageManager.readIndexPage(BRINIndexManager.this.tableSpaceUUID, ((BRINIndexManager)BRINIndexManager.this).index.uuid, pageId, in -> PageContents.deserialize(in));
                if (contents.type != 10) {
                    throw new IOException("page " + pageId + " does not contain blocks data");
                }
                return contents.pageData;
            }
            catch (DataStorageManagerException err) {
                throw new IOException((Throwable)((Object)err));
            }
        }

        @Override
        public long createDataPage(List<Map.Entry<Bytes, Bytes>> values) throws IOException {
            try {
                PageContents contents = new PageContents();
                contents.type = 10;
                contents.pageData = values;
                long pageId = BRINIndexManager.this.newPageId.getAndIncrement();
                BRINIndexManager.this.dataStorageManager.writeIndexPage(BRINIndexManager.this.tableSpaceUUID, ((BRINIndexManager)BRINIndexManager.this).index.uuid, pageId, out -> contents.serialize(out));
                return pageId;
            }
            catch (DataStorageManagerException err) {
                throw new IOException((Throwable)((Object)err));
            }
        }
    }

    private static class PageContents {
        public static final int TYPE_METADATA = 9;
        public static final int TYPE_BLOCKDATA = 10;
        private int type;
        private List<Map.Entry<Bytes, Bytes>> pageData;
        private List<BlockRangeIndexMetadata.BlockMetadata<Bytes>> metadata;

        private PageContents() {
        }

        byte[] serialize() throws IOException {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream(1024);){
                byte[] byArray;
                try (ExtendedDataOutputStream eout = new ExtendedDataOutputStream((OutputStream)out);){
                    this.serialize(eout);
                    eout.flush();
                    byArray = out.toByteArray();
                }
                return byArray;
            }
        }

        void serialize(ExtendedDataOutputStream out) throws IOException {
            out.writeVLong(3L);
            out.writeVLong(0L);
            out.writeVInt(this.type);
            switch (this.type) {
                case 9: {
                    out.writeVInt(this.metadata.size());
                    for (BlockRangeIndexMetadata.BlockMetadata<Bytes> md : this.metadata) {
                        boolean head = md.firstKey == null;
                        boolean tail = md.nextBlockId == null;
                        byte blockFlags = 0;
                        if (head) {
                            blockFlags = (byte)(blockFlags | 1);
                        }
                        if (tail) {
                            blockFlags = (byte)(blockFlags | 2);
                        }
                        out.writeByte((int)blockFlags);
                        if (!head) {
                            out.writeArray((Bytes)md.firstKey);
                        }
                        out.writeZLong(md.blockId);
                        out.writeVLong(md.size);
                        out.writeVLong(md.pageId);
                        if (tail) continue;
                        out.writeZLong(md.nextBlockId.longValue());
                    }
                    break;
                }
                case 10: {
                    out.writeVInt(this.pageData.size());
                    for (Map.Entry<Bytes, Bytes> entry : this.pageData) {
                        out.writeArray(entry.getKey());
                        out.writeArray(entry.getValue());
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("bad index page type " + this.type);
                }
            }
        }

        static PageContents deserialize(ByteArrayCursor in) throws IOException {
            long version = in.readVLong();
            long flags = in.readVLong();
            if (version < 3L) {
                throw new UnsupportedMetadataVersionException(version);
            }
            if (version > 3L || flags != 0L) {
                throw new DataStorageManagerException("corrupted index page");
            }
            PageContents result = new PageContents();
            result.type = in.readVInt();
            switch (result.type) {
                case 9: {
                    int blocks = in.readVInt();
                    result.metadata = new ArrayList<BlockRangeIndexMetadata.BlockMetadata<Bytes>>();
                    for (int i = 0; i < blocks; ++i) {
                        byte blockFlags = in.readByte();
                        Bytes firstKey = (blockFlags & 1) > 0 ? null : in.readBytesNoCopy();
                        long blockId = in.readZLong();
                        long size = in.readVLong();
                        long pageId = in.readVLong();
                        Long nextBlockId = (blockFlags & 2) > 0 ? null : Long.valueOf(in.readZLong());
                        BlockRangeIndexMetadata.BlockMetadata<Bytes> md = new BlockRangeIndexMetadata.BlockMetadata<Bytes>(firstKey, blockId, size, pageId, nextBlockId);
                        result.metadata.add(md);
                    }
                    break;
                }
                case 10: {
                    int values = in.readVInt();
                    result.pageData = new ArrayList<Map.Entry<Bytes, Bytes>>(values);
                    for (int i = 0; i < values; ++i) {
                        Bytes key = in.readBytesNoCopy();
                        Bytes value = in.readBytesNoCopy();
                        result.pageData.add(new AbstractMap.SimpleImmutableEntry<Bytes, Bytes>(key, value));
                    }
                    break;
                }
                default: {
                    throw new IOException("bad index page type " + result.type);
                }
            }
            return result;
        }

        static PageContents deserialize(byte[] pagedata) throws IOException {
            try (ByteArrayCursor ein = ByteArrayCursor.wrap((byte[])pagedata);){
                PageContents pageContents = PageContents.deserialize(ein);
                return pageContents;
            }
        }
    }

    private static class UnsupportedMetadataVersionException
    extends HerdDBInternalException {
        private static final long serialVersionUID = 1L;
        private final long version;

        public UnsupportedMetadataVersionException(long version) {
            this.version = version;
        }
    }
}

