/*
 * Decompiled with CFR 0.152.
 */
package herddb.index;

import herddb.core.AbstractIndexManager;
import herddb.core.PostCheckpointAction;
import herddb.index.IndexOperation;
import herddb.index.KeyToPageIndex;
import herddb.index.PrimaryIndexPrefixScan;
import herddb.index.PrimaryIndexRangeScan;
import herddb.index.PrimaryIndexSeek;
import herddb.log.LogSequenceNumber;
import herddb.model.InvalidNullValueForKeyException;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.TableContext;
import herddb.sql.SQLRecordKeyFunction;
import herddb.storage.DataStorageManagerException;
import herddb.utils.BooleanHolder;
import herddb.utils.Bytes;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ConcurrentMapKeyToPageIndex
implements KeyToPageIndex {
    private final ConcurrentMap<Bytes, Long> map;
    private final AtomicLong usedMemory = new AtomicLong();
    private static final long ENTRY_OVERHEAD = 40L;

    public ConcurrentMapKeyToPageIndex(ConcurrentMap<Bytes, Long> map) {
        this.map = map;
        this.map.keySet().forEach(this::keyAdded);
    }

    public ConcurrentMap<Bytes, Long> getMap() {
        return this.map;
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public void put(Bytes key, Long currentPage) {
        Long res = this.map.put(key, currentPage);
        if (res == null) {
            this.keyAdded(key);
        }
    }

    @Override
    public boolean put(Bytes key, Long newPage, Long expectedPage) {
        if (expectedPage == null) {
            Long opage = this.map.putIfAbsent(key, newPage);
            if (opage == null) {
                this.keyAdded(key);
                return true;
            }
            return false;
        }
        BooleanHolder holder = new BooleanHolder(false);
        this.map.computeIfPresent(key, (skey, spage) -> {
            if (spage.equals(expectedPage)) {
                holder.value = true;
                return newPage;
            }
            return spage;
        });
        if (holder.value) {
            this.keyAdded(key);
            return true;
        }
        return false;
    }

    private void keyAdded(Bytes key) {
        this.usedMemory.addAndGet((long)key.getLength() + 40L);
    }

    private void keyRemoved(Bytes key) {
        this.usedMemory.addAndGet((long)(-key.getLength()) - 40L);
    }

    @Override
    public boolean containsKey(Bytes key) {
        return this.map.containsKey(key);
    }

    @Override
    public Long get(Bytes key) {
        return (Long)this.map.get(key);
    }

    @Override
    public Long remove(Bytes key) {
        Long res = (Long)this.map.remove(key);
        if (res != null) {
            this.keyRemoved(key);
        }
        return res;
    }

    @Override
    public boolean isSortedAscending(int[] pkTypes) {
        return false;
    }

    @Override
    public Stream<Map.Entry<Bytes, Long>> scanner(IndexOperation operation, StatementEvaluationContext context, TableContext tableContext, AbstractIndexManager index) throws DataStorageManagerException {
        if (operation instanceof PrimaryIndexSeek) {
            byte[] seekValue;
            PrimaryIndexSeek seek = (PrimaryIndexSeek)operation;
            try {
                seekValue = seek.value.computeNewValue(null, context, tableContext);
            }
            catch (InvalidNullValueForKeyException nullKey) {
                seekValue = null;
            }
            if (seekValue == null) {
                return Stream.empty();
            }
            Bytes key = Bytes.from_array((byte[])seekValue);
            Long pageId = (Long)this.map.get(key);
            if (pageId == null) {
                return Stream.empty();
            }
            return Stream.of(new AbstractMap.SimpleImmutableEntry<Bytes, Long>(key, pageId));
        }
        if (index != null) {
            return index.recordSetScanner(operation, context, tableContext, this);
        }
        if (operation == null) {
            Stream<Map.Entry<Bytes, Long>> baseStream = this.map.entrySet().stream();
            return baseStream;
        }
        if (operation instanceof PrimaryIndexPrefixScan) {
            byte[] prefix;
            PrimaryIndexPrefixScan scan = (PrimaryIndexPrefixScan)operation;
            try {
                prefix = scan.value.computeNewValue(null, context, tableContext);
            }
            catch (InvalidNullValueForKeyException err) {
                return Stream.empty();
            }
            catch (StatementExecutionException err) {
                throw new RuntimeException((Throwable)((Object)err));
            }
            Predicate<Map.Entry> predicate = t -> {
                Bytes fullrecordKey = (Bytes)t.getKey();
                return fullrecordKey.startsWith(prefix.length, prefix);
            };
            Stream baseStream = this.map.entrySet().stream();
            return baseStream.filter(predicate);
        }
        if (operation instanceof PrimaryIndexRangeScan) {
            PrimaryIndexRangeScan sis = (PrimaryIndexRangeScan)operation;
            SQLRecordKeyFunction minKey = sis.minValue;
            Bytes refminvalue = minKey != null ? Bytes.from_nullable_array((byte[])minKey.computeNewValue(null, context, tableContext)) : null;
            SQLRecordKeyFunction maxKey = sis.maxValue;
            Bytes refmaxvalue = maxKey != null ? Bytes.from_nullable_array((byte[])maxKey.computeNewValue(null, context, tableContext)) : null;
            Predicate<Map.Entry> predicate = refminvalue != null && refmaxvalue == null ? entry -> {
                Bytes datum = (Bytes)entry.getKey();
                return datum.compareTo(refminvalue) >= 0;
            } : (refminvalue == null && refmaxvalue != null ? entry -> {
                Bytes datum = (Bytes)entry.getKey();
                return datum.compareTo(refmaxvalue) <= 0;
            } : (refminvalue != null && refmaxvalue != null ? entry -> {
                Bytes datum = (Bytes)entry.getKey();
                return datum.compareTo(refmaxvalue) <= 0 && datum.compareTo(refminvalue) >= 0;
            } : entry -> true));
            Stream baseStream = this.map.entrySet().stream();
            return baseStream.filter(predicate);
        }
        throw new DataStorageManagerException("operation " + operation + " not implemented on " + this.getClass());
    }

    @Override
    public void close() {
        this.map.clear();
        this.usedMemory.set(0L);
    }

    @Override
    public void truncate() {
        this.map.clear();
        this.usedMemory.set(0L);
    }

    @Override
    public void dropData() {
        this.truncate();
    }

    @Override
    public long getUsedMemory() {
        return this.usedMemory.get();
    }

    @Override
    public boolean requireLoadAtStartup() {
        return true;
    }

    @Override
    public List<PostCheckpointAction> checkpoint(LogSequenceNumber sequenceNumber, boolean pin) throws DataStorageManagerException {
        return Collections.emptyList();
    }

    @Override
    public void unpinCheckpoint(LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
    }

    @Override
    public void start(LogSequenceNumber sequenceNumber, boolean created) throws DataStorageManagerException {
    }
}

