/*
 * Decompiled with CFR 0.152.
 */
package herddb.file;

import herddb.file.FileDataStorageManager;
import herddb.metadata.MetadataStorageManager;
import herddb.metadata.MetadataStorageManagerException;
import herddb.model.DDLException;
import herddb.model.NodeMetadata;
import herddb.model.TableSpace;
import herddb.model.TableSpaceAlreadyExistsException;
import herddb.model.TableSpaceDoesNotExistException;
import herddb.model.TableSpaceReplicaState;
import herddb.server.ServerConfiguration;
import herddb.utils.ExtendedDataInputStream;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.FileUtils;
import herddb.utils.ManagedFile;
import herddb.utils.SimpleBufferedOutputStream;
import herddb.utils.SimpleByteArrayInputStream;
import herddb.utils.XXHash64Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileMetadataStorageManager
extends MetadataStorageManager {
    private final Path baseDirectory;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Map<String, TableSpace> tableSpaces = new HashMap<String, TableSpace>();
    private final List<NodeMetadata> nodes = new ArrayList<NodeMetadata>();
    private static final Logger LOGGER = Logger.getLogger(FileMetadataStorageManager.class.getName());
    private final ConcurrentMap<String, Map<String, TableSpaceReplicaState>> statesForTableSpace = new ConcurrentHashMap<String, Map<String, TableSpaceReplicaState>>();
    private volatile boolean started;

    public FileMetadataStorageManager(Path baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    @Override
    public void start() throws MetadataStorageManagerException {
        if (this.started) {
            return;
        }
        try {
            Files.createDirectories(this.baseDirectory, new FileAttribute[0]);
            this.reloadFromDisk();
            this.started = true;
        }
        catch (IOException err) {
            throw new MetadataStorageManagerException(err);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Collection<String> listTableSpaces() {
        this.lock.readLock().lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.tableSpaces.keySet());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public TableSpace describeTableSpace(String name) {
        this.lock.readLock().lock();
        try {
            TableSpace tableSpace = this.tableSpaces.get(name.toLowerCase());
            return tableSpace;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void registerNode(NodeMetadata nodeMetadata) throws MetadataStorageManagerException {
        this.lock.writeLock().lock();
        try {
            if (this.nodes.stream().filter(s -> s.nodeId.equals(nodeMetadata.nodeId)).findAny().isPresent()) {
                throw new MetadataStorageManagerException("node " + nodeMetadata.nodeId + " already exists");
            }
            this.nodes.add(nodeMetadata);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void registerTableSpace(TableSpace tableSpace) throws DDLException, MetadataStorageManagerException {
        this.validateTableSpace(tableSpace);
        this.lock.writeLock().lock();
        try {
            if (this.tableSpaces.containsKey(tableSpace.name.toLowerCase())) {
                throw new TableSpaceAlreadyExistsException("a tablespace named " + tableSpace.name + " already exists");
            }
            this.persistTableSpaceOnDisk(tableSpace);
            this.tableSpaces.put(tableSpace.name.toLowerCase(), tableSpace);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void dropTableSpace(String name, TableSpace previous) throws DDLException, MetadataStorageManagerException {
        name = name.toLowerCase();
        this.lock.writeLock().lock();
        try {
            if (!this.tableSpaces.containsKey(name)) {
                throw new TableSpaceDoesNotExistException("a tablespace named " + name + " does not exist");
            }
            this.removeTableSpaceFromDisk(name);
            this.tableSpaces.remove(name);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateTableSpace(TableSpace tableSpace, TableSpace previous) throws DDLException, MetadataStorageManagerException {
        String name = tableSpace.name.toLowerCase();
        this.validateTableSpace(tableSpace);
        this.lock.writeLock().lock();
        try {
            if (!this.tableSpaces.containsKey(name)) {
                throw new TableSpaceDoesNotExistException("a tablespace named " + tableSpace.name.toLowerCase() + " does not exist");
            }
            this.persistTableSpaceOnDisk(tableSpace);
            this.tableSpaces.put(name, tableSpace);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void reloadFromDisk() throws MetadataStorageManagerException {
        this.tableSpaces.clear();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.baseDirectory);){
            for (Path p : stream) {
                Path filename = p.getFileName();
                if (filename == null) continue;
                String _filename = filename.toString();
                LOGGER.log(Level.SEVERE, "reading metadata file {0}", p.toAbsolutePath().toString());
                if (!_filename.endsWith(".metadata")) continue;
                TableSpace ts = FileMetadataStorageManager.readTableSpaceMetadataFile(p);
                if (!_filename.equals(ts.name.toLowerCase() + ".metadata")) continue;
                this.tableSpaces.put(ts.name.toLowerCase(), ts);
            }
        }
        catch (IOException err) {
            throw new MetadataStorageManagerException(err);
        }
    }

    public static TableSpace readTableSpaceMetadataFile(Path p) throws IOException, MetadataStorageManagerException {
        TableSpace ts;
        byte[] pageData;
        try {
            pageData = FileUtils.fastReadFile((Path)p);
        }
        catch (IOException err) {
            throw new MetadataStorageManagerException(err);
        }
        boolean okHash = XXHash64Utils.verifyBlockWithFooter((byte[])pageData, (int)0, (int)pageData.length);
        if (!okHash) {
            throw new MetadataStorageManagerException("corrutped data file " + p.toAbsolutePath() + ", checksum failed");
        }
        try (SimpleByteArrayInputStream in = new SimpleByteArrayInputStream(pageData);
             ExtendedDataInputStream iin = new ExtendedDataInputStream((InputStream)in);){
            long version = iin.readVLong();
            long flags = iin.readVLong();
            if (version != 1L || flags != 0L) {
                throw new IOException("corrupted data file " + p.toAbsolutePath());
            }
            ts = TableSpace.deserialize(iin, (Object)0, 0L);
        }
        return ts;
    }

    private void persistTableSpaceOnDisk(TableSpace tableSpace) throws MetadataStorageManagerException {
        Path tablespaceMetaTmp = this.baseDirectory.resolve(tableSpace.name.toLowerCase() + "." + System.nanoTime() + ".tmpmetadata");
        Path tablespaceMeta = this.baseDirectory.resolve(tableSpace.name.toLowerCase() + ".metadata");
        try (ManagedFile file = ManagedFile.open((Path)tablespaceMetaTmp, (boolean)ServerConfiguration.PROPERTY_REQUIRE_FSYNC_DEFAULT);
             SimpleBufferedOutputStream buffer = new SimpleBufferedOutputStream(file.getOutputStream(), FileDataStorageManager.COPY_BUFFERS_SIZE);
             XXHash64Utils.HashingOutputStream oo = new XXHash64Utils.HashingOutputStream((OutputStream)buffer);
             ExtendedDataOutputStream dout = new ExtendedDataOutputStream((OutputStream)oo);){
            dout.writeVLong(1L);
            dout.writeVLong(0L);
            tableSpace.serialize(dout);
            dout.writeLong(oo.hash());
            dout.flush();
            file.sync();
        }
        catch (IOException err) {
            throw new MetadataStorageManagerException(err);
        }
        try {
            Files.move(tablespaceMetaTmp, tablespaceMeta, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException err) {
            throw new MetadataStorageManagerException(err);
        }
    }

    @Override
    public void clear() throws MetadataStorageManagerException {
        this.lock.writeLock().lock();
        try {
            FileUtils.cleanDirectory((Path)this.baseDirectory);
            Files.createDirectories(this.baseDirectory, new FileAttribute[0]);
            this.nodes.clear();
            this.tableSpaces.clear();
        }
        catch (IOException err) {
            LOGGER.log(Level.SEVERE, "cannot clear local data", err);
            throw new MetadataStorageManagerException(err);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void removeTableSpaceFromDisk(String tableSpace) throws MetadataStorageManagerException {
        try {
            Path file = this.baseDirectory.resolve(tableSpace + ".metadata");
            Files.deleteIfExists(file);
        }
        catch (IOException error) {
            throw new MetadataStorageManagerException(error);
        }
    }

    @Override
    public boolean ensureDefaultTableSpace(String localNodeId, String initialReplicaList, long maxLeaderInactivityTime, int expectedReplicaCount) throws MetadataStorageManagerException {
        this.lock.writeLock().lock();
        try {
            TableSpace exists = this.tableSpaces.get("herd");
            if (exists == null) {
                TableSpace defaultTableSpace = TableSpace.builder().leader(localNodeId).replica(localNodeId).name("herd").build();
                this.registerTableSpace(defaultTableSpace);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (DDLException err) {
            throw new MetadataStorageManagerException((Throwable)((Object)err));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public List<NodeMetadata> listNodes() throws MetadataStorageManagerException {
        this.lock.readLock().lock();
        try {
            ArrayList<NodeMetadata> arrayList = new ArrayList<NodeMetadata>(this.nodes);
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<TableSpaceReplicaState> getTableSpaceReplicaState(String tableSpaceUuid) throws MetadataStorageManagerException {
        Map result = (Map)this.statesForTableSpace.get(tableSpaceUuid);
        if (result == null) {
            return Collections.emptyList();
        }
        return new ArrayList<TableSpaceReplicaState>(result.values());
    }

    @Override
    public void updateTableSpaceReplicaState(TableSpaceReplicaState state) throws MetadataStorageManagerException {
        Map failed;
        ConcurrentHashMap<String, TableSpaceReplicaState> result = (ConcurrentHashMap<String, TableSpaceReplicaState>)this.statesForTableSpace.get(state.uuid);
        if (result == null && (failed = (Map)this.statesForTableSpace.putIfAbsent(state.uuid, result = new ConcurrentHashMap<String, TableSpaceReplicaState>())) != null) {
            throw new MetadataStorageManagerException("concurrent modification to " + state.uuid + " tableSpace");
        }
        result.put(state.nodeId, state);
    }
}

