/*
 * Decompiled with CFR 0.152.
 */
package herddb.file;

import herddb.security.UserManager;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileBasedUserManager
extends UserManager {
    private Map<String, String> users = new HashMap<String, String>();
    private static final Logger LOG = Logger.getLogger(FileBasedUserManager.class.getName());

    public FileBasedUserManager(Path file) throws IOException {
        Files.readAllLines(file, StandardCharsets.UTF_8).forEach(l -> {
            if ((l = l.trim()).startsWith("#") || l.isEmpty()) {
                return;
            }
            String[] split = l.split(",");
            if (split.length == 3) {
                String role = split[2];
                if (role.equalsIgnoreCase("admin")) {
                    this.users.put(split[0], split[1]);
                    LOG.log(Level.SEVERE, "Configure user " + split[0] + " with role " + split[2]);
                } else {
                    LOG.log(Level.SEVERE, "Skipped user " + split[0] + " with role " + split[2] + ". bad role. Only 'admin' is available");
                }
            }
        });
    }

    @Override
    public String getExpectedPassword(String username) {
        return this.users.get(username);
    }
}

