/*
 * Decompiled with CFR 0.152.
 */
package herddb.data.consistency;

import herddb.codec.RecordSerializer;
import herddb.core.AbstractTableManager;
import herddb.core.DBManager;
import herddb.core.TableSpaceManager;
import herddb.data.consistency.TableChecksum;
import herddb.model.Column;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.Table;
import herddb.model.TransactionContext;
import herddb.model.commands.ScanStatement;
import herddb.sql.TranslatedQuery;
import herddb.utils.DataAccessor;
import herddb.utils.SystemInstrumentation;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jpountz.xxhash.StreamingXXHash64;
import net.jpountz.xxhash.XXHashFactory;

public abstract class TableDataChecksum {
    private static final Logger LOGGER = Logger.getLogger(TableDataChecksum.class.getName());
    private static final XXHashFactory FACTORY = XXHashFactory.fastestInstance();
    private static final int SEED = 0;
    public static final String HASH_TYPE = "StreamingXXHash64";

    public static TableChecksum createChecksum(DBManager manager, TranslatedQuery query, TableSpaceManager tableSpaceManager, String tableSpace, String tableName) throws DataScannerException {
        TableChecksum tableChecksum;
        block10: {
            AbstractTableManager tablemanager = tableSpaceManager.getTableManager(tableName);
            String nodeID = tableSpaceManager.getDbmanager().getNodeId();
            TranslatedQuery translated = query;
            Table table = manager.getTableSpaceManager(tableSpace).getTableManager(tableName).getTable();
            long nrecords = 0L;
            if (translated == null) {
                String columns = TableDataChecksum.formatColumns(table);
                translated = manager.getPlanner().translate(tableSpace, "SELECT  " + columns + " FROM " + tableName + " order by " + TableDataChecksum.formatPrimaryKeys(table), Collections.emptyList(), true, false, false, -1);
            }
            ScanStatement statement = (ScanStatement)translated.plan.mainStatement.unwrap(ScanStatement.class);
            statement.setAllowExecutionFromFollower(true);
            LOGGER.log(Level.INFO, "creating checksum for table {0}.{1} on node {2}", new Object[]{tableSpace, tableName, nodeID});
            DataScanner scan = manager.scan(statement, translated.context, TransactionContext.NO_TRANSACTION);
            try {
                StreamingXXHash64 hash64 = FACTORY.newStreamingHash64(0L);
                long _start = System.currentTimeMillis();
                while (scan.hasNext()) {
                    ++nrecords;
                    DataAccessor data = scan.next();
                    data.forEach((key, value) -> {
                        int type = table.getColumn((String)key).type;
                        byte[] serialize = RecordSerializer.serialize(value, type);
                        if (serialize != null) {
                            hash64.update(serialize, 0, serialize.length);
                        }
                    });
                }
                LOGGER.log(Level.INFO, "Number of processed records for table {0}.{1} on node {2} = {3} ", new Object[]{tableSpace, tableName, nodeID, nrecords});
                long _stop = System.currentTimeMillis();
                long nextAutoIncrementValue = tablemanager.getNextPrimaryKeyValue();
                long scanduration = _stop - _start;
                LOGGER.log(Level.INFO, "Creating checksum for table {0}.{1} on node {2} finished in {3} ms", new Object[]{tableSpace, tableName, nodeID, scanduration});
                SystemInstrumentation.instrumentationPoint((String)"createChecksum", (Object[])new Object[]{tableSpace, tableName});
                tableChecksum = new TableChecksum(tableSpace, tableName, hash64.getValue(), HASH_TYPE, nrecords, nextAutoIncrementValue, translated.context.query, scanduration);
                if (scan == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (scan != null) {
                        try {
                            scan.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DataScannerException ex) {
                    LOGGER.log(Level.SEVERE, "Scan failled", ex);
                    throw new DataScannerException(ex);
                }
            }
            scan.close();
        }
        return tableChecksum;
    }

    private static String formatPrimaryKeys(Table table) {
        return Arrays.asList(table.getPrimaryKey()).stream().collect(Collectors.joining(","));
    }

    private static String formatColumns(Table table) {
        return Stream.of(table.getColumns()).map(Column::getName).collect(Collectors.joining(","));
    }
}

