/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.system;

import herddb.codec.RecordSerializer;
import herddb.core.AbstractTableManager;
import herddb.core.TableSpaceManager;
import herddb.core.stats.TableManagerStats;
import herddb.core.system.AbstractSystemTableManager;
import herddb.model.Record;
import herddb.model.Table;
import herddb.model.Transaction;
import java.util.ArrayList;
import java.util.List;

public class SystablestatsTableManager
extends AbstractSystemTableManager {
    private static final Table TABLE = Table.builder().name("systablestats").column("tablespace", 0).column("table_name", 0).column("systemtable", 0).column("tablesize", 1).column("loadedpages", 2).column("loadedpagescount", 1).column("unloadedpagescount", 1).column("dirtypages", 2).column("dirtyrecords", 1).column("maxlogicalpagesize", 1).column("keysmemory", 1).column("buffersmemory", 1).column("dirtymemory", 1).primaryKey("tablespace", false).primaryKey("table_name", false).build();

    public SystablestatsTableManager(TableSpaceManager parent) {
        super(parent, TABLE);
    }

    @Override
    protected Iterable<Record> buildVirtualRecordList(Transaction transaction) {
        List<Table> tables = this.tableSpaceManager.getAllVisibleTables(transaction);
        ArrayList<Record> result = new ArrayList<Record>();
        for (Table r : tables) {
            AbstractTableManager tableManager = this.tableSpaceManager.getTableManager(r.name);
            if (tableManager == null || tableManager.isSystemTable()) continue;
            TableManagerStats stats = tableManager.getStats();
            result.add(RecordSerializer.makeRecord(this.table, "tablespace", r.tablespace, "table_name", r.name, "systemtable", r.name.startsWith("sys") ? "true" : "false", "tablesize", stats.getTablesize(), "loadedpages", stats.getLoadedpages(), "loadedpagescount", stats.getLoadedPagesCount(), "unloadedpagescount", stats.getUnloadedPagesCount(), "dirtypages", stats.getDirtypages(), "dirtyrecords", stats.getDirtyrecords(), "maxlogicalpagesize", stats.getMaxLogicalPageSize(), "keysmemory", stats.getKeysUsedMemory(), "buffersmemory", stats.getBuffersUsedMemory()));
        }
        return result;
    }
}

