/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.system;

import herddb.codec.RecordSerializer;
import herddb.core.TableSpaceManager;
import herddb.core.system.AbstractSystemTableManager;
import herddb.metadata.MetadataStorageManagerException;
import herddb.model.NodeMetadata;
import herddb.model.Record;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import herddb.model.Transaction;
import java.util.ArrayList;
import java.util.List;

public class SysnodesTableManager
extends AbstractSystemTableManager {
    private static final Table TABLE = Table.builder().name("sysnodes").column("nodeid", 0).column("address", 0).column("ssl", 2).primaryKey("nodeid", false).build();

    public SysnodesTableManager(TableSpaceManager parent) {
        super(parent, TABLE);
    }

    @Override
    protected Iterable<Record> buildVirtualRecordList(Transaction transaction) throws StatementExecutionException {
        try {
            List<NodeMetadata> nodes = this.tableSpaceManager.getMetadataStorageManager().listNodes();
            ArrayList<Record> result = new ArrayList<Record>();
            for (NodeMetadata t : nodes) {
                result.add(RecordSerializer.makeRecord(this.table, "nodeid", t.nodeId, "address", t.host + ":" + t.port, "ssl", t.ssl ? 1 : 0));
            }
            return result;
        }
        catch (MetadataStorageManagerException error) {
            throw new StatementExecutionException(error);
        }
    }
}

