/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.system;

import herddb.codec.RecordSerializer;
import herddb.core.AbstractIndexManager;
import herddb.core.TableSpaceManager;
import herddb.core.system.AbstractSystemTableManager;
import herddb.model.Record;
import herddb.model.Table;
import herddb.model.Transaction;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SysindexesTableManager
extends AbstractSystemTableManager {
    private static final Table TABLE = Table.builder().name("sysindexes").column("tablespace", 0).column("table_name", 0).column("index_name", 0).column("index_uuid", 0).column("index_type", 0).column("unique", 2).primaryKey("table_name", false).primaryKey("index_name", false).build();

    public SysindexesTableManager(TableSpaceManager parent) {
        super(parent, TABLE);
    }

    @Override
    protected Iterable<Record> buildVirtualRecordList(Transaction transaction) {
        List<Table> tables = this.tableSpaceManager.getAllVisibleTables(transaction);
        return tables.stream().flatMap(r -> {
            Map<String, AbstractIndexManager> indexesOnTable = this.tableSpaceManager.getIndexesOnTable(r.name);
            if (indexesOnTable == null) {
                return null;
            }
            return indexesOnTable.values().stream().map(i -> i.getIndex());
        }).map(r -> RecordSerializer.makeRecord(this.table, "tablespace", r.tablespace, "table_name", r.table, "index_name", r.name, "index_uuid", r.uuid, "index_type", r.type, "unique", r.unique ? 1 : 0)).collect(Collectors.toList());
    }
}

