/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.system;

import herddb.codec.RecordSerializer;
import herddb.core.AbstractIndexManager;
import herddb.core.TableSpaceManager;
import herddb.core.system.AbstractSystemTableManager;
import herddb.index.blink.BLinkKeyToPageIndex;
import herddb.model.Column;
import herddb.model.Index;
import herddb.model.Record;
import herddb.model.Table;
import herddb.model.Transaction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SysindexcolumnsTableManager
extends AbstractSystemTableManager {
    private static final Table TABLE = Table.builder().name("sysindexcolumns").column("tablespace", 0).column("table_name", 0).column("index_name", 0).column("index_uuid", 0).column("index_type", 0).column("column_name", 0).column("ordinal_position", 2).column("clustered", 2).column("unique", 2).primaryKey("table_name", false).primaryKey("index_name", false).primaryKey("column_name", false).build();

    public SysindexcolumnsTableManager(TableSpaceManager parent) {
        super(parent, TABLE);
    }

    @Override
    protected Iterable<Record> buildVirtualRecordList(Transaction transaction) {
        List<Table> tables = this.tableSpaceManager.getAllVisibleTables(transaction);
        ArrayList<Record> result = new ArrayList<Record>();
        tables.forEach(r -> {
            int posPk = 0;
            for (String pk : r.getPrimaryKey()) {
                Column column = r.getColumn(pk);
                String indexName = BLinkKeyToPageIndex.deriveIndexName(r.name);
                result.add(RecordSerializer.makeRecord(this.table, "index_type", "pk", "column_name", column.name, "ordinal_position", posPk++, "clustered", 1, "unique", 1, "tablespace", r.tablespace, "table_name", r.name, "index_name", indexName, "index_uuid", indexName));
            }
            Map<String, AbstractIndexManager> indexesOnTable = this.tableSpaceManager.getIndexesOnTable(r.name);
            if (indexesOnTable != null) {
                indexesOnTable.values().forEach(indexManager -> {
                    Index index = indexManager.getIndex();
                    int pos = 0;
                    for (Column cc : index.getColumns()) {
                        result.add(RecordSerializer.makeRecord(this.table, "tablespace", r.tablespace, "table_name", r.name, "index_name", index.name, "index_uuid", index.uuid, "index_type", index.type, "column_name", cc.name, "ordinal_position", pos++, "clustered", 0, "unique", index.unique ? 1 : 0));
                    }
                });
            }
        });
        return result;
    }
}

