/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.system;

import herddb.codec.RecordSerializer;
import herddb.core.TableSpaceManager;
import herddb.core.system.AbstractSystemTableManager;
import herddb.model.ForeignKeyDef;
import herddb.model.Record;
import herddb.model.Table;
import herddb.model.Transaction;
import java.util.ArrayList;
import java.util.List;

public class SysforeignkeysTableManager
extends AbstractSystemTableManager {
    private static final Table TABLE = Table.builder().name("sysforeignkeys").column("child_table_name", 0).column("child_table_column_name", 0).column("child_table_cons_name", 0).column("parent_table_name", 0).column("parent_table_column_name", 0).column("on_delete_action", 0).column("on_update_action", 0).column("ordinal_position", 2).column("deferred", 0).primaryKey("child_table_name", false).primaryKey("child_table_column_name", false).primaryKey("child_table_cons_name", false).build();

    public SysforeignkeysTableManager(TableSpaceManager parent) {
        super(parent, TABLE);
    }

    @Override
    protected Iterable<Record> buildVirtualRecordList(Transaction transaction) {
        List<Table> tables = this.tableSpaceManager.getAllVisibleTables(transaction);
        ArrayList<Record> result = new ArrayList<Record>();
        for (Table child : tables) {
            if (child.foreignKeys == null) continue;
            String child_table_name = child.name;
            for (ForeignKeyDef fk : child.foreignKeys) {
                Table parent = tables.stream().filter(ta -> ta.uuid.equals(fk.parentTableId)).findAny().orElse(null);
                if (parent == null) continue;
                for (int i = 0; i < fk.columns.length; ++i) {
                    String on_update_action;
                    String on_delete_action;
                    String child_column_name = fk.columns[i];
                    String parent_column_name = fk.parentTableColumns[i];
                    String parent_table_name = parent.name;
                    switch (fk.onDeleteAction) {
                        case 1: {
                            on_delete_action = "importedKeyCascade";
                            break;
                        }
                        case 0: {
                            on_delete_action = "importedNoAction";
                            break;
                        }
                        case 2: {
                            on_delete_action = "importedKeySetNull";
                            break;
                        }
                        default: {
                            on_delete_action = "importedKeyCascade";
                        }
                    }
                    switch (fk.onUpdateAction) {
                        case 1: {
                            on_update_action = "importedKeyCascade";
                            break;
                        }
                        case 0: {
                            on_update_action = "importedNoAction";
                            break;
                        }
                        case 2: {
                            on_update_action = "importedKeySetNull";
                            break;
                        }
                        default: {
                            on_update_action = "importedKeyCascade";
                        }
                    }
                    result.add(RecordSerializer.makeRecord(this.table, "child_table_name", child_table_name, "child_table_column_name", child_column_name, "child_table_cons_name", fk.name, "parent_table_name", parent_table_name, "parent_table_column_name", parent_column_name, "on_delete_action", on_delete_action, "on_update_action", on_update_action, "ordinal_position", i + 1, "deferred", "importedKeyNotDeferrable"));
                }
            }
        }
        return result;
    }
}

