/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.system;

import herddb.codec.RecordSerializer;
import herddb.core.TableSpaceManager;
import herddb.core.stats.ConnectionsInfoProvider;
import herddb.core.system.AbstractSystemTableManager;
import herddb.model.Record;
import herddb.model.Table;
import herddb.model.Transaction;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.stream.Collectors;

public class SysclientsTableManager
extends AbstractSystemTableManager {
    private static final Table TABLE = Table.builder().name("sysclients").column("id", 0).column("username", 0).column("address", 0).column("connectionts", 4).primaryKey("id", false).build();

    public SysclientsTableManager(TableSpaceManager parent) {
        super(parent, TABLE);
    }

    @Override
    protected Iterable<Record> buildVirtualRecordList(Transaction transaction) {
        ConnectionsInfoProvider connectionsInfoProvider = this.tableSpaceManager.getDbmanager().getConnectionsInfoProvider();
        if (connectionsInfoProvider == null) {
            return Collections.emptyList();
        }
        return connectionsInfoProvider.getActualConnections().connections.stream().map(r -> RecordSerializer.makeRecord(this.table, "id", r.id, "username", r.username, "address", r.address, "connectionts", new Timestamp(r.connectionTs))).collect(Collectors.toList());
    }
}

