/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.model.Column;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.Transaction;
import herddb.utils.DataAccessor;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

class StreamDataScanner
extends DataScanner {
    private final Iterator<DataAccessor> wrapped;
    private DataAccessor next;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public StreamDataScanner(Transaction transaction, String[] fieldNames, Column[] schema, Stream<DataAccessor> wrapped) {
        super(transaction, fieldNames, schema);
        this.wrapped = wrapped.iterator();
        this.fetchNext();
        if (transaction != null) {
            transaction.increaseRefcount();
        }
    }

    @Override
    public boolean hasNext() throws DataScannerException {
        return this.next != null;
    }

    private void fetchNext() {
        this.next = this.wrapped.hasNext() ? this.wrapped.next() : null;
    }

    @Override
    public DataAccessor next() throws DataScannerException {
        DataAccessor current = this.next;
        this.fetchNext();
        return current;
    }

    @Override
    public void close() throws DataScannerException {
        if (this.closed.compareAndSet(false, true)) {
            if (this.transaction != null) {
                this.transaction.decreaseRefCount();
            }
            super.close();
        }
    }
}

