/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.backup.DumpedTableMetadata;
import herddb.client.TableSpaceDumpReceiver;
import herddb.core.TableManager;
import herddb.core.TableSpaceManager;
import herddb.log.LogSequenceNumber;
import herddb.model.Index;
import herddb.model.Record;
import herddb.model.Table;
import herddb.storage.DataStorageManagerException;
import herddb.utils.SystemInstrumentation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicaFullTableDataDumpReceiver
extends TableSpaceDumpReceiver {
    private static final Logger LOGGER = Logger.getLogger(ReplicaFullTableDataDumpReceiver.class.getName());
    private TableManager currentTable;
    private final CompletableFuture<Object> latch = new CompletableFuture();
    private Throwable error;
    LogSequenceNumber logSequenceNumber;
    private final TableSpaceManager tableSpaceManager;
    private final String tableSpaceName;

    public ReplicaFullTableDataDumpReceiver(TableSpaceManager tableSpaceManager) {
        this.tableSpaceManager = tableSpaceManager;
        this.tableSpaceName = tableSpaceManager.getTableSpaceName();
    }

    @Override
    public void start(LogSequenceNumber logSequenceNumber) throws DataStorageManagerException {
        this.logSequenceNumber = logSequenceNumber;
    }

    public LogSequenceNumber getLogSequenceNumber() {
        return this.logSequenceNumber;
    }

    public CompletableFuture<Object> getLatch() {
        return this.latch;
    }

    public Throwable getError() {
        return this.error;
    }

    @Override
    public void onError(Throwable error) throws DataStorageManagerException {
        LOGGER.log(Level.SEVERE, "dumpReceiver " + this.tableSpaceName + ", onError ", error);
        this.error = error;
        this.latch.completeExceptionally(error);
    }

    @Override
    public void finish(LogSequenceNumber pos) throws DataStorageManagerException {
        LOGGER.log(Level.INFO, "dumpReceiver " + this.tableSpaceName + ", finish, at " + pos);
        this.latch.complete("");
    }

    @Override
    public void endTable() throws DataStorageManagerException {
        if (this.currentTable == null) {
            LOGGER.log(Level.SEVERE, "dumpReceiver " + this.tableSpaceName + ", endTable swallow data after leader side error");
            return;
        }
        LOGGER.log(Level.INFO, "dumpReceiver " + this.tableSpaceName + ", endTable " + this.currentTable.getTable().name);
        this.currentTable = null;
    }

    @Override
    public void receiveTableDataChunk(List<Record> record) throws DataStorageManagerException {
        if (this.currentTable == null) {
            LOGGER.log(Level.SEVERE, "dumpReceiver " + this.tableSpaceName + ", receiveTableDataChunk swallow data after leader side error");
            return;
        }
        this.currentTable.writeFromDump(record);
        SystemInstrumentation.instrumentationPoint((String)"receiveTableDataChunk", (Object[])new Object[]{this.tableSpaceManager, this.currentTable, record});
    }

    @Override
    public void beginTable(DumpedTableMetadata dumpedTable, Map<String, Object> stats) throws DataStorageManagerException {
        Table table = dumpedTable.table;
        LOGGER.log(Level.INFO, "dumpReceiver " + this.tableSpaceName + ", beginTable " + table.name + ", stats:" + stats + ", dumped at " + dumpedTable.logSequenceNumber + " (general dump at " + this.logSequenceNumber + ")");
        this.currentTable = this.tableSpaceManager.bootTable(table, 0L, dumpedTable.logSequenceNumber, false);
        for (Index index : dumpedTable.indexes) {
            this.tableSpaceManager.bootIndex(index, this.currentTable, false, 0L, false, true);
        }
    }
}

