/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.core.DataPage;
import herddb.model.Record;
import herddb.utils.ExtendedDataInputStream;
import herddb.utils.ExtendedDataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PageSet {
    private static final Logger LOGGER = Logger.getLogger(PageSet.class.getName());
    private final ConcurrentMap<Long, DataPageMetaData> activePages = new ConcurrentHashMap<Long, DataPageMetaData>();

    void setActivePagesAtBoot(Map<Long, DataPageMetaData> activePagesAtBoot) {
        this.activePages.clear();
        this.activePages.putAll(activePagesAtBoot);
    }

    Map<Long, DataPageMetaData> getActivePages() {
        return new HashMap<Long, DataPageMetaData>(this.activePages);
    }

    int getActivePagesCount() {
        return this.activePages.size();
    }

    void truncate() {
        this.activePages.clear();
    }

    void setPageDirty(Long pageId) {
        DataPageMetaData metadata = (DataPageMetaData)this.activePages.get(pageId);
        if (metadata == null) {
            LOGGER.log(Level.SEVERE, "Detected an attempt to set as dirty an unknown page " + pageId + ". Known pages: " + this.activePages);
            throw new IllegalStateException("attempted to set an unknown page as dirty " + pageId);
        }
        metadata.dirt.add(metadata.avgRecordSize);
    }

    void setPageDirty(Long pageId, long size) {
        DataPageMetaData metadata = (DataPageMetaData)this.activePages.get(pageId);
        if (metadata == null) {
            LOGGER.log(Level.SEVERE, "Detected an attempt to set as dirty an unknown page " + pageId + ". Known pages: " + this.activePages);
            throw new IllegalStateException("attempted to set an unknown page as dirty " + pageId);
        }
        metadata.dirt.add(size);
    }

    void setPageDirty(Long pageId, Record dirtyRecord) {
        if (dirtyRecord == null) {
            this.setPageDirty(pageId);
        } else {
            this.setPageDirty(pageId, DataPage.estimateEntrySize(dirtyRecord));
        }
    }

    public String toString() {
        return "PageSet{" + this.activePages + "}";
    }

    int getDirtyPagesCount() {
        return this.activePages.values().stream().mapToInt(meta -> meta.dirt.sum() > 0L ? 1 : 0).sum();
    }

    void pageCreated(Long pageId, DataPage page) throws IllegalStateException {
        DataPageMetaData old = this.activePages.putIfAbsent(pageId, new DataPageMetaData(page));
        if (old != null) {
            LOGGER.log(Level.SEVERE, "Detected concurrent creation of page " + page.pageId + ", writable: " + page.writable);
            throw new IllegalStateException("Creating a new page already existing! Page " + pageId);
        }
    }

    void checkpointDone(Collection<Long> pagesFlushed) {
        this.activePages.keySet().removeAll(pagesFlushed);
    }

    public static final class DataPageMetaData {
        final long size;
        final long avgRecordSize;
        final LongAdder dirt;

        public DataPageMetaData(DataPage page) {
            this.size = page.getUsedMemory();
            this.avgRecordSize = this.size / (long)page.size();
            this.dirt = new LongAdder();
        }

        private DataPageMetaData(long size, long avgRecordSize, long dirt) {
            this.size = size;
            this.avgRecordSize = avgRecordSize;
            this.dirt = new LongAdder();
            this.dirt.add(dirt);
        }

        public void serialize(ExtendedDataOutputStream output) throws IOException {
            output.writeVLong(this.size);
            output.writeVLong(this.avgRecordSize);
            output.writeVLong(this.dirt.sum());
        }

        public static DataPageMetaData deserialize(ExtendedDataInputStream input) throws IOException {
            return new DataPageMetaData(input.readVLong(), input.readVLong(), input.readVLong());
        }

        public String toString() {
            return '[' + Long.toString(this.size) + ',' + this.avgRecordSize + ',' + this.dirt.sum() + ']';
        }
    }
}

