/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.core.RecordSetFactory;
import herddb.model.Column;
import herddb.model.Projection;
import herddb.model.ScanLimits;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.TupleComparator;
import herddb.utils.DataAccessor;
import java.util.Iterator;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public abstract class MaterializedRecordSet
implements AutoCloseable,
Iterable<DataAccessor> {
    protected Column[] columns;
    protected String[] fieldNames;
    protected boolean writeFinished;
    protected int size;
    protected final int expectedSize;
    protected final RecordSetFactory factory;

    protected MaterializedRecordSet(int expectedSize, String[] fieldNames, Column[] columns, RecordSetFactory factory) {
        this.fieldNames = fieldNames;
        this.expectedSize = expectedSize;
        this.columns = columns;
        this.factory = factory;
        if (fieldNames == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public abstract Iterator<DataAccessor> iterator();

    public abstract void add(DataAccessor var1);

    public void writeFinished() {
        this.writeFinished = true;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public int size() {
        return this.size;
    }

    public int getExpectedSize() {
        return this.expectedSize;
    }

    public RecordSetFactory getFactory() {
        return this.factory;
    }

    public abstract void sort(TupleComparator var1);

    public abstract void applyProjection(Projection var1, StatementEvaluationContext var2) throws StatementExecutionException;

    public abstract void applyLimits(ScanLimits var1, StatementEvaluationContext var2) throws StatementExecutionException;

    @Override
    public void close() {
    }
}

