/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.core.MaterializedRecordSet;
import herddb.utils.DataAccessor;
import java.util.Arrays;
import java.util.Comparator;

public final class InStreamTupleSorter {
    private final int size;
    private final Comparator<DataAccessor> comparator;
    private final DataAccessor[] tuples;
    private int count;
    private DataAccessor reference;

    public InStreamTupleSorter(int size, Comparator<DataAccessor> comparator) {
        this.size = size;
        this.comparator = comparator;
        this.tuples = new DataAccessor[size];
    }

    public void collect(DataAccessor tuple) {
        int cmp;
        boolean full;
        boolean bl = full = this.count >= this.size;
        if (full && (cmp = this.comparator.compare(this.reference, tuple)) < 0) {
            return;
        }
        int idx = Arrays.binarySearch(this.tuples, 0, this.count, tuple, this.comparator);
        if (idx < 0) {
            idx = -idx - 1;
        }
        if (!full) {
            ++this.count;
        }
        System.arraycopy(this.tuples, idx, this.tuples, idx + 1, this.count - (idx + 1));
        this.tuples[idx] = tuple;
        this.reference = this.tuples[this.count - 1];
    }

    public void flushToRecordSet(MaterializedRecordSet rs) {
        for (int i = 0; i < this.count; ++i) {
            rs.add(this.tuples[i]);
        }
    }
}

