/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import com.google.common.util.concurrent.MoreExecutors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.core.AbstractTableManager;
import herddb.core.ActivatorRunRequest;
import herddb.core.MemoryManager;
import herddb.core.RecordSetFactory;
import herddb.core.RunningStatementsStats;
import herddb.core.TableSpaceManager;
import herddb.core.stats.ConnectionsInfoProvider;
import herddb.file.FileMetadataStorageManager;
import herddb.jmx.DBManagerStatsMXBean;
import herddb.jmx.JMXUtils;
import herddb.log.CommitLog;
import herddb.log.CommitLogManager;
import herddb.log.LogNotAvailableException;
import herddb.log.LogSequenceNumber;
import herddb.mem.MemoryMetadataStorageManager;
import herddb.metadata.MetadataChangeListener;
import herddb.metadata.MetadataStorageManager;
import herddb.metadata.MetadataStorageManagerException;
import herddb.model.DDLException;
import herddb.model.DDLStatement;
import herddb.model.DDLStatementExecutionResult;
import herddb.model.DMLStatement;
import herddb.model.DMLStatementExecutionResult;
import herddb.model.DataConsistencyStatementResult;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.ExecutionPlan;
import herddb.model.GetResult;
import herddb.model.NodeMetadata;
import herddb.model.NotLeaderException;
import herddb.model.ScanResult;
import herddb.model.Statement;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.Table;
import herddb.model.TableSpace;
import herddb.model.TableSpaceDoesNotExistException;
import herddb.model.TableSpaceReplicaState;
import herddb.model.TransactionContext;
import herddb.model.commands.AlterTableSpaceStatement;
import herddb.model.commands.CreateTableSpaceStatement;
import herddb.model.commands.DropTableSpaceStatement;
import herddb.model.commands.GetStatement;
import herddb.model.commands.ScanStatement;
import herddb.model.commands.TableConsistencyCheckStatement;
import herddb.model.commands.TableSpaceConsistencyCheckStatement;
import herddb.network.Channel;
import herddb.network.ServerHostData;
import herddb.proto.Pdu;
import herddb.proto.PduCodec;
import herddb.server.ServerConfiguration;
import herddb.server.ServerSidePreparedStatementCache;
import herddb.sql.AbstractSQLPlanner;
import herddb.sql.CalcitePlanner;
import herddb.sql.JSQLParserPlanner;
import herddb.sql.NullSQLPlanner;
import herddb.sql.PlansCache;
import herddb.sql.TranslatedQuery;
import herddb.storage.DataStorageManager;
import herddb.storage.DataStorageManagerException;
import herddb.utils.DefaultJVMHalt;
import herddb.utils.Futures;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;

public class DBManager
implements AutoCloseable,
MetadataChangeListener {
    private static final Logger LOGGER = Logger.getLogger(DBManager.class.getName());
    private final Map<String, TableSpaceManager> tablesSpaces = new ConcurrentHashMap<String, TableSpaceManager>();
    private final MetadataStorageManager metadataStorageManager;
    private final DataStorageManager dataStorageManager;
    private final CommitLogManager commitLogManager;
    private final String nodeId;
    private final String virtualTableSpaceId;
    private final ReentrantReadWriteLock generalLock = new ReentrantReadWriteLock();
    private final Thread activator;
    private final Activator activatorJ;
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final ExecutorService callbacksExecutor;
    private final AbstractSQLPlanner planner;
    private final ServerSidePreparedStatementCache preparedStatementsCache;
    private final Path tmpDirectory;
    private final RecordSetFactory recordSetFactory;
    private MemoryManager memoryManager;
    private final ServerHostData hostData;
    private String serverToServerUsername = "sa";
    private String serverToServerPassword = "hdb";
    private boolean errorIfNotLeader = true;
    private final ServerConfiguration serverConfiguration;
    private final String mode;
    private ConnectionsInfoProvider connectionsInfoProvider;
    private long checkpointPeriod;
    private long abandonedTransactionsTimeout;
    private final StatsLogger mainStatsLogger;
    private long maxMemoryReference = 0L;
    private long maxLogicalPageSize = 0x100000L;
    private long maxDataUsedMemory = 0L;
    private long maxPKUsedMemory = 0L;
    private boolean clearAtBoot = false;
    private boolean haltOnTableSpaceBootError = false;
    private Runnable haltProcedure = DefaultJVMHalt.INSTANCE;
    private final AtomicLong lastCheckPointTs = new AtomicLong(System.currentTimeMillis());
    private final RunningStatementsStats runningStatements;
    private final ExecutorService followersThreadPool;
    private final DBManagerStatsMXBean stats = new DBManagerStatsMXBean(){

        @Override
        public long getCachedPlans() {
            return DBManager.this.planner.getCacheSize();
        }

        @Override
        public long getCachePlansHits() {
            return DBManager.this.planner.getCacheHits();
        }

        @Override
        public long getCachePlansMisses() {
            return DBManager.this.planner.getCacheMisses();
        }
    };

    public DBManager(String nodeId, MetadataStorageManager metadataStorageManager, DataStorageManager dataStorageManager, CommitLogManager commitLogManager, Path tmpDirectory, ServerHostData hostData) {
        this(nodeId, metadataStorageManager, dataStorageManager, commitLogManager, tmpDirectory, hostData, new ServerConfiguration(), null);
    }

    public DBManager(String nodeId, MetadataStorageManager metadataStorageManager, DataStorageManager dataStorageManager, CommitLogManager commitLogManager, Path tmpDirectory, final ServerHostData hostData, ServerConfiguration configuration, StatsLogger statsLogger) {
        this.serverConfiguration = configuration;
        this.mode = this.serverConfiguration.getString("server.mode", "standalone");
        this.tmpDirectory = tmpDirectory;
        int asyncWorkerThreads = configuration.getInt("server.async.thread.workers", 64);
        this.callbacksExecutor = asyncWorkerThreads <= 0 ? MoreExecutors.newDirectExecutorService() : Executors.newFixedThreadPool(asyncWorkerThreads, new ThreadFactory(){
            private final AtomicLong count = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                String marker = hostData == null ? "local" : hostData.getHost() + ":" + hostData.getPort();
                return new FastThreadLocalThread(r, "db-dmlcall-" + marker + "-" + this.count.incrementAndGet());
            }
        });
        this.followersThreadPool = Executors.newCachedThreadPool(r -> new FastThreadLocalThread(r, "herddb-worker-" + (hostData == null ? "local" : hostData.getHost() + ":" + hostData.getPort()) + "-" + r));
        this.recordSetFactory = dataStorageManager.createRecordSetFactory();
        this.metadataStorageManager = metadataStorageManager;
        this.dataStorageManager = dataStorageManager;
        this.commitLogManager = commitLogManager;
        this.mainStatsLogger = statsLogger == null ? NullStatsLogger.INSTANCE : statsLogger;
        this.runningStatements = new RunningStatementsStats(this.mainStatsLogger);
        this.nodeId = nodeId;
        this.virtualTableSpaceId = this.makeVirtualTableSpaceManagerId(nodeId);
        this.hostData = hostData != null ? hostData : new ServerHostData("localhost", 7000, "", false, new HashMap());
        long planCacheMem = configuration.getLong("server.memory.planscache.limit", 0x3200000L);
        long statementsMem = configuration.getLong("server.memory.statementscache.limit", 0x3200000L);
        this.preparedStatementsCache = new ServerSidePreparedStatementCache(statementsMem);
        String plannerType = this.serverConfiguration.getString("server.planner.type", ServerConfiguration.PROPERTY_PLANNER_TYPE_DEFAULT);
        PlansCache plansCache = new PlansCache(planCacheMem);
        switch (plannerType) {
            case "calcite": {
                this.planner = new CalcitePlanner(this, plansCache);
                break;
            }
            case "jsqlparser": {
                this.planner = new JSQLParserPlanner(this, plansCache, null);
                break;
            }
            case "auto": {
                this.planner = new JSQLParserPlanner(this, plansCache, new CalcitePlanner(this, plansCache));
                break;
            }
            case "none": {
                this.planner = new NullSQLPlanner(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid planner type " + plannerType);
            }
        }
        this.activatorJ = new Activator();
        this.activator = new Thread((Runnable)this.activatorJ, "hdb-" + nodeId + "-activator");
        this.activator.setDaemon(true);
        this.maxMemoryReference = configuration.getLong("server.memory.max.limit", 0L);
        this.maxLogicalPageSize = configuration.getLong("server.memory.page.size", 0x100000L);
        this.maxDataUsedMemory = configuration.getLong("server.memory.data.limit", 0L);
        this.maxPKUsedMemory = configuration.getLong("server.memory.pk.limit", 0L);
    }

    public boolean isHaltOnTableSpaceBootError() {
        return this.haltOnTableSpaceBootError;
    }

    public void setHaltOnTableSpaceBootError(boolean haltOnTableSpaceBootError) {
        this.haltOnTableSpaceBootError = haltOnTableSpaceBootError;
    }

    public Runnable getHaltProcedure() {
        return this.haltProcedure;
    }

    public void setHaltProcedure(Runnable haltProcedure) {
        this.haltProcedure = haltProcedure;
    }

    public boolean isErrorIfNotLeader() {
        return this.errorIfNotLeader;
    }

    public void setErrorIfNotLeader(boolean errorIfNotLeader) {
        this.errorIfNotLeader = errorIfNotLeader;
    }

    public MetadataStorageManager getMetadataStorageManager() {
        return this.metadataStorageManager;
    }

    public DataStorageManager getDataStorageManager() {
        return this.dataStorageManager;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public String getServerToServerUsername() {
        return this.serverToServerUsername;
    }

    public void setServerToServerUsername(String serverToServerUsername) {
        this.serverToServerUsername = serverToServerUsername;
    }

    public String getServerToServerPassword() {
        return this.serverToServerPassword;
    }

    public void setServerToServerPassword(String serverToServerPassword) {
        this.serverToServerPassword = serverToServerPassword;
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public ConnectionsInfoProvider getConnectionsInfoProvider() {
        return this.connectionsInfoProvider;
    }

    public void setConnectionsInfoProvider(ConnectionsInfoProvider connectionsInfoProvider) {
        this.connectionsInfoProvider = connectionsInfoProvider;
    }

    public AbstractSQLPlanner getPlanner() {
        return this.planner;
    }

    public long getMaxMemoryReference() {
        return this.maxMemoryReference;
    }

    public void setMaxMemoryReference(long maxMemoryReference) {
        this.maxMemoryReference = maxMemoryReference;
    }

    public long getMaxLogicalPageSize() {
        return this.maxLogicalPageSize;
    }

    public void setMaxLogicalPageSize(long maxLogicalPageSize) {
        this.maxLogicalPageSize = maxLogicalPageSize;
    }

    public long getMaxDataUsedMemory() {
        return this.maxDataUsedMemory;
    }

    public void setMaxDataUsedMemory(long maxDataUsedMemory) {
        this.maxDataUsedMemory = maxDataUsedMemory;
    }

    public long getMaxPKUsedMemory() {
        return this.maxPKUsedMemory;
    }

    public void setMaxPKUsedMemory(long maxPKUsedMemory) {
        this.maxPKUsedMemory = maxPKUsedMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws DataStorageManagerException, LogNotAvailableException, MetadataStorageManagerException {
        String initialDefaultTableSpaceLeader;
        LOGGER.log(Level.FINE, "Starting DBManager at {0}", this.nodeId);
        if (this.serverConfiguration.getBoolean("server.jmx.enable", true)) {
            JMXUtils.registerDBManagerStatsMXBean(this.stats);
        }
        long maxHeap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        if (this.maxMemoryReference == 0L || this.maxMemoryReference > maxHeap) {
            this.maxMemoryReference = maxHeap;
        }
        LOGGER.log(Level.INFO, "server.memory.max.limit= {0} bytes", Long.toString(this.maxMemoryReference));
        if (this.maxDataUsedMemory == 0L || this.maxDataUsedMemory > this.maxMemoryReference) {
            this.maxDataUsedMemory = (long)(0.3f * (float)this.maxMemoryReference);
        }
        if (this.maxPKUsedMemory == 0L || this.maxPKUsedMemory > this.maxMemoryReference) {
            this.maxPKUsedMemory = (long)(0.2f * (float)this.maxMemoryReference);
        }
        if (this.maxDataUsedMemory + this.maxPKUsedMemory > this.maxMemoryReference) {
            long data = (int)((double)this.maxDataUsedMemory / (double)(this.maxDataUsedMemory + this.maxPKUsedMemory) * (double)this.maxMemoryReference);
            long pk = (int)((double)this.maxPKUsedMemory / (double)(this.maxDataUsedMemory + this.maxPKUsedMemory) * (double)this.maxMemoryReference);
            this.maxDataUsedMemory = data;
            this.maxPKUsedMemory = pk;
        }
        this.memoryManager = new MemoryManager(this.maxDataUsedMemory, this.maxPKUsedMemory, this.maxLogicalPageSize);
        this.metadataStorageManager.start();
        if (this.clearAtBoot) {
            this.metadataStorageManager.clear();
        }
        this.metadataStorageManager.setMetadataChangeListener(this);
        NodeMetadata nodeMetadata = NodeMetadata.builder().host(this.hostData.getHost()).port(this.hostData.getPort()).ssl(this.hostData.isSsl()).nodeId(this.nodeId).build();
        if (!this.mode.equals("local")) {
            LOGGER.log(Level.INFO, "Registering on metadata storage manager my data: {0}", nodeMetadata);
        }
        this.metadataStorageManager.registerNode(nodeMetadata);
        try {
            TableSpaceManager local_node_virtual_tables_manager = new TableSpaceManager(this.nodeId, this.virtualTableSpaceId, this.virtualTableSpaceId, 1, this.metadataStorageManager, this.dataStorageManager, null, this, true);
            this.tablesSpaces.put(this.virtualTableSpaceId, local_node_virtual_tables_manager);
            local_node_virtual_tables_manager.start();
        }
        catch (LogNotAvailableException | MetadataStorageManagerException | DDLException | DataStorageManagerException error) {
            throw new IllegalStateException("cannot boot local virtual tablespace manager");
        }
        String initialDefaultTableSpaceReplicaNode = initialDefaultTableSpaceLeader = this.nodeId;
        long initialDefaultTableSpaceMaxLeaderInactivityTime = 0L;
        int expectedreplicacount = 1;
        if ("diskless-cluster".equals(this.mode)) {
            initialDefaultTableSpaceReplicaNode = "*";
            initialDefaultTableSpaceMaxLeaderInactivityTime = 60000L;
            expectedreplicacount = this.serverConfiguration.getInt("tablespace.default.replica.count", 1);
        } else if ("cluster".equals(this.mode)) {
            expectedreplicacount = this.serverConfiguration.getInt("tablespace.default.replica.count", 1);
        }
        boolean created = this.metadataStorageManager.ensureDefaultTableSpace(initialDefaultTableSpaceLeader, initialDefaultTableSpaceReplicaNode, initialDefaultTableSpaceMaxLeaderInactivityTime, expectedreplicacount);
        if (created && !"local".equals(this.mode)) {
            LOGGER.log(Level.INFO, "Created default tablespace herd with expectedreplicacount={0}, leader={1}, replica={2}, maxleaderinactivitytime={3}", new Object[]{expectedreplicacount, initialDefaultTableSpaceLeader, initialDefaultTableSpaceReplicaNode, initialDefaultTableSpaceMaxLeaderInactivityTime});
        }
        this.commitLogManager.start();
        this.generalLock.writeLock().lock();
        try {
            this.dataStorageManager.start();
        }
        finally {
            this.generalLock.writeLock().unlock();
        }
        this.activator.start();
        this.triggerActivator(ActivatorRunRequest.FULL);
    }

    public boolean waitForTablespace(String tableSpace, int millis) throws InterruptedException {
        return this.waitForTablespace(tableSpace, millis, true);
    }

    public boolean waitForBootOfLocalTablespaces(int millis) throws InterruptedException, MetadataStorageManagerException {
        ArrayList<String> tableSpacesToWaitFor = new ArrayList<String>();
        Collection<String> allTableSpaces = this.metadataStorageManager.listTableSpaces();
        for (String tableSpaceName : allTableSpaces) {
            TableSpace tableSpace = this.metadataStorageManager.describeTableSpace(tableSpaceName);
            if (!tableSpace.leaderId.equals(this.nodeId)) continue;
            tableSpacesToWaitFor.add(tableSpaceName);
        }
        LOGGER.log(Level.INFO, "Waiting (max " + millis + " ms) for boot of local tablespaces: " + tableSpacesToWaitFor);
        for (String tableSpace : tableSpacesToWaitFor) {
            boolean ok = this.waitForTablespace(tableSpace, millis, true);
            if (ok) continue;
            return false;
        }
        return true;
    }

    public boolean waitForTablespace(String tableSpace, int millis, boolean checkLeader) throws InterruptedException {
        long now = System.currentTimeMillis();
        while (System.currentTimeMillis() - now <= (long)millis) {
            TableSpaceManager manager = this.tablesSpaces.get(tableSpace);
            if (manager != null) {
                if (checkLeader && manager.isLeader()) {
                    return true;
                }
                if (!checkLeader) {
                    return true;
                }
            }
            Thread.sleep(100L);
        }
        return false;
    }

    public boolean waitForTable(String tableSpace, String table, int millis, boolean checkLeader) throws InterruptedException {
        long now = System.currentTimeMillis();
        while (System.currentTimeMillis() - now <= (long)millis) {
            TableSpaceManager manager = this.tablesSpaces.get(tableSpace);
            if (manager != null) {
                AbstractTableManager tableManager;
                if (checkLeader && manager.isLeader() && manager.getTableManager(table) != null) {
                    return true;
                }
                if (!checkLeader && (tableManager = manager.getTableManager(table)) != null && tableManager.isStarted()) {
                    return true;
                }
            }
            Thread.sleep(100L);
        }
        return false;
    }

    private void handleTableSpace(TableSpace tableSpace) throws DataStorageManagerException, LogNotAvailableException, MetadataStorageManagerException, DDLException {
        String tableSpaceName = tableSpace.name;
        TableSpaceManager actual_manager = this.tablesSpaces.get(tableSpaceName);
        if (actual_manager != null && actual_manager.isFailed()) {
            LOGGER.log(Level.INFO, "Tablespace {0} is in 'Failed' status", new Object[]{tableSpaceName, this.nodeId});
            return;
        }
        if (actual_manager != null && actual_manager.isLeader() && !tableSpace.leaderId.equals(this.nodeId)) {
            LOGGER.log(Level.INFO, "Tablespace {0} leader is no more {1}, it changed to {2}", new Object[]{tableSpaceName, this.nodeId, tableSpace.leaderId});
            this.stopTableSpace(tableSpaceName, tableSpace.uuid);
            return;
        }
        if (actual_manager != null && !actual_manager.isLeader() && tableSpace.leaderId.equals(this.nodeId)) {
            LOGGER.log(Level.INFO, "Tablespace {0} need to switch to leadership on node {1}", new Object[]{tableSpaceName, this.nodeId});
            this.stopTableSpace(tableSpaceName, tableSpace.uuid);
            return;
        }
        if (tableSpace.isNodeAssignedToTableSpace(this.nodeId) && !this.tablesSpaces.containsKey(tableSpaceName)) {
            LOGGER.log(Level.INFO, "Booting tablespace {0} on {1}, uuid {2}", new Object[]{tableSpaceName, this.nodeId, tableSpace.uuid});
            long _start = System.currentTimeMillis();
            CommitLog commitLog = this.commitLogManager.createCommitLog(tableSpace.uuid, tableSpace.name, this.nodeId);
            TableSpaceManager manager = new TableSpaceManager(this.nodeId, tableSpaceName, tableSpace.uuid, tableSpace.expectedReplicaCount, this.metadataStorageManager, this.dataStorageManager, commitLog, this, false);
            try {
                manager.start();
                LOGGER.log(Level.INFO, "Boot success tablespace {0} on {1}, uuid {2}, time {3} ms leader:{4}", new Object[]{tableSpaceName, this.nodeId, tableSpace.uuid, System.currentTimeMillis() - _start + "", manager.isLeader()});
                this.tablesSpaces.put(tableSpaceName, manager);
                if (this.serverConfiguration.getBoolean("server.jmx.enable", true)) {
                    JMXUtils.registerTableSpaceManagerStatsMXBean(tableSpaceName, manager.getStats());
                }
            }
            catch (LogNotAvailableException | MetadataStorageManagerException | DDLException | DataStorageManagerException t) {
                LOGGER.log(Level.SEVERE, "Error Booting tablespace {0} on {1}", new Object[]{tableSpaceName, this.nodeId});
                LOGGER.log(Level.SEVERE, "Error", t);
                this.tablesSpaces.remove(tableSpaceName);
                try {
                    manager.close();
                }
                catch (Throwable t2) {
                    LOGGER.log(Level.SEVERE, "Other Error", t2);
                    t.addSuppressed(t2);
                }
                throw t;
            }
            return;
        }
        if (this.tablesSpaces.containsKey(tableSpaceName) && !tableSpace.isNodeAssignedToTableSpace(this.nodeId)) {
            LOGGER.log(Level.INFO, "Tablespace {0} on {1} is not more in replica list {3}, uuid {2}", new Object[]{tableSpaceName, this.nodeId, tableSpace.uuid, tableSpace.replicas + ""});
            this.stopTableSpace(tableSpaceName, tableSpace.uuid);
            return;
        }
        if (!tableSpace.isNodeAssignedToTableSpace("*") && tableSpace.replicas.size() < tableSpace.expectedReplicaCount) {
            List<NodeMetadata> nodes = this.metadataStorageManager.listNodes();
            LOGGER.log(Level.WARNING, "Tablespace {0} is underreplicated expectedReplicaCount={1}, replicas={2}, nodes={3}", new Object[]{tableSpaceName, tableSpace.expectedReplicaCount, tableSpace.replicas, nodes});
            List availableOtherNodes = nodes.stream().map(n -> n.nodeId).filter(n -> !tableSpace.replicas.contains(n)).collect(Collectors.toList());
            Collections.shuffle(availableOtherNodes);
            int countMissing = tableSpace.expectedReplicaCount - tableSpace.replicas.size();
            LOGGER.log(Level.WARNING, "Tablespace {0} is underreplicated expectedReplicaCount={1}, replicas={2}, missing {3}, availableOtherNodes={4}", new Object[]{tableSpaceName, tableSpace.expectedReplicaCount, tableSpace.replicas, countMissing, availableOtherNodes});
            if (!availableOtherNodes.isEmpty()) {
                TableSpace.Builder newTableSpaceBuilder = TableSpace.builder().cloning(tableSpace);
                while (!availableOtherNodes.isEmpty() && countMissing-- > 0) {
                    String node = (String)availableOtherNodes.remove(0);
                    LOGGER.log(Level.WARNING, "Tablespace {0} adding {1} node as replica", new Object[]{tableSpaceName, node});
                    newTableSpaceBuilder.replica(node);
                }
                TableSpace newTableSpace = newTableSpaceBuilder.build();
                boolean ok = this.metadataStorageManager.updateTableSpace(newTableSpace, tableSpace);
                if (!ok) {
                    LOGGER.log(Level.SEVERE, "updating tableSpace {0} metadata failed, someone else altered metadata", tableSpaceName);
                }
            }
        }
        if (actual_manager != null && !actual_manager.isFailed() && actual_manager.isLeader()) {
            actual_manager.metadataUpdated(tableSpace);
        }
    }

    public StatementExecutionResult executeStatement(Statement statement, StatementEvaluationContext context, TransactionContext transactionContext) throws StatementExecutionException {
        CompletableFuture<StatementExecutionResult> res = this.executeStatementAsync(statement, context, transactionContext);
        try {
            return res.get();
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new StatementExecutionException(err);
        }
        catch (ExecutionException err) {
            Throwable cause = err.getCause();
            if (cause instanceof StatementExecutionException) {
                throw (StatementExecutionException)((Object)cause);
            }
            throw new StatementExecutionException(cause);
        }
        catch (Throwable t) {
            throw new StatementExecutionException(t);
        }
    }

    public CompletableFuture<StatementExecutionResult> executeStatementAsync(Statement statement, StatementEvaluationContext context, TransactionContext transactionContext) {
        context.setDefaultTablespace(statement.getTableSpace());
        context.setManager(this);
        context.setTransactionContext(transactionContext);
        String tableSpace = statement.getTableSpace();
        if (tableSpace == null) {
            return Futures.exception((Throwable)((Object)new StatementExecutionException("invalid null tableSpace")));
        }
        if (statement instanceof CreateTableSpaceStatement) {
            if (transactionContext.transactionId > 0L) {
                return Futures.exception((Throwable)((Object)new StatementExecutionException("CREATE TABLESPACE cannot be issued inside a transaction")));
            }
            return CompletableFuture.completedFuture(this.createTableSpace((CreateTableSpaceStatement)statement));
        }
        if (statement instanceof AlterTableSpaceStatement) {
            if (transactionContext.transactionId > 0L) {
                return Futures.exception((Throwable)((Object)new StatementExecutionException("ALTER TABLESPACE cannot be issued inside a transaction")));
            }
            return CompletableFuture.completedFuture(this.alterTableSpace((AlterTableSpaceStatement)statement));
        }
        if (statement instanceof DropTableSpaceStatement) {
            if (transactionContext.transactionId > 0L) {
                return Futures.exception((Throwable)((Object)new StatementExecutionException("DROP TABLESPACE cannot be issued inside a transaction")));
            }
            return CompletableFuture.completedFuture(this.dropTableSpace((DropTableSpaceStatement)statement));
        }
        if (statement instanceof TableSpaceConsistencyCheckStatement) {
            if (transactionContext.transactionId > 0L) {
                return Futures.exception((Throwable)((Object)new StatementExecutionException("TABLESPACECONSISTENCYCHECK cannot be issue inside a transaction")));
            }
            return CompletableFuture.completedFuture(this.createTableSpaceCheckSum((TableSpaceConsistencyCheckStatement)statement));
        }
        TableSpaceManager manager = this.tablesSpaces.get(tableSpace);
        if (manager == null) {
            return Futures.exception((Throwable)((Object)new NotLeaderException("No such tableSpace " + tableSpace + " here (at " + this.nodeId + "). Maybe the server is starting ")));
        }
        if (this.errorIfNotLeader && !manager.isLeader()) {
            return Futures.exception((Throwable)((Object)new NotLeaderException("node " + this.nodeId + " is not leader for tableSpace " + tableSpace)));
        }
        CompletableFuture<StatementExecutionResult> res = manager.executeStatementAsync(statement, context, transactionContext);
        if (statement instanceof DDLStatement) {
            res.whenComplete((s, err) -> this.planner.clearCache());
            this.planner.clearCache();
        }
        return res;
    }

    public GetResult get(GetStatement statement, StatementEvaluationContext context, TransactionContext transactionContext) throws StatementExecutionException {
        return (GetResult)this.executeStatement(statement, context, transactionContext);
    }

    public StatementExecutionResult executePlan(ExecutionPlan plan, StatementEvaluationContext context, TransactionContext transactionContext) throws StatementExecutionException {
        CompletableFuture<StatementExecutionResult> res = this.executePlanAsync(plan, context, transactionContext);
        try {
            return res.get();
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new StatementExecutionException(err);
        }
        catch (ExecutionException err) {
            Throwable cause = err.getCause();
            if (cause instanceof StatementExecutionException) {
                throw (StatementExecutionException)((Object)cause);
            }
            throw new StatementExecutionException(cause);
        }
        catch (Throwable t) {
            throw new StatementExecutionException(t);
        }
    }

    public CompletableFuture<StatementExecutionResult> executePlanAsync(ExecutionPlan plan, StatementEvaluationContext context, TransactionContext transactionContext) {
        try {
            context.setManager(this);
            plan.validateContext(context);
            if (plan.mainStatement instanceof ScanStatement) {
                DataScanner result = this.scan((ScanStatement)plan.mainStatement, context, transactionContext);
                transactionContext = new TransactionContext(result.getTransactionId());
                return CompletableFuture.completedFuture(new ScanResult(transactionContext.transactionId, result));
            }
            return this.executeStatementAsync(plan.mainStatement, context, transactionContext);
        }
        catch (NotLeaderException err) {
            LOGGER.log(Level.INFO, "not-leader", (Throwable)((Object)err));
            return Futures.exception((Throwable)((Object)err));
        }
        catch (Throwable err) {
            LOGGER.log(Level.SEVERE, "uncaught error", err);
            return Futures.exception((Throwable)err);
        }
    }

    public DataScanner executeSimpleQuery(String tableSpace, String query, List<Object> parameters, int maxRows, boolean keepReadLocks, TransactionContext transactionContext, StatementEvaluationContext context) {
        ScanResult scanResult = (ScanResult)this.executeSimpleStatement(tableSpace, query, parameters, maxRows, keepReadLocks, transactionContext, context);
        return scanResult.dataScanner;
    }

    public StatementExecutionResult executeSimpleStatement(String tableSpace, String query, List<Object> parameters, int maxRows, boolean keepReadLocks, TransactionContext transactionContext, StatementEvaluationContext context) {
        TranslatedQuery translatedQuery = this.planner.translate(tableSpace, query, parameters, true, true, false, maxRows);
        translatedQuery.context.setForceRetainReadLock(keepReadLocks);
        return this.executePlan(translatedQuery.plan, context != null ? context : translatedQuery.context, transactionContext);
    }

    public DataScanner scan(ScanStatement statement, StatementEvaluationContext context, TransactionContext transactionContext) throws StatementExecutionException {
        context.setDefaultTablespace(statement.getTableSpace());
        context.setManager(this);
        context.setTransactionContext(transactionContext);
        String tableSpace = statement.getTableSpace();
        if (tableSpace == null) {
            throw new StatementExecutionException("invalid null tableSpace");
        }
        TableSpaceManager manager = this.tablesSpaces.get(tableSpace);
        if (manager == null) {
            throw new NotLeaderException("No such tableSpace " + tableSpace + " here (at " + this.nodeId + "). Maybe the server is starting ");
        }
        boolean allowExecutionFromFollower = statement.getAllowExecutionFromFollower();
        if (this.errorIfNotLeader && !manager.isLeader() && !allowExecutionFromFollower) {
            throw new NotLeaderException("node " + this.nodeId + " is not leader for tableSpace " + tableSpace);
        }
        return manager.scan(statement, context, transactionContext, false, false);
    }

    public DMLStatementExecutionResult executeUpdate(DMLStatement statement, StatementEvaluationContext context, TransactionContext transactionContext) throws StatementExecutionException {
        return (DMLStatementExecutionResult)this.executeStatement(statement, context, transactionContext);
    }

    private StatementExecutionResult createTableSpace(CreateTableSpaceStatement createTableSpaceStatement) throws StatementExecutionException {
        TableSpace tableSpace;
        try {
            tableSpace = TableSpace.builder().leader(createTableSpaceStatement.getLeaderId()).name(createTableSpaceStatement.getTableSpace()).replicas(createTableSpaceStatement.getReplicas()).expectedReplicaCount(createTableSpaceStatement.getExpectedReplicaCount()).maxLeaderInactivityTime(createTableSpaceStatement.getMaxleaderinactivitytime()).build();
        }
        catch (IllegalArgumentException invalid) {
            throw new StatementExecutionException("invalid CREATE TABLESPACE statement: " + invalid.getMessage(), invalid);
        }
        try {
            this.metadataStorageManager.registerTableSpace(tableSpace);
            this.triggerActivator(ActivatorRunRequest.FULL);
            if (createTableSpaceStatement.getWaitForTableSpaceTimeout() > 0) {
                boolean okWait = false;
                int poolTime = 100;
                if (this.metadataStorageManager instanceof MemoryMetadataStorageManager || this.metadataStorageManager instanceof FileMetadataStorageManager) {
                    poolTime = 5;
                }
                LOGGER.log(Level.INFO, "waiting for  " + tableSpace.name + ", uuid " + tableSpace.uuid + ", to be up withint " + createTableSpaceStatement.getWaitForTableSpaceTimeout() + " ms");
                int timeout = createTableSpaceStatement.getWaitForTableSpaceTimeout();
                for (int i = 0; i < timeout; i += poolTime) {
                    List<TableSpaceReplicaState> replicateStates = this.metadataStorageManager.getTableSpaceReplicaState(tableSpace.uuid);
                    for (TableSpaceReplicaState ts : replicateStates) {
                        LOGGER.log(Level.INFO, "waiting for  " + tableSpace.name + ", uuid " + tableSpace.uuid + ", to be up, replica state node: " + ts.nodeId + ", state: " + TableSpaceReplicaState.modeToSQLString(ts.mode) + ", ts " + new Timestamp(ts.timestamp));
                        if (ts.mode != 1) continue;
                        okWait = true;
                        break;
                    }
                    if (okWait) break;
                    Thread.sleep(poolTime);
                }
                if (!okWait) {
                    throw new StatementExecutionException("tablespace " + tableSpace.name + ", uuid " + tableSpace.uuid + " has been created but leader " + tableSpace.leaderId + " did not start within " + createTableSpaceStatement.getWaitForTableSpaceTimeout() + " ms");
                }
            }
            return new DDLStatementExecutionResult(0L);
        }
        catch (StatementExecutionException err) {
            throw err;
        }
        catch (Exception err) {
            throw new StatementExecutionException(err);
        }
    }

    @Override
    public void close() throws DataStorageManagerException {
        this.stopped.set(true);
        this.setActivatorPauseStatus(false);
        this.triggerActivator(ActivatorRunRequest.NOOP);
        try {
            this.activator.join();
        }
        catch (InterruptedException ignore) {
            ignore.printStackTrace();
        }
        this.followersThreadPool.shutdownNow();
        if (this.serverConfiguration.getBoolean("server.jmx.enable", true)) {
            JMXUtils.unregisterDBManagerStatsMXBean();
        }
        this.callbacksExecutor.shutdownNow();
        try {
            this.followersThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
            this.callbacksExecutor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void checkpoint() throws DataStorageManagerException, LogNotAvailableException {
        for (TableSpaceManager man : this.tablesSpaces.values()) {
            man.checkpoint(false, false, false);
        }
    }

    public void triggerActivator(ActivatorRunRequest type) {
        this.activatorJ.offer(type);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getVirtualTableSpaceId() {
        return this.virtualTableSpaceId;
    }

    public String getMode() {
        return this.mode;
    }

    void submit(Runnable runnable) {
        try {
            this.followersThreadPool.submit(runnable);
        }
        catch (RejectedExecutionException err) {
            LOGGER.log(Level.SEVERE, "rejected " + runnable, err);
        }
    }

    private StatementExecutionResult alterTableSpace(AlterTableSpaceStatement alterTableSpaceStatement) throws StatementExecutionException {
        try {
            TableSpace tableSpace;
            TableSpace previous = this.metadataStorageManager.describeTableSpace(alterTableSpaceStatement.getTableSpace());
            if (previous == null) {
                throw new TableSpaceDoesNotExistException(alterTableSpaceStatement.getTableSpace());
            }
            try {
                tableSpace = TableSpace.builder().cloning(previous).leader(alterTableSpaceStatement.getLeaderId()).name(alterTableSpaceStatement.getTableSpace()).replicas(alterTableSpaceStatement.getReplicas()).expectedReplicaCount(alterTableSpaceStatement.getExpectedReplicaCount()).maxLeaderInactivityTime(alterTableSpaceStatement.getMaxleaderinactivitytime()).build();
            }
            catch (IllegalArgumentException invalid) {
                throw new StatementExecutionException("invalid ALTER TABLESPACE statement: " + invalid.getMessage(), invalid);
            }
            this.metadataStorageManager.updateTableSpace(tableSpace, previous);
            this.triggerActivator(ActivatorRunRequest.FULL);
            return new DDLStatementExecutionResult(0L);
        }
        catch (Exception err) {
            throw new StatementExecutionException(err);
        }
    }

    private StatementExecutionResult dropTableSpace(DropTableSpaceStatement dropTableSpaceStatement) throws StatementExecutionException {
        try {
            TableSpace previous = this.metadataStorageManager.describeTableSpace(dropTableSpaceStatement.getTableSpace());
            if (previous == null) {
                throw new TableSpaceDoesNotExistException(dropTableSpaceStatement.getTableSpace());
            }
            this.metadataStorageManager.dropTableSpace(dropTableSpaceStatement.getTableSpace(), previous);
            this.triggerActivator(ActivatorRunRequest.TABLESPACEMANAGEMENT);
            return new DDLStatementExecutionResult(0L);
        }
        catch (Exception err) {
            throw new StatementExecutionException(err);
        }
    }

    public void dumpTableSpace(String tableSpace, String dumpId, Pdu message, Channel channel, int fetchSize, boolean includeLog) {
        TableSpaceManager manager = this.tablesSpaces.get(tableSpace);
        if (manager == null) {
            ByteBuf resp = PduCodec.ErrorResponse.write((long)message.messageId, (String)("tableSpace " + tableSpace + " not booted here"));
            channel.sendReplyMessage(message.messageId, resp);
            return;
        }
        ByteBuf resp = PduCodec.AckResponse.write((long)message.messageId);
        channel.sendReplyMessage(message.messageId, resp);
        try {
            manager.dumpTableSpace(dumpId, channel, fetchSize, includeLog);
        }
        catch (Exception error) {
            LOGGER.log(Level.SEVERE, "error on dump", error);
        }
    }

    public DataConsistencyStatementResult createTableCheckSum(TableConsistencyCheckStatement tableConsistencyCheckStatement, StatementEvaluationContext context) {
        TableSpaceManager manager = this.tablesSpaces.get(tableConsistencyCheckStatement.getTableSpace());
        String tableName = tableConsistencyCheckStatement.getTable();
        String tableSpaceName = tableConsistencyCheckStatement.getTableSpace();
        if (manager == null) {
            return new DataConsistencyStatementResult(false, "No such tablespace " + tableSpaceName);
        }
        try {
            manager.createAndWriteTableCheksum(manager, tableSpaceName, tableName, context);
        }
        catch (DataScannerException | IOException ex) {
            LOGGER.log(Level.SEVERE, "Error on check of tablespace " + tableSpaceName, ex);
            return new DataConsistencyStatementResult(false, "Error on check of tablespace " + tableSpaceName + ":" + ex);
        }
        return new DataConsistencyStatementResult(true, "Check table consistency for " + tableName + "completed");
    }

    public DataConsistencyStatementResult createTableSpaceCheckSum(TableSpaceConsistencyCheckStatement tableSpaceConsistencyCheckStatement) {
        TableSpaceManager manager = this.tablesSpaces.get(tableSpaceConsistencyCheckStatement.getTableSpace());
        String tableSpace = tableSpaceConsistencyCheckStatement.getTableSpace();
        List<Table> tables = manager.getAllCommittedTables();
        long _start = System.currentTimeMillis();
        for (Table table : tables) {
            AbstractTableManager tableManager = manager.getTableManager(table.name);
            if (tableManager.isSystemTable()) continue;
            try {
                manager.createAndWriteTableCheksum(manager, tableSpace, tableManager.getTable().name, null);
            }
            catch (DataScannerException | IOException ex) {
                LOGGER.log(Level.SEVERE, "Error on check of tablespace " + tableSpace, ex);
                return new DataConsistencyStatementResult(false, "Error on check  of tablespace " + tableSpace + ":" + ex);
            }
        }
        long _stop = System.currentTimeMillis();
        long tableSpace_check_duration = _stop - _start;
        LOGGER.log(Level.INFO, "Check tablespace consistency for {0} Completed in {1} ms", new Object[]{tableSpace, tableSpace_check_duration});
        return new DataConsistencyStatementResult(true, "Check tablespace consistency for " + tableSpace + "completed in " + tableSpace_check_duration);
    }

    private String makeVirtualTableSpaceManagerId(String nodeId) {
        return nodeId.replace(":", "").replace(".", "").toLowerCase();
    }

    public boolean isTableSpaceLocallyRecoverable(TableSpace tableSpace) {
        LogSequenceNumber logSequenceNumber = this.dataStorageManager.getLastcheckpointSequenceNumber(tableSpace.uuid);
        try (CommitLog tmpCommitLog = this.commitLogManager.createCommitLog(tableSpace.uuid, tableSpace.name, this.nodeId);){
            boolean bl = tmpCommitLog.isRecoveryAvailable(logSequenceNumber);
            return bl;
        }
    }

    private boolean tryBecomeLeaderFor(TableSpace tableSpace) throws DDLException, MetadataStorageManagerException {
        if (!this.isTableSpaceLocallyRecoverable(tableSpace)) {
            LOGGER.log(Level.INFO, "local node {0} cannot become leader of {1} (current is {2}).Cannot boot tablespace locally (not enough data, last checkpoint + log)", new Object[]{this.nodeId, tableSpace.name, tableSpace.leaderId});
            return false;
        }
        LOGGER.log(Level.INFO, "node {0}, try to become leader of {1} (prev was {2})", new Object[]{this.nodeId, tableSpace.name, tableSpace.leaderId});
        TableSpace.Builder newTableSpaceBuilder = TableSpace.builder().cloning(tableSpace).leader(this.nodeId);
        TableSpace newTableSpace = newTableSpaceBuilder.build();
        boolean ok = this.metadataStorageManager.updateTableSpace(newTableSpace, tableSpace);
        if (!ok) {
            LOGGER.log(Level.SEVERE, "node {0} updating tableSpace {1} try to become leader failed", new Object[]{this.nodeId, tableSpace.name});
            return false;
        }
        LOGGER.log(Level.SEVERE, "node {0} updating tableSpace {1} try to become leader succeeded", new Object[]{this.nodeId, tableSpace.name});
        return true;
    }

    long handleLocalMemoryUsage() {
        long result = 0L;
        for (TableSpaceManager tableSpaceManager : this.tablesSpaces.values()) {
            result += tableSpaceManager.handleLocalMemoryUsage();
        }
        return result;
    }

    public void setActivatorPauseStatus(boolean pause) {
        if (pause) {
            this.activatorJ.pause();
        } else {
            this.activatorJ.resume();
        }
    }

    public final boolean isStopped() {
        return this.stopped.get();
    }

    private void executeActivator(ActivatorRunRequest type) {
        try {
            if (type.enableTableSpacesManagement() && this.manageTableSpaces()) {
                return;
            }
            boolean checkpointDone = false;
            if (type.enableGlobalCheckPoint()) {
                long now = System.currentTimeMillis();
                if (this.checkpointPeriod > 0L && now - this.lastCheckPointTs.get() > this.checkpointPeriod) {
                    this.lastCheckPointTs.set(now);
                    try {
                        this.checkpoint();
                        checkpointDone = true;
                    }
                    catch (LogNotAvailableException | DataStorageManagerException error) {
                        LOGGER.log(Level.SEVERE, "checkpoint failed:" + (Object)((Object)error), error);
                    }
                }
            }
            if (!checkpointDone && type.enableTableCheckPoints()) {
                for (TableSpaceManager man : this.tablesSpaces.values()) {
                    man.runLocalTableCheckPoints();
                }
            }
            if (!checkpointDone && type.enableAbandonedTransactionsMaintenaince()) {
                for (TableSpaceManager man : this.tablesSpaces.values()) {
                    man.processAbandonedTransactions();
                }
            }
        }
        catch (RuntimeException err) {
            LOGGER.log(Level.SEVERE, "Fatal error during a system management task", err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean manageTableSpaces() {
        Collection<String> actualTablesSpaces;
        try {
            actualTablesSpaces = this.metadataStorageManager.listTableSpaces();
        }
        catch (MetadataStorageManagerException error) {
            LOGGER.log(Level.SEVERE, "cannot access tablespaces metadata", error);
            return true;
        }
        HashMap<String, TableSpace> currentTableSpaceMetadata = new HashMap<String, TableSpace>();
        this.generalLock.writeLock().lock();
        try {
            for (String tableSpace : actualTablesSpaces) {
                TableSpace tableSpaceMetadata = this.metadataStorageManager.describeTableSpace(tableSpace);
                if (tableSpaceMetadata == null) {
                    LOGGER.log(Level.INFO, "tablespace {0} does not exist", tableSpace);
                    continue;
                }
                currentTableSpaceMetadata.put(tableSpaceMetadata.uuid, tableSpaceMetadata);
                try {
                    this.handleTableSpace(tableSpaceMetadata);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "cannot handle tablespace " + tableSpace, exception);
                    if (!this.haltOnTableSpaceBootError || this.haltProcedure == null) continue;
                    exception.printStackTrace();
                    this.haltProcedure.run();
                }
            }
        }
        catch (MetadataStorageManagerException error) {
            LOGGER.log(Level.SEVERE, "cannot access tablespaces metadata", error);
            boolean tableSpace = true;
            return tableSpace;
        }
        finally {
            this.generalLock.writeLock().unlock();
        }
        ArrayList<TableSpaceManager> followingActiveTableSpaces = new ArrayList<TableSpaceManager>();
        HashSet<String> failedTableSpaces = new HashSet<String>();
        for (Map.Entry bl : this.tablesSpaces.entrySet()) {
            try {
                String tableSpaceUuid = ((TableSpaceManager)bl.getValue()).getTableSpaceUUID();
                if (((TableSpaceManager)bl.getValue()).isFailed()) {
                    LOGGER.log(Level.SEVERE, "tablespace " + tableSpaceUuid + " failed");
                    failedTableSpaces.add((String)bl.getKey());
                    continue;
                }
                if (!((String)bl.getKey()).equals(this.virtualTableSpaceId) && !actualTablesSpaces.contains(((String)bl.getKey()).toLowerCase())) {
                    LOGGER.log(Level.SEVERE, "tablespace " + tableSpaceUuid + " should not run here");
                    failedTableSpaces.add((String)bl.getKey());
                    continue;
                }
                if (((TableSpaceManager)bl.getValue()).isLeader()) {
                    this.metadataStorageManager.updateTableSpaceReplicaState(TableSpaceReplicaState.builder().mode(1).nodeId(this.nodeId).uuid(tableSpaceUuid).timestamp(System.currentTimeMillis()).build());
                    continue;
                }
                this.metadataStorageManager.updateTableSpaceReplicaState(TableSpaceReplicaState.builder().mode(2).nodeId(this.nodeId).uuid(tableSpaceUuid).timestamp(System.currentTimeMillis()).build());
                followingActiveTableSpaces.add((TableSpaceManager)bl.getValue());
            }
            catch (MetadataStorageManagerException error) {
                LOGGER.log(Level.SEVERE, "cannot access tablespace " + (String)bl.getKey() + " metadata", error);
                return true;
            }
        }
        if (!failedTableSpaces.isEmpty()) {
            this.generalLock.writeLock().lock();
            try {
                for (String string : failedTableSpaces) {
                    this.stopTableSpace(string, null);
                }
            }
            catch (MetadataStorageManagerException error) {
                LOGGER.log(Level.SEVERE, "cannot access tablespace metadata", error);
                boolean bl = true;
                return bl;
            }
            finally {
                this.generalLock.writeLock().unlock();
            }
        }
        if (!followingActiveTableSpaces.isEmpty()) {
            long now = System.currentTimeMillis();
            try {
                for (TableSpaceManager tableSpaceManager : followingActiveTableSpaces) {
                    long delta;
                    String tableSpaceUuid = tableSpaceManager.getTableSpaceUUID();
                    TableSpace tableSpaceInfo = (TableSpace)currentTableSpaceMetadata.get(tableSpaceUuid);
                    if (tableSpaceInfo == null || tableSpaceInfo.leaderId.equals(this.nodeId) || tableSpaceInfo.maxLeaderInactivityTime <= 0L || tableSpaceManager.isFailed()) continue;
                    List<TableSpaceReplicaState> allReplicas = this.metadataStorageManager.getTableSpaceReplicaState(tableSpaceUuid);
                    TableSpaceReplicaState leaderState = allReplicas.stream().filter(t -> t.nodeId.equals(tableSpaceInfo.leaderId)).findAny().orElse(null);
                    if (leaderState == null) {
                        leaderState = new TableSpaceReplicaState(tableSpaceUuid, tableSpaceInfo.leaderId, tableSpaceInfo.metadataStorageCreationTime, 3);
                        LOGGER.log(Level.INFO, "Leader for " + tableSpaceUuid + " should be " + tableSpaceInfo.leaderId + ", but it never sent pings or it disappeared, considering last activity as tablespace creation time: " + new Timestamp(tableSpaceInfo.metadataStorageCreationTime) + " to leave a minimal grace period");
                    }
                    if (tableSpaceInfo.maxLeaderInactivityTime > (delta = now - leaderState.timestamp)) {
                        LOGGER.log(Level.FINE, "Leader for " + tableSpaceUuid + " is " + tableSpaceInfo.leaderId + ", last ping " + new Timestamp(leaderState.timestamp) + ". leader is healty");
                        continue;
                    }
                    LOGGER.log(Level.SEVERE, "Leader for " + tableSpaceUuid + " is " + tableSpaceInfo.leaderId + ", last ping " + new Timestamp(leaderState.timestamp) + ". leader is failed.");
                    if (!this.tryBecomeLeaderFor(tableSpaceInfo)) continue;
                    break;
                }
            }
            catch (MetadataStorageManagerException | DDLException error) {
                LOGGER.log(Level.SEVERE, "cannot access tablespace metadata", (Throwable)error);
                return true;
            }
        }
        return false;
    }

    private void stopTableSpace(String tableSpace, String uuid) throws MetadataStorageManagerException {
        LOGGER.log(Level.INFO, "stopTableSpace " + tableSpace + " uuid " + uuid + ", on " + this.nodeId);
        try {
            this.tablesSpaces.get(tableSpace).close();
        }
        catch (LogNotAvailableException err) {
            LOGGER.log(Level.SEVERE, "node " + this.nodeId + " cannot close for reboot tablespace " + tableSpace, (Throwable)((Object)err));
        }
        this.tablesSpaces.remove(tableSpace);
        if (uuid != null) {
            this.metadataStorageManager.updateTableSpaceReplicaState(TableSpaceReplicaState.builder().mode(3).nodeId(this.nodeId).uuid(uuid).timestamp(System.currentTimeMillis()).build());
        }
    }

    public Collection<String> getLocalTableSpaces() {
        return new ArrayList<String>(this.tablesSpaces.keySet());
    }

    public TableSpaceManager getTableSpaceManager(String tableSpace) {
        return this.tablesSpaces.get(tableSpace);
    }

    public Path getTmpDirectory() {
        return this.tmpDirectory;
    }

    public RecordSetFactory getRecordSetFactory() {
        return this.recordSetFactory;
    }

    public long getCheckpointPeriod() {
        return this.checkpointPeriod;
    }

    public void setCheckpointPeriod(long checkpointPeriod) {
        this.checkpointPeriod = checkpointPeriod;
    }

    public long getAbandonedTransactionsTimeout() {
        return this.abandonedTransactionsTimeout;
    }

    public void setAbandonedTransactionsTimeout(long abandonedTransactionsTimeout) {
        this.abandonedTransactionsTimeout = abandonedTransactionsTimeout;
    }

    public long getLastCheckPointTs() {
        return this.lastCheckPointTs.get();
    }

    @Override
    public void metadataChanged(String description) {
        LOGGER.log(Level.INFO, "metadata changed: " + description);
        this.triggerActivator(ActivatorRunRequest.TABLESPACEMANAGEMENT);
    }

    public boolean isClearAtBoot() {
        return this.clearAtBoot;
    }

    public void setClearAtBoot(boolean clearAtBoot) {
        this.clearAtBoot = clearAtBoot;
    }

    public RunningStatementsStats getRunningStatements() {
        return this.runningStatements;
    }

    public ExecutorService getCallbacksExecutor() {
        return this.callbacksExecutor;
    }

    public ServerSidePreparedStatementCache getPreparedStatementsCache() {
        return this.preparedStatementsCache;
    }

    public StatsLogger getStatsLogger() {
        return this.mainStatsLogger;
    }

    public boolean isFullSQLSupportEnabled() {
        String plannerType = this.serverConfiguration.getString("server.planner.type", ServerConfiguration.PROPERTY_PLANNER_TYPE_DEFAULT);
        return plannerType.equals("calcite") || plannerType.equals("auto");
    }

    private class Activator
    implements Runnable {
        private final Lock runLock = new ReentrantLock();
        private final Condition resume = this.runLock.newCondition();
        private final BlockingQueue<ActivatorRunRequest> activatorQueue = new ArrayBlockingQueue<ActivatorRunRequest>(1);
        private volatile boolean activatorPaused = false;

        private Activator() {
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
        public void offer(ActivatorRunRequest type) {
            this.activatorQueue.offer(type);
        }

        public void resume() {
            this.runLock.lock();
            try {
                boolean wasPaused = this.activatorPaused;
                if (!wasPaused) {
                    return;
                }
                this.activatorPaused = false;
                this.resume.signalAll();
            }
            finally {
                this.runLock.unlock();
            }
        }

        public void pause() {
            this.runLock.lock();
            try {
                this.activatorPaused = true;
            }
            finally {
                this.runLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (!DBManager.this.stopped.get()) {
                        this.runLock.lock();
                        try {
                            if (this.activatorPaused) {
                                LOGGER.log(Level.INFO, "{0} activator paused", DBManager.this.nodeId);
                                this.resume.awaitUninterruptibly();
                                LOGGER.log(Level.INFO, "{0} activator resumed", DBManager.this.nodeId);
                                continue;
                            }
                        }
                        finally {
                            this.runLock.unlock();
                            continue;
                        }
                        Object type = this.activatorQueue.poll(1L, TimeUnit.SECONDS);
                        if (type == null) {
                            type = ActivatorRunRequest.FULL;
                        }
                        this.activatorQueue.clear();
                        if (DBManager.this.stopped.get()) continue;
                        DBManager.this.executeActivator(type);
                    }
                }
                catch (InterruptedException type) {
                    // empty catch block
                }
                DBManager.this.generalLock.writeLock().lock();
                try {
                    for (Map.Entry manager : DBManager.this.tablesSpaces.entrySet()) {
                        try {
                            ((TableSpaceManager)manager.getValue()).close();
                        }
                        catch (Exception err) {
                            LOGGER.log(Level.SEVERE, "error during shutdown of manager of tablespace " + (String)manager.getKey(), err);
                        }
                    }
                }
                finally {
                    DBManager.this.generalLock.writeLock().unlock();
                }
                try {
                    DBManager.this.dataStorageManager.close();
                }
                catch (Exception err) {
                    LOGGER.log(Level.SEVERE, "error during shutdown", err);
                }
                try {
                    DBManager.this.metadataStorageManager.close();
                }
                catch (Exception err) {
                    LOGGER.log(Level.SEVERE, "error during shutdown", err);
                }
                try {
                    DBManager.this.commitLogManager.close();
                }
                catch (Exception err) {
                    LOGGER.log(Level.SEVERE, "error during shutdown", err);
                }
                LOGGER.log(Level.FINE, "{0} activator stopped", DBManager.this.nodeId);
            }
            catch (RuntimeException err) {
                LOGGER.log(Level.SEVERE, "fatal activator erro", err);
            }
        }
    }
}

