/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.core.HerdDBInternalException;
import herddb.core.PostCheckpointAction;
import herddb.core.stats.TableManagerStats;
import herddb.index.KeyToPageIndex;
import herddb.log.CommitLogResult;
import herddb.log.LogEntry;
import herddb.log.LogSequenceNumber;
import herddb.model.DDLException;
import herddb.model.DataScanner;
import herddb.model.Index;
import herddb.model.Record;
import herddb.model.Statement;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.Table;
import herddb.model.Transaction;
import herddb.model.commands.ScanStatement;
import herddb.storage.DataStorageManagerException;
import herddb.storage.FullTableScanConsumer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public interface AbstractTableManager
extends AutoCloseable {
    public TableManagerStats getStats();

    public Table getTable();

    public long getCreatedInTransaction();

    public List<Index> getAvailableIndexes();

    public KeyToPageIndex getKeyToPageIndex();

    public LogSequenceNumber getBootSequenceNumber();

    public long getNextPrimaryKeyValue();

    public boolean isSystemTable();

    default public boolean isKeyToPageSortedAscending() {
        return false;
    }

    public boolean isStarted();

    public void start(boolean var1) throws DataStorageManagerException;

    @Override
    public void close();

    public void flush() throws DataStorageManagerException;

    public void dump(LogSequenceNumber var1, FullTableScanConsumer var2) throws DataStorageManagerException;

    public TableCheckpoint checkpoint(boolean var1) throws DataStorageManagerException;

    public TableCheckpoint fullCheckpoint(boolean var1) throws DataStorageManagerException;

    public void unpinCheckpoint(LogSequenceNumber var1) throws DataStorageManagerException;

    public void dropTableData() throws DataStorageManagerException;

    public void tableAltered(Table var1, Transaction var2) throws DDLException;

    public void validateAlterTable(Table var1, StatementEvaluationContext var2) throws StatementExecutionException;

    public void onTransactionRollback(Transaction var1) throws DataStorageManagerException;

    public void onTransactionCommit(Transaction var1, boolean var2) throws DataStorageManagerException;

    public void apply(CommitLogResult var1, LogEntry var2, boolean var3) throws DataStorageManagerException;

    default public StatementExecutionResult executeStatement(Statement statement, Transaction transaction, StatementEvaluationContext context) throws StatementExecutionException {
        CompletableFuture<StatementExecutionResult> res = this.executeStatementAsync(statement, transaction, context);
        try {
            return res.get();
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new StatementExecutionException(err);
        }
        catch (ExecutionException err) {
            Throwable cause = err.getCause();
            if (cause instanceof HerdDBInternalException && cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof StatementExecutionException) {
                throw (StatementExecutionException)((Object)cause);
            }
            throw new StatementExecutionException(cause);
        }
    }

    public CompletableFuture<StatementExecutionResult> executeStatementAsync(Statement var1, Transaction var2, StatementEvaluationContext var3);

    public DataScanner scan(ScanStatement var1, StatementEvaluationContext var2, Transaction var3, boolean var4, boolean var5) throws StatementExecutionException;

    public void scanForIndexRebuild(Consumer<Record> var1) throws DataStorageManagerException;

    default public void rebuildForeignKeyReferences(Table table) {
    }

    public static final class TableCheckpoint {
        final String tableName;
        final LogSequenceNumber sequenceNumber;
        final List<PostCheckpointAction> actions;

        public TableCheckpoint(String tableName, LogSequenceNumber sequenceNumber, List<PostCheckpointAction> actions) {
            this.tableName = tableName;
            this.sequenceNumber = sequenceNumber;
            this.actions = actions;
        }
    }
}

