/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.core.AbstractTableManager;
import herddb.core.PostCheckpointAction;
import herddb.index.IndexOperation;
import herddb.index.KeyToPageIndex;
import herddb.log.CommitLog;
import herddb.log.LogSequenceNumber;
import herddb.model.Index;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.TableContext;
import herddb.model.Transaction;
import herddb.storage.DataStorageManager;
import herddb.storage.DataStorageManagerException;
import herddb.utils.Bytes;
import herddb.utils.ILocalLockManager;
import herddb.utils.LocalLockManager;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public abstract class AbstractIndexManager
implements AutoCloseable {
    protected final Index index;
    protected final AbstractTableManager tableManager;
    protected final DataStorageManager dataStorageManager;
    protected final String tableSpaceUUID;
    protected final CommitLog log;
    protected long createdInTransaction;
    private final boolean unique;
    private final ILocalLockManager lockManager;

    public AbstractIndexManager(Index index, AbstractTableManager tableManager, DataStorageManager dataStorageManager, String tableSpaceUUID, CommitLog log, long createdInTransaction, int writeLockTimeout, int readLockTimeout) {
        this.index = index;
        this.createdInTransaction = createdInTransaction;
        this.tableManager = tableManager;
        this.dataStorageManager = dataStorageManager;
        this.tableSpaceUUID = tableSpaceUUID;
        this.log = log;
        this.unique = index.unique;
        if (this.unique) {
            LocalLockManager newLockManager = new LocalLockManager();
            newLockManager.setWriteLockTimeout(writeLockTimeout);
            newLockManager.setReadLockTimeout(readLockTimeout);
            this.lockManager = newLockManager;
        } else {
            this.lockManager = null;
        }
    }

    public final boolean isUnique() {
        return this.unique;
    }

    public ILocalLockManager getLockManager() {
        return this.lockManager;
    }

    public final Index getIndex() {
        return this.index;
    }

    public final String getIndexName() {
        return this.index.name;
    }

    public final String[] getColumnNames() {
        return this.index.columnNames;
    }

    public void start(LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        boolean needRebuild;
        boolean bl = needRebuild = !this.doStart(sequenceNumber);
        if (needRebuild) {
            this.dropIndexData();
            this.rebuild();
        }
    }

    protected abstract boolean doStart(LogSequenceNumber var1) throws DataStorageManagerException;

    @Override
    public void close() {
    }

    public abstract void rebuild() throws DataStorageManagerException;

    public abstract List<PostCheckpointAction> checkpoint(LogSequenceNumber var1, boolean var2) throws DataStorageManagerException;

    public abstract void unpinCheckpoint(LogSequenceNumber var1) throws DataStorageManagerException;

    protected abstract Stream<Bytes> scanner(IndexOperation var1, StatementEvaluationContext var2, TableContext var3) throws StatementExecutionException;

    public Stream<Map.Entry<Bytes, Long>> recordSetScanner(IndexOperation operation, StatementEvaluationContext context, TableContext tableContext, KeyToPageIndex keyToPageIndex) throws DataStorageManagerException, StatementExecutionException {
        return this.scanner(operation, context, tableContext).map(b -> {
            Long idPage = keyToPageIndex.get((Bytes)b);
            if (idPage == null) {
                return null;
            }
            return new AbstractMap.SimpleImmutableEntry<Bytes, Long>((Bytes)b, idPage);
        }).filter(p -> p != null);
    }

    public abstract void recordUpdated(Bytes var1, Bytes var2, Bytes var3) throws DataStorageManagerException;

    public abstract void recordInserted(Bytes var1, Bytes var2) throws DataStorageManagerException;

    public abstract void recordDeleted(Bytes var1, Bytes var2) throws DataStorageManagerException;

    public void dropIndexData() throws DataStorageManagerException {
        this.dataStorageManager.dropIndex(this.tableSpaceUUID, this.index.uuid);
    }

    public void truncateIndexData() throws DataStorageManagerException {
        this.dataStorageManager.truncateIndex(this.tableSpaceUUID, this.index.uuid);
    }

    final void onTransactionCommit(Transaction transaction, boolean recovery) throws DataStorageManagerException {
        if (this.createdInTransaction > 0L) {
            if (transaction.transactionId != this.createdInTransaction) {
                throw new DataStorageManagerException("this indexManager (" + this.getIndexName() + ") is available only on transaction " + this.createdInTransaction + " and not in transaction " + transaction.transactionId);
            }
            this.createdInTransaction = 0L;
        }
        if (this.lockManager != null) {
            transaction.releaseLocksOnTable(this.getIndexName(), this.lockManager);
        }
    }

    final void onTransactionRollback(Transaction transaction) {
        if (this.lockManager != null) {
            transaction.releaseLocksOnTable(this.getIndexName(), this.lockManager);
        }
    }

    public long getCreatedInTransaction() {
        return this.createdInTransaction;
    }

    public final boolean isAvailable() {
        return this.createdInTransaction == 0L;
    }

    public abstract void truncate() throws DataStorageManagerException;

    public abstract boolean valueAlreadyMapped(Bytes var1, Bytes var2) throws DataStorageManagerException;
}

