/*
 * Decompiled with CFR 0.152.
 */
package herddb.codec;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.codec.DataAccessorForFullRecord;
import herddb.model.Column;
import herddb.model.ColumnTypes;
import herddb.model.ColumnsList;
import herddb.model.Record;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import herddb.utils.AbstractDataAccessor;
import herddb.utils.ByteArrayCursor;
import herddb.utils.Bytes;
import herddb.utils.DataAccessor;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.IllegalDataAccessException;
import herddb.utils.RawString;
import herddb.utils.SQLRecordPredicateFunctions;
import herddb.utils.SingleEntryMap;
import herddb.utils.SystemProperties;
import herddb.utils.VisibleByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class RecordSerializer {
    private static final int INITIAL_BUFFER_SIZE = SystemProperties.getIntSystemProperty((String)"herddb.serializer.initbufsize", (int)1024);
    private static final ZoneId UTC = ZoneId.of("UTC");
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(UTC);
    private static final DateTimeFormatter TIMESTAMP_FORMATTER_WITH_MILLIS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S").withZone(UTC);
    private static final DateTimeFormatter TIMESTAMP_FORMATTER_ONLY_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(UTC);

    public static Object deserialize(Bytes data, int type) {
        switch (type) {
            case 3: 
            case 14: {
                return data.to_array();
            }
            case 2: 
            case 12: {
                return data.to_int();
            }
            case 1: 
            case 13: {
                return data.to_long();
            }
            case 0: 
            case 11: {
                return data.to_RawString();
            }
            case 4: 
            case 15: {
                return data.to_timestamp();
            }
            case 5: {
                return null;
            }
            case 7: 
            case 17: {
                return data.to_boolean();
            }
            case 6: 
            case 16: {
                return data.to_double();
            }
        }
        throw new IllegalArgumentException("bad column type " + type);
    }

    public static Object deserialize(byte[] data, int type) {
        switch (type) {
            case 3: 
            case 14: {
                return data;
            }
            case 2: 
            case 12: {
                return Bytes.toInt((byte[])data, (int)0);
            }
            case 1: 
            case 13: {
                return Bytes.toLong((byte[])data, (int)0);
            }
            case 0: 
            case 11: {
                return Bytes.to_rawstring((byte[])data);
            }
            case 4: 
            case 15: {
                return Bytes.toTimestamp((byte[])data, (int)0);
            }
            case 5: {
                return null;
            }
            case 7: 
            case 17: {
                return Bytes.toBoolean((byte[])data, (int)0);
            }
            case 6: 
            case 16: {
                return Bytes.toDouble((byte[])data, (int)0);
            }
        }
        throw new IllegalArgumentException("bad column type " + type);
    }

    public static int deserializeCompare(byte[] data, int type, Object cvalue) {
        switch (type) {
            case 3: {
                return SQLRecordPredicateFunctions.compare((Object)data, (Object)cvalue);
            }
            case 2: 
            case 12: {
                if (cvalue instanceof Integer) {
                    return Bytes.compareInt((byte[])data, (int)0, (int)((Integer)cvalue));
                }
                if (cvalue instanceof Long) {
                    return Bytes.compareInt((byte[])data, (int)0, (long)((Long)cvalue));
                }
                return SQLRecordPredicateFunctions.compare((Object)Bytes.toInt((byte[])data, (int)0), (Object)cvalue);
            }
            case 1: 
            case 13: {
                if (cvalue instanceof Integer) {
                    return Bytes.compareLong((byte[])data, (int)0, (int)((Integer)cvalue));
                }
                if (cvalue instanceof Long) {
                    return Bytes.compareLong((byte[])data, (int)0, (long)((Long)cvalue));
                }
                return SQLRecordPredicateFunctions.compare((Object)Bytes.toLong((byte[])data, (int)0), (Object)cvalue);
            }
            case 0: 
            case 11: {
                if (cvalue instanceof RawString) {
                    return RawString.compareRaw((byte[])data, (int)0, (int)data.length, (RawString)((RawString)cvalue));
                }
                if (cvalue instanceof String) {
                    return RawString.compareRaw((byte[])data, (int)0, (int)data.length, (String)((String)cvalue));
                }
                return SQLRecordPredicateFunctions.compare((Object)Bytes.to_rawstring((byte[])data), (Object)cvalue);
            }
            case 4: 
            case 15: {
                return SQLRecordPredicateFunctions.compare((Object)Bytes.toTimestamp((byte[])data, (int)0), (Object)cvalue);
            }
            case 5: {
                return SQLRecordPredicateFunctions.compareNullTo((Object)cvalue);
            }
            case 7: {
                return SQLRecordPredicateFunctions.compare((Object)Bytes.toBoolean((byte[])data, (int)0), (Object)cvalue);
            }
            case 6: {
                return SQLRecordPredicateFunctions.compare((Object)Bytes.toDouble((byte[])data, (int)0), (Object)cvalue);
            }
        }
        throw new IllegalArgumentException("bad column type " + type);
    }

    public static SQLRecordPredicateFunctions.CompareResult deserializeCompare(Bytes data, int type, Object cvalue) {
        switch (type) {
            case 3: {
                return SQLRecordPredicateFunctions.compareConsiderNull((Object)data.to_array(), (Object)cvalue);
            }
            case 2: 
            case 12: {
                int v = data.to_int();
                if (cvalue instanceof Integer) {
                    return SQLRecordPredicateFunctions.CompareResult.fromInt((int)Integer.compare(v, (Integer)cvalue));
                }
                if (cvalue instanceof Long) {
                    return SQLRecordPredicateFunctions.CompareResult.fromInt((int)Long.compare(v, (Long)cvalue));
                }
                return SQLRecordPredicateFunctions.compareConsiderNull((Object)v, (Object)cvalue);
            }
            case 1: 
            case 13: {
                long v = data.to_long();
                if (cvalue instanceof Integer) {
                    return SQLRecordPredicateFunctions.CompareResult.fromInt((int)Long.compare(v, ((Integer)cvalue).intValue()));
                }
                if (cvalue instanceof Long) {
                    return SQLRecordPredicateFunctions.CompareResult.fromInt((int)Long.compare(v, (Long)cvalue));
                }
                return SQLRecordPredicateFunctions.compareConsiderNull((Object)v, (Object)cvalue);
            }
            case 0: 
            case 11: {
                RawString string = data.to_RawString();
                if (cvalue instanceof RawString) {
                    return SQLRecordPredicateFunctions.CompareResult.fromInt((int)string.compareTo((RawString)cvalue));
                }
                if (cvalue instanceof String) {
                    return SQLRecordPredicateFunctions.CompareResult.fromInt((int)string.compareToString((String)cvalue));
                }
                return SQLRecordPredicateFunctions.compareConsiderNull((Object)string, (Object)cvalue);
            }
            case 4: {
                return SQLRecordPredicateFunctions.compareConsiderNull((Object)data.to_timestamp(), (Object)cvalue);
            }
            case 5: {
                return SQLRecordPredicateFunctions.CompareResult.NULL;
            }
            case 7: {
                return SQLRecordPredicateFunctions.compareConsiderNull((Object)data.to_boolean(), (Object)cvalue);
            }
            case 6: {
                return SQLRecordPredicateFunctions.compareConsiderNull((Object)data.to_double(), (Object)cvalue);
            }
        }
        throw new IllegalArgumentException("bad column type " + type);
    }

    public static Object deserializeTypeAndValue(ByteArrayCursor dii) throws IOException {
        int type = dii.readVInt();
        switch (type) {
            case 3: 
            case 14: {
                return dii.readArray();
            }
            case 2: 
            case 12: {
                return dii.readInt();
            }
            case 1: 
            case 13: {
                return dii.readLong();
            }
            case 0: 
            case 11: {
                return dii.readRawStringNoCopy();
            }
            case 4: 
            case 15: {
                return new Timestamp(dii.readLong());
            }
            case 5: {
                return null;
            }
            case 7: 
            case 17: {
                return dii.readBoolean();
            }
            case 6: 
            case 16: {
                return dii.readDouble();
            }
        }
        throw new IllegalArgumentException("bad column type " + type);
    }

    public static SQLRecordPredicateFunctions.CompareResult compareDeserializeTypeAndValue(ByteArrayCursor dii, Object cvalue) throws IOException {
        int type = dii.readVInt();
        switch (type) {
            case 3: 
            case 14: {
                byte[] datum = dii.readArray();
                return SQLRecordPredicateFunctions.compareConsiderNull((Object)datum, (Object)cvalue);
            }
            case 2: 
            case 12: {
                return SQLRecordPredicateFunctions.compareConsiderNull((Object)dii.readInt(), (Object)cvalue);
            }
            case 1: 
            case 13: {
                return SQLRecordPredicateFunctions.compareConsiderNull((Object)dii.readLong(), (Object)cvalue);
            }
            case 0: 
            case 11: {
                int len = dii.readArrayLen();
                if (cvalue instanceof RawString) {
                    RawString _cvalue = (RawString)cvalue;
                    return SQLRecordPredicateFunctions.CompareResult.fromInt((int)RawString.compareRaw((byte[])dii.getArray(), (int)dii.getPosition(), (int)len, (RawString)_cvalue));
                }
                if (cvalue instanceof String) {
                    String _cvalue = (String)cvalue;
                    return SQLRecordPredicateFunctions.CompareResult.fromInt((int)RawString.compareRaw((byte[])dii.getArray(), (int)dii.getPosition(), (int)len, (String)_cvalue));
                }
                RawString value = dii.readRawStringNoCopy();
                return SQLRecordPredicateFunctions.CompareResult.fromInt((int)SQLRecordPredicateFunctions.compare((Object)value, (Object)cvalue));
            }
            case 4: 
            case 15: {
                return SQLRecordPredicateFunctions.CompareResult.fromInt((int)SQLRecordPredicateFunctions.compare((Object)new Timestamp(dii.readLong()), (Object)cvalue));
            }
            case 5: {
                return SQLRecordPredicateFunctions.CompareResult.NULL;
            }
            case 7: 
            case 17: {
                return SQLRecordPredicateFunctions.CompareResult.fromInt((int)SQLRecordPredicateFunctions.compare((Object)dii.readBoolean(), (Object)cvalue));
            }
            case 6: 
            case 16: {
                return SQLRecordPredicateFunctions.CompareResult.fromInt((int)SQLRecordPredicateFunctions.compare((Object)dii.readDouble(), (Object)cvalue));
            }
        }
        throw new IllegalArgumentException("bad column type " + type);
    }

    public static void skipTypeAndValue(ByteArrayCursor dii) throws IOException {
        int type = dii.readVInt();
        switch (type) {
            case 3: 
            case 14: {
                dii.skipArray();
                break;
            }
            case 2: 
            case 12: {
                dii.skipInt();
                break;
            }
            case 1: 
            case 13: {
                dii.skipLong();
                break;
            }
            case 0: 
            case 11: {
                dii.skipArray();
                break;
            }
            case 4: 
            case 15: {
                dii.skipLong();
                break;
            }
            case 5: {
                break;
            }
            case 7: 
            case 17: {
                dii.skipBoolean();
                break;
            }
            case 6: 
            case 16: {
                dii.skipDouble();
                break;
            }
            default: {
                throw new IllegalArgumentException("bad column type " + type);
            }
        }
    }

    public static byte[] serialize(Object v, int type) {
        if (v == null) {
            return null;
        }
        switch (type) {
            case 3: 
            case 14: {
                return (byte[])v;
            }
            case 2: 
            case 12: {
                if (v instanceof Integer) {
                    return Bytes.intToByteArray((int)((Integer)v));
                }
                if (v instanceof Number) {
                    return Bytes.intToByteArray((int)((Number)v).intValue());
                }
                return Bytes.intToByteArray((int)Integer.parseInt(v.toString()));
            }
            case 1: 
            case 13: {
                if (v instanceof Long) {
                    return Bytes.longToByteArray((long)((Long)v));
                }
                if (v instanceof Number) {
                    return Bytes.longToByteArray((long)((Number)v).longValue());
                }
                return Bytes.longToByteArray((long)Long.parseLong(v.toString()));
            }
            case 0: 
            case 11: {
                if (v instanceof RawString) {
                    RawString rs = (RawString)v;
                    return rs.toByteArray();
                }
                return Bytes.string_to_array((String)v.toString());
            }
            case 7: 
            case 17: {
                if (v instanceof Boolean) {
                    return Bytes.booleanToByteArray((boolean)((Boolean)v));
                }
                return Bytes.booleanToByteArray((boolean)Boolean.parseBoolean(v.toString()));
            }
            case 6: 
            case 16: {
                if (v instanceof Double) {
                    return Bytes.doubleToByteArray((double)((Double)v));
                }
                if (v instanceof Long) {
                    return Bytes.doubleToByteArray((double)((Long)v).longValue());
                }
                if (v instanceof Number) {
                    return Bytes.doubleToByteArray((double)((Number)v).longValue());
                }
                return Bytes.doubleToByteArray((double)Double.parseDouble(v.toString()));
            }
            case 4: 
            case 15: {
                if (v instanceof Long) {
                    return Bytes.timestampToByteArray((Timestamp)new Timestamp((Long)v));
                }
                if (!(v instanceof Timestamp)) {
                    throw new IllegalArgumentException("bad value type for column " + type + ": required java.sql.Timestamp, but was " + v.getClass() + ", toString of value is " + v);
                }
                return Bytes.timestampToByteArray((Timestamp)((Timestamp)v));
            }
        }
        throw new IllegalArgumentException("bad column type " + type);
    }

    public static void serializeTo(Object v, int type, ExtendedDataOutputStream out) throws IOException {
        if (v == null) {
            out.writeNullArray();
            return;
        }
        switch (type) {
            case 3: 
            case 14: {
                out.writeArray((byte[])v);
                return;
            }
            case 2: 
            case 12: {
                if (v instanceof Integer) {
                    out.writeArray(Bytes.intToByteArray((int)((Integer)v)));
                } else if (v instanceof Number) {
                    out.writeArray(Bytes.intToByteArray((int)((Number)v).intValue()));
                } else {
                    out.writeArray(Bytes.intToByteArray((int)Integer.parseInt(v.toString())));
                }
                return;
            }
            case 1: 
            case 13: {
                if (v instanceof Long) {
                    out.writeArray(Bytes.longToByteArray((long)((Long)v)));
                } else if (v instanceof Number) {
                    out.writeArray(Bytes.longToByteArray((long)((Number)v).longValue()));
                } else {
                    out.writeArray(Bytes.longToByteArray((long)Long.parseLong(v.toString())));
                }
                return;
            }
            case 0: 
            case 11: {
                if (v instanceof RawString) {
                    RawString rs = (RawString)v;
                    out.writeArray(rs.getData(), rs.getOffset(), rs.getLength());
                } else {
                    out.writeArray(Bytes.string_to_array((String)v.toString()));
                }
                return;
            }
            case 7: 
            case 17: {
                if (v instanceof Boolean) {
                    out.writeArray(Bytes.booleanToByteArray((boolean)((Boolean)v)));
                } else {
                    out.writeArray(Bytes.booleanToByteArray((boolean)Boolean.parseBoolean(v.toString())));
                }
                return;
            }
            case 6: 
            case 16: {
                if (v instanceof Double) {
                    out.writeArray(Bytes.doubleToByteArray((double)((Double)v)));
                } else if (v instanceof Long) {
                    out.writeArray(Bytes.doubleToByteArray((double)((Long)v).longValue()));
                } else if (v instanceof Number) {
                    out.writeArray(Bytes.doubleToByteArray((double)((Number)v).longValue()));
                } else {
                    out.writeArray(Bytes.doubleToByteArray((double)Double.parseDouble(v.toString())));
                }
                return;
            }
            case 4: 
            case 15: {
                if (v instanceof Long) {
                    out.writeArray(Bytes.timestampToByteArray((Timestamp)new Timestamp((Long)v)));
                    return;
                }
                if (!(v instanceof Timestamp)) {
                    if (v instanceof String) {
                        v = (Timestamp)RecordSerializer.convert(type, v.toString());
                    } else {
                        throw new IllegalArgumentException("bad value type for column " + type + ": required java.sql.Timestamp, but was " + v.getClass() + ", toString of value is " + v);
                    }
                }
                out.writeArray(Bytes.timestampToByteArray((Timestamp)((Timestamp)v)));
                return;
            }
        }
        throw new IllegalArgumentException("bad column type " + type);
    }

    public static void validate(Object v, int type) {
        if (v == null) {
            return;
        }
        switch (type) {
            case 3: 
            case 14: {
                if (!(v instanceof byte[])) {
                    throw new IllegalArgumentException();
                }
                return;
            }
            case 2: 
            case 12: {
                if (v instanceof Number) {
                    return;
                }
                Integer.parseInt(v.toString());
                return;
            }
            case 1: 
            case 13: {
                if (v instanceof Number) {
                    return;
                }
                Long.parseLong(v.toString());
                return;
            }
            case 0: 
            case 11: {
                return;
            }
            case 7: 
            case 17: {
                return;
            }
            case 6: 
            case 16: {
                if (v instanceof Number) {
                    return;
                }
                Double.parseDouble(v.toString());
                return;
            }
            case 4: 
            case 15: {
                if (v instanceof Long || v instanceof Timestamp) {
                    return;
                }
                throw new IllegalArgumentException("bad value type for column " + type + ": required java.sql.Timestamp, but was " + v.getClass() + ", toString of value is " + v);
            }
        }
        throw new IllegalArgumentException("bad column type " + type);
    }

    public static void serializeTypeAndValue(Object v, int type, ExtendedDataOutputStream oo) throws IOException {
        if (v == null) {
            return;
        }
        oo.writeVInt(type);
        RecordSerializer.serializeValue(v, type, oo);
    }

    public static void serializeValue(Object v, int type, ExtendedDataOutputStream oo) throws IOException {
        if (v == null) {
            throw new IOException("You cannot serialize a null value");
        }
        switch (type) {
            case 3: 
            case 14: {
                oo.writeArray((byte[])v);
                break;
            }
            case 2: 
            case 12: {
                if (v instanceof Integer) {
                    oo.writeInt(((Integer)v).intValue());
                    break;
                }
                if (v instanceof Number) {
                    oo.writeInt(((Number)v).intValue());
                    break;
                }
                oo.writeInt(Integer.parseInt(v.toString()));
                break;
            }
            case 1: 
            case 13: {
                if (v instanceof Integer) {
                    oo.writeLong((long)((Integer)v).intValue());
                    break;
                }
                if (v instanceof Number) {
                    oo.writeLong(((Number)v).longValue());
                    break;
                }
                oo.writeLong(Long.parseLong(v.toString()));
                break;
            }
            case 0: 
            case 11: {
                if (v instanceof RawString) {
                    RawString rs = (RawString)v;
                    oo.writeArray(rs.getData(), rs.getOffset(), rs.getLength());
                    break;
                }
                oo.writeArray(Bytes.string_to_array((String)v.toString()));
                break;
            }
            case 4: 
            case 15: {
                if (v instanceof Long) {
                    v = new Timestamp((Long)v);
                }
                if (!(v instanceof Timestamp)) {
                    throw new IllegalArgumentException("bad value type for column " + type + ": required java.sql.Timestamp, but was " + v.getClass() + ", toString of value is " + v);
                }
                oo.writeLong(((Timestamp)v).getTime());
                break;
            }
            case 7: 
            case 17: {
                if (v instanceof Boolean) {
                    oo.writeBoolean(((Boolean)v).booleanValue());
                    break;
                }
                oo.writeBoolean(Boolean.parseBoolean(v.toString()));
                break;
            }
            case 6: 
            case 16: {
                if (v instanceof Integer) {
                    oo.writeDouble((double)((Integer)v).intValue());
                    break;
                }
                if (v instanceof Number) {
                    oo.writeDouble(((Number)v).doubleValue());
                    break;
                }
                oo.writeDouble(Double.parseDouble(v.toString()));
                break;
            }
            default: {
                throw new IllegalArgumentException("bad column type " + type);
            }
        }
    }

    public static DateTimeFormatter getUTCTimestampFormatter() {
        return TIMESTAMP_FORMATTER;
    }

    public static Object convert(int type, Object value) throws StatementExecutionException {
        if (value == null && ColumnTypes.isNotNullDataType(type)) {
            throw new StatementExecutionException("Cannot have null value in non-NULL type " + ColumnTypes.sqlDataType(type));
        }
        switch (type) {
            case 4: 
            case 15: {
                if (value instanceof Timestamp) {
                    return value;
                }
                if (value instanceof RawString || value instanceof String) {
                    try {
                        ZonedDateTime dateTime;
                        String asString = value.toString();
                        try {
                            dateTime = ZonedDateTime.parse(asString, TIMESTAMP_FORMATTER);
                        }
                        catch (DateTimeParseException tryAgain) {
                            try {
                                dateTime = ZonedDateTime.parse(asString, TIMESTAMP_FORMATTER_WITH_MILLIS);
                            }
                            catch (DateTimeParseException again) {
                                dateTime = LocalDate.parse(asString, TIMESTAMP_FORMATTER_ONLY_DATE).atStartOfDay(UTC);
                            }
                        }
                        Instant toInstant = dateTime.toInstant();
                        long millis = toInstant.toEpochMilli();
                        Timestamp timestamp = new Timestamp(millis);
                        if (timestamp.getTime() != millis) {
                            throw new StatementExecutionException("Unparsable timestamp " + value + " would been converted as java.sql.Timestamp to " + new Timestamp(millis));
                        }
                        return timestamp;
                    }
                    catch (DateTimeParseException err) {
                        throw new StatementExecutionException("Unparsable timestamp " + value, err);
                    }
                }
            }
            case 3: 
            case 14: {
                if (value instanceof RawString) {
                    return ((RawString)value).toByteArray();
                }
                return value;
            }
        }
        return value;
    }

    public static DataAccessor buildRawDataAccessor(Record record, Table table) {
        return new DataAccessorForFullRecord(table, record);
    }

    public static DataAccessor buildRawDataAccessorForPrimaryKey(Bytes key, Table table) {
        return new DataAccessorForPrimaryKey(table, key);
    }

    static Object accessRawDataFromValue(String property, Bytes value, Table table) throws IOException {
        if (table.getColumn(property) == null) {
            throw new IllegalDataAccessException("table " + table.tablespace + "." + table.name + " does not define column " + property);
        }
        try (ByteArrayCursor din = value.newCursor();){
            while (!din.isEof()) {
                int serialPosition = din.readVIntNoEOFException();
                if (din.isEof()) {
                    Object var5_7 = null;
                    return var5_7;
                }
                Column col = table.getColumnBySerialPosition(serialPosition);
                if (col != null && col.name.equals(property)) {
                    Object object = RecordSerializer.deserializeTypeAndValue(din);
                    return object;
                }
                RecordSerializer.skipTypeAndValue(din);
            }
            Object var4_5 = null;
            return var4_5;
        }
    }

    static Object accessRawDataFromValue(int index, Bytes value, Table table) throws IOException {
        Column column = table.getColumn(index);
        try (ByteArrayCursor din = value.newCursor();){
            while (!din.isEof()) {
                int serialPosition = din.readVIntNoEOFException();
                if (din.isEof()) {
                    Object var6_8 = null;
                    return var6_8;
                }
                Column col = table.getColumnBySerialPosition(serialPosition);
                if (col != null && col.serialPosition == column.serialPosition) {
                    Object object = RecordSerializer.deserializeTypeAndValue(din);
                    return object;
                }
                RecordSerializer.skipTypeAndValue(din);
            }
            Object var5_6 = null;
            return var5_6;
        }
    }

    static SQLRecordPredicateFunctions.CompareResult compareRawDataFromValue(int index, Bytes value, Table table, Object cvalue) throws IOException {
        Column column = table.getColumn(index);
        try (ByteArrayCursor din = value.newCursor();){
            while (!din.isEof()) {
                int serialPosition = din.readVIntNoEOFException();
                if (din.isEof()) {
                    SQLRecordPredicateFunctions.CompareResult compareResult = SQLRecordPredicateFunctions.CompareResult.NULL;
                    return compareResult;
                }
                Column col = table.getColumnBySerialPosition(serialPosition);
                if (col != null && col.serialPosition == column.serialPosition) {
                    SQLRecordPredicateFunctions.CompareResult compareResult = RecordSerializer.compareDeserializeTypeAndValue(din, cvalue);
                    return compareResult;
                }
                RecordSerializer.skipTypeAndValue(din);
            }
        }
        return SQLRecordPredicateFunctions.CompareResult.NULL;
    }

    static Object accessRawDataFromPrimaryKey(String property, Bytes key, Table table) throws IOException {
        if (table.primaryKey.length == 1) {
            return RecordSerializer.deserialize(key, table.getColumn((String)property).type);
        }
        try (ByteArrayCursor din = key.newCursor();){
            for (String primaryKeyColumn : table.primaryKey) {
                Bytes value = din.readBytesNoCopy();
                if (!primaryKeyColumn.equals(property)) continue;
                Object object = RecordSerializer.deserialize(value, table.getColumn((String)primaryKeyColumn).type);
                return object;
            }
        }
        throw new IOException("property " + property + " not found in PK: " + Arrays.toString(table.primaryKey));
    }

    static Object accessRawDataFromPrimaryKey(int index, Bytes key, Table table) throws IOException {
        Column column = table.getColumn(index);
        if (table.primaryKey.length == 1) {
            return RecordSerializer.deserialize(key, column.type);
        }
        String cname = column.name;
        try (ByteArrayCursor din = key.newCursor();){
            for (String primaryKeyColumn : table.primaryKey) {
                Bytes value = din.readBytesNoCopy();
                if (!primaryKeyColumn.equals(cname)) continue;
                Object object = RecordSerializer.deserialize(value, table.getColumn((String)primaryKeyColumn).type);
                return object;
            }
        }
        throw new IOException("position #" + index + " not found in PK: " + Arrays.toString(table.primaryKey));
    }

    static SQLRecordPredicateFunctions.CompareResult compareRawDataFromPrimaryKey(int index, Bytes key, Table table, Object cvalue) throws IOException {
        Column column = table.getColumn(index);
        if (table.primaryKey.length == 1) {
            return RecordSerializer.deserializeCompare(key, column.type, cvalue);
        }
        String cname = column.name;
        try (ByteArrayCursor din = key.newCursor();){
            for (String primaryKeyColumn : table.primaryKey) {
                Bytes value = din.readBytesNoCopy();
                if (!primaryKeyColumn.equals(cname)) continue;
                SQLRecordPredicateFunctions.CompareResult compareResult = RecordSerializer.deserializeCompare(value, table.getColumn((String)primaryKeyColumn).type, cvalue);
                return compareResult;
            }
        }
        throw new IOException("position #" + index + " not found in PK: " + Arrays.toString(table.primaryKey));
    }

    private RecordSerializer() {
    }

    public static Record makeRecord(Table table, Object ... values) {
        HashMap<String, Object> record = new HashMap<String, Object>();
        for (int i = 0; i < values.length; ++i) {
            Object name = values[i++];
            Object value = values[i];
            name = table.getColumn((String)((String)name)).name;
            if (value instanceof String) {
                value = RawString.of((String)((String)value));
            }
            record.put((String)name, value);
        }
        return RecordSerializer.toRecord(record, table);
    }

    public static Bytes serializePrimaryKey(Map<String, Object> record, ColumnsList table, String[] columns) {
        return Bytes.from_array((byte[])RecordSerializer.serializePrimaryKeyRaw(record, table, columns));
    }

    public static byte[] serializePrimaryKeyRaw(Map<String, Object> record, ColumnsList table, String[] columns) {
        String[] primaryKey = table.getPrimaryKey();
        if (primaryKey.length == 1) {
            String pkColumn = primaryKey[0];
            if (columns.length != 1 && !columns[0].equals(pkColumn)) {
                throw new IllegalArgumentException("SQLTranslator error, " + Arrays.toString(columns) + " != " + Arrays.asList(pkColumn));
            }
            Column c = table.getColumn(pkColumn);
            Object v = record.get(c.name);
            if (v == null) {
                throw new IllegalArgumentException("key field " + pkColumn + " cannot be null. Record data: " + record);
            }
            return RecordSerializer.serialize(v, c.type);
        }
        VisibleByteArrayOutputStream key = new VisibleByteArrayOutputStream(columns.length * 8);
        try (ExtendedDataOutputStream doo_key = new ExtendedDataOutputStream((OutputStream)key);){
            int i = 0;
            for (String pkColumn : columns) {
                if (!pkColumn.equals(primaryKey[i])) {
                    throw new IllegalArgumentException("SQLTranslator error, " + Arrays.toString(columns) + " != " + Arrays.asList(primaryKey));
                }
                Column c = table.getColumn(pkColumn);
                Object v = record.get(c.name);
                if (v == null) {
                    throw new IllegalArgumentException("key field " + pkColumn + " cannot be null. Record data: " + record);
                }
                RecordSerializer.serializeTo(v, c.type, doo_key);
                ++i;
            }
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
        return key.toByteArrayNoCopy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bytes serializeIndexKey(DataAccessor record, ColumnsList index, String[] columns) {
        String[] indexedColumnsList = index.getPrimaryKey();
        if (indexedColumnsList.length == 1) {
            String pkColumn = indexedColumnsList[0];
            if (columns.length != 1 && !columns[0].equals(pkColumn)) {
                throw new IllegalArgumentException("SQLTranslator error, " + Arrays.toString(columns) + " != " + Arrays.asList(pkColumn));
            }
            Column c = index.getColumn(pkColumn);
            Object v = record.get(c.name);
            if (v == null) {
                if (!index.allowNullsForIndexedValues()) throw new IllegalArgumentException("key field " + pkColumn + " cannot be null. Record data: " + record);
                return null;
            }
            byte[] fieldValue = RecordSerializer.serialize(v, c.type);
            return Bytes.from_array((byte[])fieldValue);
        }
        VisibleByteArrayOutputStream key = new VisibleByteArrayOutputStream(columns.length * 8);
        try (ExtendedDataOutputStream doo_key = new ExtendedDataOutputStream((OutputStream)key);){
            int i = 0;
            String[] stringArray = columns;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String indexedColumn = stringArray[n2];
                if (!indexedColumn.equals(indexedColumnsList[i])) {
                    throw new IllegalArgumentException("SQLTranslator error, " + Arrays.toString(columns) + " != " + Arrays.asList(indexedColumnsList));
                }
                Column c = index.getColumn(indexedColumn);
                Object v = record.get(c.name);
                if (v == null) {
                    if (!index.allowNullsForIndexedValues()) {
                        throw new IllegalArgumentException("key field " + indexedColumn + " cannot be null. Record data: " + record);
                    }
                    if (i == 0) {
                        Bytes bytes = null;
                        return bytes;
                    }
                    Bytes bytes = Bytes.from_array((byte[])key.getBuffer(), (int)0, (int)key.size());
                    return bytes;
                }
                RecordSerializer.serializeTo(v, c.type, doo_key);
                ++i;
                ++n2;
            }
            return Bytes.from_array((byte[])key.getBuffer(), (int)0, (int)key.size());
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    public static void validateIndexableValue(DataAccessor record, ColumnsList indexDefinition, String[] columns) {
        String[] columnListForIndex = indexDefinition.getPrimaryKey();
        if (columnListForIndex.length == 1) {
            String pkColumn = columnListForIndex[0];
            if (columns.length != 1 && !columns[0].equals(pkColumn)) {
                throw new IllegalArgumentException("SQLTranslator error, " + Arrays.toString(columns) + " != " + Arrays.asList(pkColumn));
            }
            Column c = indexDefinition.getColumn(pkColumn);
            Object v = record.get(c.name);
            if (v == null && !indexDefinition.allowNullsForIndexedValues()) {
                throw new IllegalArgumentException("key field " + pkColumn + " cannot be null. Record data: " + record);
            }
            RecordSerializer.validate(v, c.type);
        } else {
            int i = 0;
            for (String pkColumn : columns) {
                if (!pkColumn.equals(columnListForIndex[i])) {
                    throw new IllegalArgumentException("SQLTranslator error, " + Arrays.toString(columns) + " != " + Arrays.asList(columnListForIndex));
                }
                Column c = indexDefinition.getColumn(pkColumn);
                Object v = record.get(c.name);
                if (v == null && !indexDefinition.allowNullsForIndexedValues()) {
                    throw new IllegalArgumentException("key field " + pkColumn + " cannot be null. Record data: " + record);
                }
                RecordSerializer.validate(v, c.type);
                ++i;
            }
        }
    }

    public static Object deserializePrimaryKey(Bytes key, Table table) {
        if (table.primaryKey.length == 1) {
            return RecordSerializer.deserializeSingleColumnPrimaryKey(key, table);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        RecordSerializer.deserializeMultiColumnPrimaryKey(key, table, result);
        return result;
    }

    public static Map<String, Object> deserializePrimaryKeyAsMap(Bytes key, Table table) {
        SingleEntryMap result;
        if (key.deserialized != null) {
            return (Map)key.deserialized;
        }
        if (table.primaryKey.length == 1) {
            Object value = RecordSerializer.deserializeSingleColumnPrimaryKey(key, table);
            result = new SingleEntryMap((Object)table.primaryKey[0], value);
        } else {
            result = new HashMap();
            RecordSerializer.deserializeMultiColumnPrimaryKey(key, table, result);
        }
        key.deserialized = result;
        return result;
    }

    public static Bytes serializeValue(Map<String, Object> record, Table table) {
        return Bytes.from_array((byte[])RecordSerializer.serializeValueRaw(record, table, 0));
    }

    public static byte[] serializeValueRaw(Map<String, Object> record, Table table, int expectedSize) {
        VisibleByteArrayOutputStream value = new VisibleByteArrayOutputStream(expectedSize <= 0 ? INITIAL_BUFFER_SIZE : expectedSize);
        try (ExtendedDataOutputStream doo = new ExtendedDataOutputStream((OutputStream)value);){
            for (Column c : table.columns) {
                Object v = record.get(c.name);
                if (v == null || table.isPrimaryKeyColumn(c.name)) continue;
                doo.writeVInt(c.serialPosition);
                RecordSerializer.serializeTypeAndValue(v, c.type, doo);
            }
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
        return value.toByteArrayNoCopy();
    }

    public static byte[] buildRecord(int expectedSize, Table table, Function<String, Object> evaluator) {
        VisibleByteArrayOutputStream value = new VisibleByteArrayOutputStream(expectedSize <= 0 ? INITIAL_BUFFER_SIZE : expectedSize);
        try (ExtendedDataOutputStream doo = new ExtendedDataOutputStream((OutputStream)value);){
            for (Column c : table.columns) {
                Object v;
                if (table.isPrimaryKeyColumn(c.name) || (v = evaluator.apply(c.name)) == null) continue;
                doo.writeVInt(c.serialPosition);
                RecordSerializer.serializeTypeAndValue(v, c.type, doo);
            }
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
        return value.toByteArrayNoCopy();
    }

    public static Record toRecord(Map<String, Object> record, Table table) {
        return new Record(RecordSerializer.serializePrimaryKey(record, table, table.primaryKey), RecordSerializer.serializeValue(record, table), record);
    }

    private static Object deserializeSingleColumnPrimaryKey(Bytes data, Table table) {
        String primaryKeyColumn = table.primaryKey[0];
        return RecordSerializer.deserialize(data, table.getColumn((String)primaryKeyColumn).type);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public static Map<String, Object> toBean(Record record, Table table) {
        try {
            ImmutableMap.Builder res = new ImmutableMap.Builder();
            if (table.primaryKey.length == 1) {
                Object key = RecordSerializer.deserializeSingleColumnPrimaryKey(record.key, table);
                res.put((Object)table.primaryKey[0], key);
            } else {
                RecordSerializer.deserializeMultiColumnPrimaryKey(record.key, table, (ImmutableMap.Builder<String, Object>)res);
            }
            if (record.value != null && record.value.getLength() > 0) {
                try (ByteArrayCursor din = record.value.newCursor();){
                    while (true) {
                        int serialPosition = din.readVIntNoEOFException();
                        if (din.isEof()) {
                            break;
                        }
                        Column col = table.getColumnBySerialPosition(serialPosition);
                        if (col != null) {
                            Object v = RecordSerializer.deserializeTypeAndValue(din);
                            res.put((Object)col.name, v);
                            continue;
                        }
                        RecordSerializer.skipTypeAndValue(din);
                    }
                }
            }
            return res.build();
        }
        catch (IOException err) {
            throw new IllegalArgumentException("malformed record", err);
        }
    }

    private static void deserializeMultiColumnPrimaryKey(Bytes data, Table table, Map<String, Object> res) {
        try (ByteArrayCursor din = data.newCursor();){
            for (String primaryKeyColumn : table.primaryKey) {
                Bytes value = din.readBytesNoCopy();
                res.put(primaryKeyColumn, RecordSerializer.deserialize(value, table.getColumn((String)primaryKeyColumn).type));
            }
        }
        catch (IOException err) {
            throw new IllegalArgumentException("malformed record", err);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    private static void deserializeMultiColumnPrimaryKey(Bytes data, Table table, ImmutableMap.Builder<String, Object> res) {
        try (ByteArrayCursor din = data.newCursor();){
            for (String primaryKeyColumn : table.primaryKey) {
                Bytes value = din.readBytesNoCopy();
                res.put((Object)primaryKeyColumn, RecordSerializer.deserialize(value, table.getColumn((String)primaryKeyColumn).type));
            }
        }
        catch (IOException err) {
            throw new IllegalArgumentException("malformed record", err);
        }
    }

    private static class DataAccessorForPrimaryKey
    extends AbstractDataAccessor {
        private final Table table;
        private final Bytes key;

        public DataAccessorForPrimaryKey(Table table, Bytes key) {
            this.table = table;
            this.key = key;
        }

        public Object get(String property) {
            try {
                if (this.table.isPrimaryKeyColumn(property)) {
                    return RecordSerializer.accessRawDataFromPrimaryKey(property, this.key, this.table);
                }
                return null;
            }
            catch (IOException err) {
                throw new IllegalStateException("bad data:" + err, err);
            }
        }

        public void forEach(BiConsumer<String, Object> consumer) {
            if (this.table.primaryKey.length == 1) {
                String pkField = this.table.primaryKey[0];
                Object value = RecordSerializer.deserialize(this.key, this.table.getColumn((String)pkField).type);
                consumer.accept(pkField, value);
            } else {
                try (ByteArrayCursor din = this.key.newCursor();){
                    for (String primaryKeyColumn : this.table.primaryKey) {
                        Bytes value = din.readBytesNoCopy();
                        Object theValue = RecordSerializer.deserialize(value, this.table.getColumn((String)primaryKeyColumn).type);
                        consumer.accept(primaryKeyColumn, theValue);
                    }
                }
                catch (IOException err) {
                    throw new IllegalStateException("bad data:" + err, err);
                }
            }
        }

        public String[] getFieldNames() {
            return this.table.primaryKey;
        }

        public Map<String, Object> toMap() {
            return RecordSerializer.deserializePrimaryKeyAsMap(this.key, this.table);
        }
    }
}

