/*
 * Decompiled with CFR 0.152.
 */
package herddb.cluster;

import io.netty.util.HashedWheelTimer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.bookkeeper.proto.LocalBookiesRegistry;
import org.apache.bookkeeper.stats.StatsLogger;

public class PreferLocalBookiePlacementPolicy
implements EnsemblePlacementPolicy {
    private Set<BookieId> knownBookies = new HashSet<BookieId>();

    public EnsemblePlacementPolicy initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer hashedWheelTimer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        return this;
    }

    public void uninitalize() {
    }

    public synchronized Set<BookieId> onClusterChanged(Set<BookieId> writableBookies, Set<BookieId> readOnlyBookies) {
        HashSet<BookieId> deadBookies = new HashSet<BookieId>(this.knownBookies);
        deadBookies.removeAll(writableBookies);
        deadBookies.removeAll(readOnlyBookies);
        this.knownBookies = writableBookies;
        return deadBookies;
    }

    public EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieId> currentEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        excludeBookies.addAll(currentEnsemble);
        EnsemblePlacementPolicy.PlacementResult<List<BookieId>> list = this.newEnsemble(1, 1, 1, customMetadata, excludeBookies);
        return EnsemblePlacementPolicy.PlacementResult.of((Object)((BookieId)((List)list.getResult()).get(0)), (EnsemblePlacementPolicy.PlacementPolicyAdherence)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT);
    }

    public DistributionSchedule.WriteSet reorderReadSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return writeSet;
    }

    public DistributionSchedule.WriteSet reorderReadLACSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return writeSet;
    }

    public void registerSlowBookie(BookieId bookieSocketAddress, long entryId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        ArrayList<BookieId> allBookies;
        ArrayList<BookieId> newBookies = new ArrayList<BookieId>(ensembleSize);
        if (ensembleSize <= 0) {
            return EnsemblePlacementPolicy.PlacementResult.of(newBookies, (EnsemblePlacementPolicy.PlacementPolicyAdherence)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT);
        }
        PreferLocalBookiePlacementPolicy preferLocalBookiePlacementPolicy = this;
        synchronized (preferLocalBookiePlacementPolicy) {
            allBookies = new ArrayList<BookieId>(this.knownBookies);
        }
        BookieId localBookie = null;
        for (BookieId bookie : allBookies) {
            if (excludeBookies.contains(bookie) || !LocalBookiesRegistry.isLocalBookie((BookieId)bookie)) continue;
            localBookie = bookie;
            break;
        }
        if (localBookie != null) {
            boolean ret = allBookies.remove(localBookie);
            if (!ret) {
                throw new RuntimeException("localBookie not found in list");
            }
            newBookies.add(localBookie);
            if (--ensembleSize == 0) {
                return EnsemblePlacementPolicy.PlacementResult.of(newBookies, (EnsemblePlacementPolicy.PlacementPolicyAdherence)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT);
            }
        }
        Collections.shuffle(allBookies);
        for (BookieId bookie : allBookies) {
            if (excludeBookies.contains(bookie)) continue;
            newBookies.add(bookie);
            if (--ensembleSize != 0) continue;
            return EnsemblePlacementPolicy.PlacementResult.of(newBookies, (EnsemblePlacementPolicy.PlacementPolicyAdherence)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT);
        }
        throw new BKException.BKNotEnoughBookiesException();
    }

    public EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy(List<BookieId> ensembleList, int writeQuorumSize, int ackQuorumSize) {
        return EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT;
    }
}

