/*
 * Decompiled with CFR 0.152.
 */
package herddb.cluster;

import herddb.cluster.BookkeeperCommitLog;
import herddb.cluster.PreferLocalBookiePlacementPolicy;
import herddb.cluster.ZookeeperMetadataStorageManager;
import herddb.log.CommitLogManager;
import herddb.log.LogEntry;
import herddb.log.LogNotAvailableException;
import herddb.log.LogSequenceNumber;
import herddb.server.ServerConfiguration;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;

public class BookkeeperCommitLogManager
extends CommitLogManager {
    private final ZookeeperMetadataStorageManager metadataStorageManager;
    private int ensemble = 1;
    private int writeQuorumSize = 1;
    private int ackQuorumSize = 1;
    private BookKeeper bookKeeper;
    private ScheduledExecutorService forceLastAddConfirmedTimer;
    private final StatsLogger statsLogger;
    private final ClientConfiguration config;
    private long ledgersRetentionPeriod = 86400000L;
    private long maxLedgerSizeBytes = 0L;
    private long maxIdleTime = 0L;
    private long bookkeeperClusterReadyWaitTime = 60000L;
    private ConcurrentHashMap<String, BookkeeperCommitLog> activeLogs = new ConcurrentHashMap();
    private static final Logger LOG = Logger.getLogger(BookkeeperCommitLogManager.class.getName());

    public BookkeeperCommitLogManager(ZookeeperMetadataStorageManager metadataStorageManager, ServerConfiguration serverConfiguration, StatsLogger statsLogger) {
        this.statsLogger = statsLogger;
        this.bookkeeperClusterReadyWaitTime = serverConfiguration.getLong("server.bookkeeper.wait.cluser.ready.timeout", 120000L);
        this.config = new ClientConfiguration();
        this.config.setThrottleValue(0);
        this.config.setZkServers(metadataStorageManager.getZkAddress());
        this.config.setZkTimeout(metadataStorageManager.getZkSessionTimeout());
        this.config.setZkLedgersRootPath(serverConfiguration.getString("server.bookkeeper.ledgers.path", "/ledgers"));
        this.config.setEnableParallelRecoveryRead(true);
        this.config.setEnableDigestTypeAutodetection(true);
        for (String key : serverConfiguration.keys()) {
            if (!key.startsWith("bookkeeper.")) continue;
            String _key = key.substring("bookkeeper.".length());
            String value = serverConfiguration.getString(key, null);
            LOG.log(Level.CONFIG, "Setting BookKeeper client configuration: {0}={1}", new Object[]{_key, value});
            this.config.setProperty(_key, (Object)value);
        }
        LOG.log(Level.CONFIG, "Processing server config {0}", serverConfiguration);
        if (serverConfiguration.getBoolean("bookie.preferlocalbookie", false)) {
            this.config.setEnsemblePlacementPolicy(PreferLocalBookiePlacementPolicy.class);
        }
        LOG.config("BookKeeper client configuration:");
        Iterator e = this.config.getKeys();
        while (e.hasNext()) {
            String key;
            key = e.next();
            LOG.log(Level.CONFIG, "{0}={1}", new Object[]{key, this.config.getProperty(key + "")});
        }
        this.metadataStorageManager = metadataStorageManager;
        this.forceLastAddConfirmedTimer = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "force-lac-thread");
                t.setDaemon(true);
                return t;
            }
        });
    }

    public BookKeeper getBookKeeper() {
        return this.bookKeeper;
    }

    private void forceLastAddConfirmed() {
        this.activeLogs.values().forEach(l -> l.forceLastAddConfirmed());
    }

    @Override
    public void start() throws LogNotAvailableException {
        try {
            this.bookKeeper = BookKeeper.forConfig((ClientConfiguration)this.config).statsLogger(this.statsLogger).build();
            if (this.maxIdleTime > 0L) {
                this.forceLastAddConfirmedTimer.scheduleWithFixedDelay(() -> this.forceLastAddConfirmed(), this.maxIdleTime, this.maxIdleTime, TimeUnit.MILLISECONDS);
            }
        }
        catch (IOException | InterruptedException | BKException t) {
            this.close();
            throw new LogNotAvailableException(t);
        }
    }

    @Override
    public void close() {
        if (this.forceLastAddConfirmedTimer != null) {
            try {
                this.forceLastAddConfirmedTimer.shutdown();
            }
            finally {
                this.forceLastAddConfirmedTimer = null;
            }
        }
        if (this.bookKeeper != null) {
            try {
                this.bookKeeper.close();
            }
            catch (InterruptedException | BKException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    public int getEnsemble() {
        return this.ensemble;
    }

    public void setEnsemble(int ensemble) {
        this.ensemble = ensemble;
    }

    public int getWriteQuorumSize() {
        return this.writeQuorumSize;
    }

    public void setWriteQuorumSize(int writeQuorumSize) {
        this.writeQuorumSize = writeQuorumSize;
    }

    public int getAckQuorumSize() {
        return this.ackQuorumSize;
    }

    public void setAckQuorumSize(int ackQuorumSize) {
        this.ackQuorumSize = ackQuorumSize;
    }

    public long getLedgersRetentionPeriod() {
        return this.ledgersRetentionPeriod;
    }

    public void setLedgersRetentionPeriod(long ledgersRetentionPeriod) {
        this.ledgersRetentionPeriod = ledgersRetentionPeriod;
    }

    public long getMaxLedgerSizeBytes() {
        return this.maxLedgerSizeBytes;
    }

    public void setMaxLedgerSizeBytes(long maxLedgerSizeBytes) {
        this.maxLedgerSizeBytes = maxLedgerSizeBytes;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public long getBookkeeperClusterReadyWaitTime() {
        return this.bookkeeperClusterReadyWaitTime;
    }

    public void setBookkeeperClusterReadyWaitTime(long bookkeeperClusterReadyWaitTime) {
        this.bookkeeperClusterReadyWaitTime = bookkeeperClusterReadyWaitTime;
    }

    @Override
    public BookkeeperCommitLog createCommitLog(String tableSpaceUUID, String tableSpaceName, String localNodeId) throws LogNotAvailableException {
        BookkeeperCommitLog res = new BookkeeperCommitLog(tableSpaceUUID, tableSpaceName, localNodeId, this.metadataStorageManager, this.bookKeeper, this);
        res.setAckQuorumSize(this.ackQuorumSize);
        res.setEnsemble(this.ensemble);
        res.setMaxLedgerSizeBytes(this.maxLedgerSizeBytes);
        res.setLedgersRetentionPeriod(this.ledgersRetentionPeriod);
        res.setMaxIdleTime(this.maxIdleTime);
        res.setWriteQuorumSize(this.writeQuorumSize);
        this.activeLogs.put(tableSpaceUUID, res);
        return res;
    }

    void releaseLog(String tableSpaceUUID) {
        this.activeLogs.remove(tableSpaceUUID);
    }

    public static void scanRawLedger(long ledgerId, long fromId, long toId, herddb.client.ClientConfiguration clientConfiguration, ZookeeperMetadataStorageManager metadataStorageManager, Consumer<LogEntryWithSequenceNumber> consumer) throws Exception {
        ClientConfiguration config = new ClientConfiguration();
        config.setZkServers(metadataStorageManager.getZkAddress());
        config.setZkTimeout(metadataStorageManager.getZkSessionTimeout());
        config.setZkLedgersRootPath(clientConfiguration.getString("server.bookkeeper.ledgers.path", "/ledgers"));
        config.setEnableParallelRecoveryRead(true);
        config.setEnableDigestTypeAutodetection(true);
        try (org.apache.bookkeeper.client.api.BookKeeper bookKeeper = org.apache.bookkeeper.client.api.BookKeeper.newBuilder((ClientConfiguration)config).build();
             ReadHandle lh = (ReadHandle)bookKeeper.newOpenLedgerOp().withRecovery(false).withLedgerId(ledgerId).withPassword("herddb".getBytes(StandardCharsets.UTF_8)).execute().get();){
            long lastAddConfirmed = lh.readLastAddConfirmed();
            if (toId < 0L) {
                toId = lastAddConfirmed;
            }
            LOG.log(Level.INFO, "Scanning Ledger {0} from {1} to {2} LAC {3}", new Object[]{ledgerId, fromId, toId, lastAddConfirmed});
            for (long id = fromId; id <= toId; ++id) {
                try (LedgerEntries entries = lh.readUnconfirmed(id, id);){
                    LedgerEntry entry = entries.getEntry(id);
                    LogEntry lEntry = LogEntry.deserialize(entry.getEntryBytes());
                    LogEntryWithSequenceNumber e = new LogEntryWithSequenceNumber(new LogSequenceNumber(ledgerId, id), lEntry);
                    consumer.accept(e);
                    continue;
                }
            }
        }
    }

    public static final class LogEntryWithSequenceNumber {
        public final LogSequenceNumber logSequenceNumber;
        public final LogEntry entry;

        public LogEntryWithSequenceNumber(LogSequenceNumber logSequenceNumber, LogEntry entry) {
            this.logSequenceNumber = logSequenceNumber;
            this.entry = entry;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LogEntryWithSequenceNumber [logSequenceNumber=").append(this.logSequenceNumber).append(", entry=").append(this.entry).append("]");
            return builder.toString();
        }
    }
}

