/*
 * Decompiled with CFR 0.152.
 */
package herddb.client;

import herddb.client.ClientSideMetadataProvider;
import herddb.client.ClientSideMetadataProviderException;
import herddb.client.impl.UnreachableServerException;
import herddb.model.NodeMetadata;
import herddb.model.TableSpace;
import herddb.network.ServerHostData;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public final class ZookeeperClientSideMetadataProvider
implements ClientSideMetadataProvider {
    private static final Logger LOG = Logger.getLogger(ZookeeperClientSideMetadataProvider.class.getName());
    private final String basePath;
    private final ZookKeeperHolder zookeeperSupplier;
    private static final int MAX_TRIALS = 20;
    private final Map<String, String> tableSpaceLeaders = new ConcurrentHashMap<String, String>();
    private final Map<String, ServerHostData> servers = new ConcurrentHashMap<String, ServerHostData>();

    public ZookeeperClientSideMetadataProvider(String zkAddress, int zkSessionTimeout, String basePath) {
        this.zookeeperSupplier = new ZookKeeperHolder(zkAddress, zkSessionTimeout);
        this.basePath = basePath;
    }

    @Override
    public void requestMetadataRefresh(Exception error) {
        if (error instanceof UnreachableServerException) {
            UnreachableServerException u = (UnreachableServerException)error;
            this.servers.remove(u.getNodeId());
            List<String> tablespaces = this.tableSpaceLeaders.entrySet().stream().filter(entry -> ((String)entry.getValue()).equalsIgnoreCase(u.getNodeId())).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
            tablespaces.forEach(this.tableSpaceLeaders::remove);
        } else {
            this.tableSpaceLeaders.clear();
            this.servers.clear();
        }
    }

    @Override
    public String getTableSpaceLeader(String tableSpace) throws ClientSideMetadataProviderException {
        String cached = this.tableSpaceLeaders.get(tableSpace = tableSpace.toLowerCase());
        if (cached != null) {
            return cached;
        }
        for (int i = 0; i < 20; ++i) {
            ZooKeeper zooKeeper = this.getZooKeeper();
            try {
                try {
                    return this.readAsTableSpace(zooKeeper, tableSpace);
                }
                catch (KeeperException.NoNodeException ex) {
                    try {
                        return this.readAsNode(zooKeeper, tableSpace);
                    }
                    catch (KeeperException.NoNodeException ex2) {
                        return null;
                    }
                }
            }
            catch (KeeperException.ConnectionLossException ex) {
                LOG.log(Level.SEVERE, "tmp error getTableSpaceLeader for " + tableSpace + ": " + (Object)((Object)ex));
                try {
                    Thread.sleep(i * 500 + 1000);
                    continue;
                }
                catch (InterruptedException exit) {
                    throw new ClientSideMetadataProviderException(exit);
                }
            }
            catch (IOException | InterruptedException | KeeperException ex) {
                throw new ClientSideMetadataProviderException(ex);
            }
        }
        throw new ClientSideMetadataProviderException("Could not find a leader for tablespace " + tableSpace + " in time");
    }

    private String readAsTableSpace(ZooKeeper zooKeeper, String tableSpace) throws IOException, InterruptedException, KeeperException {
        tableSpace = tableSpace.toLowerCase();
        Stat stat = new Stat();
        byte[] result = zooKeeper.getData(this.basePath + "/tableSpaces/" + tableSpace, false, stat);
        String leader = TableSpace.deserialize((byte[])result, (Object)Integer.valueOf((int)stat.getVersion()), (long)stat.getCtime()).leaderId;
        this.tableSpaceLeaders.put(tableSpace, leader);
        return leader;
    }

    private String readAsNode(ZooKeeper zooKeeper, String tableSpace) throws IOException, InterruptedException, KeeperException {
        tableSpace = tableSpace.toLowerCase();
        Stat stat = new Stat();
        byte[] result = zooKeeper.getData(this.basePath + "/nodes/" + tableSpace, false, stat);
        NodeMetadata md = NodeMetadata.deserialize(result, (Object)stat.getVersion());
        String leader = md.nodeId;
        this.tableSpaceLeaders.put(tableSpace, leader);
        return leader;
    }

    @Override
    public ServerHostData getServerHostData(String nodeId) throws ClientSideMetadataProviderException {
        ServerHostData cached = this.servers.get(nodeId);
        if (cached != null) {
            return cached;
        }
        for (int i = 0; i < 20; ++i) {
            ZooKeeper zooKeeper = this.getZooKeeper();
            try {
                Stat stat = new Stat();
                byte[] node = zooKeeper.getData(this.basePath + "/nodes/" + nodeId, null, stat);
                NodeMetadata nodeMetadata = NodeMetadata.deserialize(node, (Object)stat.getVersion());
                ServerHostData result = new ServerHostData(nodeMetadata.host, nodeMetadata.port, "?", nodeMetadata.ssl, new HashMap());
                this.servers.put(nodeId, result);
                return result;
            }
            catch (KeeperException.NoNodeException ex) {
                return null;
            }
            catch (KeeperException.ConnectionLossException ex) {
                LOG.log(Level.SEVERE, "tmp error getServerHostData for " + nodeId + ": " + (Object)((Object)ex));
                try {
                    Thread.sleep(i * 500 + 1000);
                    continue;
                }
                catch (InterruptedException exit) {
                    throw new ClientSideMetadataProviderException(exit);
                }
            }
            catch (IOException | InterruptedException | KeeperException ex) {
                throw new ClientSideMetadataProviderException(ex);
            }
        }
        throw new ClientSideMetadataProviderException("Could not find a server info for node " + nodeId + " in time");
    }

    protected ZooKeeper getZooKeeper() throws ClientSideMetadataProviderException {
        try {
            ZooKeeper zooKeeper = this.zookeeperSupplier.get();
            if (zooKeeper == null) {
                throw new ClientSideMetadataProviderException(new Exception("ZooKeeper client is not available"));
            }
            return zooKeeper;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new ClientSideMetadataProviderException(ex);
        }
    }

    @Override
    public void close() {
        this.zookeeperSupplier.close();
    }

    private static class ZookKeeperHolder {
        private final AtomicReference<ZooKeeper> zk = new AtomicReference();
        private final String zkAddress;
        private final int zkSessionTimeout;
        private final ReentrantLock makeLock = new ReentrantLock();

        private ZooKeeper makeZooKeeper() {
            try {
                CountDownLatch waitForConnection = new CountDownLatch(1);
                ZooKeeper z = new ZooKeeper(this.zkAddress, this.zkSessionTimeout, (Watcher)new WatcherImpl(waitForConnection), true);
                boolean waitResult = waitForConnection.await((long)this.zkSessionTimeout * 2L, TimeUnit.MILLISECONDS);
                if (!waitResult) {
                    LOG.log(Level.SEVERE, "ZK session to ZK " + this.zkAddress + " did not establish within " + (long)this.zkSessionTimeout * 2L + " ms");
                }
                return z;
            }
            catch (IOException err) {
                LOG.log(Level.SEVERE, "zk client error " + err, err);
            }
            catch (InterruptedException err) {
                LOG.log(Level.SEVERE, "zk client error " + err, err);
                Thread.currentThread().interrupt();
            }
            return null;
        }

        private ZookKeeperHolder(String zkAddress, int zkSessionTimeout) {
            this.zkAddress = zkAddress;
            this.zkSessionTimeout = zkSessionTimeout;
            this.makeZooKeeper();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ZooKeeper get() throws InterruptedException {
            this.makeLock.lockInterruptibly();
            try {
                ZooKeeper current = this.zk.get();
                if (current != null && current.getState() != ZooKeeper.States.CLOSED) {
                    ZooKeeper zooKeeper = current;
                    return zooKeeper;
                }
                ZooKeeper newHandle = this.makeZooKeeper();
                boolean ok = this.zk.compareAndSet(current, newHandle);
                if (ok) {
                    ZooKeeper zooKeeper = newHandle;
                    return zooKeeper;
                }
                newHandle.close();
                ZooKeeper zooKeeper = current;
                return zooKeeper;
            }
            finally {
                this.makeLock.unlock();
            }
        }

        private void close() {
            try {
                ZooKeeper current = this.zk.get();
                this.zk.compareAndSet(current, null);
                if (current != null) {
                    current.close(1000);
                }
            }
            catch (InterruptedException err) {
                Thread.currentThread().interrupt();
            }
        }

        static class WatcherImpl
        implements Watcher {
            private final CountDownLatch waitForConnection;

            public WatcherImpl(CountDownLatch waitForConnection) {
                this.waitForConnection = waitForConnection;
            }

            public void process(WatchedEvent event) {
                switch (event.getState()) {
                    case SyncConnected: 
                    case SaslAuthenticated: 
                    case ConnectedReadOnly: {
                        LOG.log(Level.FINE, "zk client event {0}", event);
                        this.waitForConnection.countDown();
                        break;
                    }
                    case Expired: {
                        LOG.log(Level.INFO, "zk client event {0}", event);
                        break;
                    }
                    default: {
                        LOG.log(Level.INFO, "zk client event {0}", event);
                    }
                }
            }
        }
    }
}

