/*
 * Decompiled with CFR 0.152.
 */
package herddb.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.backup.DumpedLogEntry;
import herddb.backup.DumpedTableMetadata;
import herddb.client.ClientSideConnectionPeer;
import herddb.client.ClientSideMetadataProviderException;
import herddb.client.ClientSideQueryCache;
import herddb.client.DMLResult;
import herddb.client.GetResult;
import herddb.client.HDBConnection;
import herddb.client.HDBException;
import herddb.client.ScanResultSet;
import herddb.client.ScanResultSetMetadata;
import herddb.client.TableSpaceDumpReceiver;
import herddb.client.TableSpaceRestoreSource;
import herddb.client.impl.LeaderChangedException;
import herddb.client.impl.RetryRequestException;
import herddb.log.LogSequenceNumber;
import herddb.model.Index;
import herddb.model.Record;
import herddb.model.Table;
import herddb.model.Transaction;
import herddb.network.Channel;
import herddb.network.ChannelEventListener;
import herddb.network.ServerHostData;
import herddb.proto.Pdu;
import herddb.proto.PduCodec;
import herddb.security.sasl.SaslNettyClient;
import herddb.storage.DataStorageManagerException;
import herddb.utils.Bytes;
import herddb.utils.DataAccessor;
import herddb.utils.KeyValue;
import herddb.utils.RawString;
import herddb.utils.RecordsBatch;
import io.netty.buffer.ByteBuf;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class RoutedClientSideConnection
implements ChannelEventListener,
ClientSideConnectionPeer {
    private static final Logger LOGGER = Logger.getLogger(RoutedClientSideConnection.class.getName());
    private static final RawString RAWSTRING_KEY = RawString.of((String)"_key");
    private final HDBConnection connection;
    private final String nodeId;
    private final long timeout;
    private final ServerHostData server;
    private final String clientId;
    private final ReentrantReadWriteLock connectionLock = new ReentrantReadWriteLock(true);
    private volatile Channel channel;
    private final AtomicLong scannerIdGenerator = new AtomicLong();
    private final ClientSideQueryCache preparedStatements = new ClientSideQueryCache();
    private final Map<String, TableSpaceDumpReceiver> dumpReceivers = new ConcurrentHashMap<String, TableSpaceDumpReceiver>();

    public RoutedClientSideConnection(HDBConnection connection, String nodeId, ServerHostData server) {
        this.connection = connection;
        this.nodeId = nodeId;
        this.server = server;
        this.timeout = connection.getClient().getConfiguration().getLong("client.timeout", 300000L);
        this.clientId = connection.getClient().getConfiguration().getString("client.client.id", "localhost");
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAuthentication(Channel channel, String serverHostname) throws Exception {
        String mode = this.connection.getClient().getConfiguration().getString("client.mode", "standalone");
        if ("local".equals(mode) && channel.isLocalChannel()) {
            return;
        }
        SaslNettyClient saslNettyClient = new SaslNettyClient(this.connection.getClient().getConfiguration().getString("user", "sa"), this.connection.getClient().getConfiguration().getString("password", "hdb"), serverHostname);
        byte[] firstToken = new byte[]{};
        if (saslNettyClient.hasInitialResponse()) {
            firstToken = saslNettyClient.evaluateChallenge(new byte[0]);
        }
        long requestId = channel.generateRequestId();
        try (Pdu saslResponse = channel.sendMessageWithPduReply(requestId, PduCodec.SaslTokenMessageRequest.write((long)requestId, (String)"DIGEST-MD5", (byte[])firstToken), this.timeout);){
            block8: for (int i = 0; i < 100; ++i) {
                switch (saslResponse.type) {
                    case 101: {
                        byte[] token = PduCodec.SaslTokenServerResponse.readToken((Pdu)saslResponse);
                        byte[] responseToSendToServer = saslNettyClient.evaluateChallenge(token);
                        requestId = channel.generateRequestId();
                        saslResponse.close();
                        saslResponse = channel.sendMessageWithPduReply(requestId, PduCodec.SaslTokenMessageToken.write((long)requestId, (byte[])responseToSendToServer), this.timeout);
                        if (!saslNettyClient.isComplete()) continue block8;
                        LOGGER.finest("SASL auth completed with success");
                        return;
                    }
                    case 4: {
                        throw new Exception("Server returned ERROR during SASL negotiation, Maybe authentication failure (" + PduCodec.ErrorResponse.readError((Pdu)saslResponse) + ")");
                    }
                    default: {
                        throw new Exception("Unexpected server response during SASL negotiation (" + saslResponse + ")");
                    }
                }
            }
        }
        throw new Exception("SASL negotiation took too many steps");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public void requestReceived(Pdu message, Channel channel) {
        try {
            switch (message.type) {
                case 12: {
                    String dumpId = PduCodec.TablespaceDumpData.readDumpId((Pdu)message);
                    TableSpaceDumpReceiver receiver = this.dumpReceivers.get(dumpId);
                    LOGGER.log(Level.FINE, "receiver for {0}: {1}", new Object[]{dumpId, receiver});
                    if (receiver == null) {
                        if (channel == null) return;
                        ByteBuf resp = PduCodec.ErrorResponse.write((long)message.messageId, (String)("no such dump receiver " + dumpId));
                        channel.sendReplyMessage(message.messageId, resp);
                        return;
                    }
                    try {
                        String command = PduCodec.TablespaceDumpData.readCommand((Pdu)message);
                        boolean sendAck = true;
                        switch (command) {
                            case "start": {
                                long ledgerId = PduCodec.TablespaceDumpData.readLedgerId((Pdu)message);
                                long offset = PduCodec.TablespaceDumpData.readOffset((Pdu)message);
                                receiver.start(new LogSequenceNumber(ledgerId, offset));
                                break;
                            }
                            case "beginTable": {
                                byte[] tableDefinition = PduCodec.TablespaceDumpData.readTableDefinition((Pdu)message);
                                Table table = Table.deserialize(tableDefinition);
                                long estimatedSize = PduCodec.TablespaceDumpData.readEstimatedSize((Pdu)message);
                                long dumpLedgerId = PduCodec.TablespaceDumpData.readLedgerId((Pdu)message);
                                long dumpOffset = PduCodec.TablespaceDumpData.readOffset((Pdu)message);
                                List indexesDef = PduCodec.TablespaceDumpData.readIndexesDefinition((Pdu)message);
                                List<Index> indexes = indexesDef.stream().map(Index::deserialize).collect(Collectors.toList());
                                HashMap<String, Object> stats = new HashMap<String, Object>();
                                stats.put("estimatedSize", estimatedSize);
                                stats.put("dumpLedgerId", dumpLedgerId);
                                stats.put("dumpOffset", dumpOffset);
                                receiver.beginTable(new DumpedTableMetadata(table, new LogSequenceNumber(dumpLedgerId, dumpOffset), indexes), stats);
                                break;
                            }
                            case "endTable": {
                                receiver.endTable();
                                break;
                            }
                            case "finish": {
                                long ledgerId = PduCodec.TablespaceDumpData.readLedgerId((Pdu)message);
                                long offset = PduCodec.TablespaceDumpData.readOffset((Pdu)message);
                                receiver.finish(new LogSequenceNumber(ledgerId, offset));
                                sendAck = false;
                                break;
                            }
                            case "data": {
                                ArrayList<Record> records = new ArrayList<Record>();
                                PduCodec.TablespaceDumpData.readRecords((Pdu)message, (key, value) -> records.add(new Record(Bytes.from_array((byte[])key), Bytes.from_array((byte[])value))));
                                receiver.receiveTableDataChunk(records);
                                break;
                            }
                            case "txlog": {
                                ArrayList<DumpedLogEntry> records = new ArrayList<DumpedLogEntry>();
                                PduCodec.TablespaceDumpData.readRecords((Pdu)message, (key, value) -> records.add(new DumpedLogEntry(LogSequenceNumber.deserialize(key), (byte[])value)));
                                receiver.receiveTransactionLogChunk(records);
                                break;
                            }
                            case "transactions": {
                                ArrayList<Transaction> transactions = new ArrayList<Transaction>();
                                PduCodec.TablespaceDumpData.readRecords((Pdu)message, (key, value) -> transactions.add(Transaction.deserialize(null, value)));
                                receiver.receiveTransactionsAtDump(transactions);
                                break;
                            }
                            default: {
                                throw new DataStorageManagerException("invalid dump command:" + command);
                            }
                        }
                        if (channel == null) return;
                        if (!sendAck) return;
                        ByteBuf res = PduCodec.AckResponse.write((long)message.messageId);
                        channel.sendReplyMessage(message.messageId, res);
                        return;
                    }
                    catch (RuntimeException error) {
                        LOGGER.log(Level.SEVERE, "error while handling dump data", error);
                        receiver.onError(error);
                        if (channel == null) return;
                        ByteBuf res = PduCodec.ErrorResponse.write((long)message.messageId, (Throwable)error);
                        channel.sendReplyMessage(message.messageId, res);
                        return;
                    }
                }
            }
            return;
        }
        finally {
            message.close();
        }
    }

    public void channelClosed(Channel channel) {
        this.connectionLock.writeLock().lock();
        try {
            this.preparedStatements.clear();
            if (channel == this.channel) {
                this.channel = null;
            }
        }
        finally {
            this.connectionLock.writeLock().unlock();
        }
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void close() {
        LOGGER.log(Level.FINER, "{0} - close", this);
        this.connectionLock.writeLock().lock();
        try {
            this.preparedStatements.clear();
            if (this.channel != null) {
                this.channel.close();
            }
        }
        finally {
            this.channel = null;
            this.connectionLock.writeLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Channel ensureOpen() throws HDBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    long prepareQuery(String tableSpace, String query) throws HDBException, ClientSideMetadataProviderException {
        long l;
        block13: {
            long existing = this.preparedStatements.getQueryId(tableSpace, query);
            if (existing != 0L) {
                return existing;
            }
            Channel channel = this.ensureOpen();
            long requestId = channel.generateRequestId();
            ByteBuf message = PduCodec.PrepareStatement.write((long)requestId, (String)tableSpace, (String)query);
            Pdu reply = channel.sendMessageWithPduReply(requestId, message, this.timeout);
            try {
                if (reply.type == 4) {
                    this.handleGenericError(reply, 0L);
                } else if (reply.type != 104) {
                    throw new HDBException(reply);
                }
                long statementId = PduCodec.PrepareStatementResult.readStatementId((Pdu)reply);
                this.preparedStatements.registerQueryId(tableSpace, query, statementId);
                l = statementId;
                if (reply == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (reply != null) {
                        try {
                            reply.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException err) {
                    Thread.currentThread().interrupt();
                    throw new HDBException(err);
                }
                catch (TimeoutException err) {
                    throw new HDBException(err);
                }
            }
            reply.close();
        }
        return l;
    }

    @Override
    public DMLResult executeUpdate(String tableSpace, String query, long tx, boolean returnValues, boolean usePreparedStatement, List<Object> params) throws HDBException, ClientSideMetadataProviderException {
        DMLResult dMLResult;
        block13: {
            Channel channel = this.ensureOpen();
            long requestId = channel.generateRequestId();
            long statementId = usePreparedStatement ? this.prepareQuery(tableSpace, query) : 0L;
            query = statementId > 0L ? "" : query;
            ByteBuf message = PduCodec.ExecuteStatement.write((long)requestId, (String)tableSpace, (String)query, (long)tx, (boolean)returnValues, (long)statementId, params);
            Pdu reply = channel.sendMessageWithPduReply(requestId, message, this.timeout);
            try {
                if (reply.type == 4) {
                    this.handleGenericError(reply, statementId);
                } else if (reply.type != 6) {
                    throw new HDBException(reply);
                }
                long updateCount = PduCodec.ExecuteStatementResult.readUpdateCount((Pdu)reply);
                long transactionId = PduCodec.ExecuteStatementResult.readTx((Pdu)reply);
                boolean hasData = PduCodec.ExecuteStatementResult.hasRecord((Pdu)reply);
                Object key = null;
                Map<RawString, Object> newvalue = null;
                if (hasData) {
                    PduCodec.ObjectListReader parametersReader = PduCodec.ExecuteStatementResult.readRecord((Pdu)reply);
                    newvalue = this.readParametersListAsMap(parametersReader);
                    key = newvalue.get(RAWSTRING_KEY);
                }
                dMLResult = new DMLResult(updateCount, key, newvalue, transactionId);
                if (reply == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (reply != null) {
                        try {
                            reply.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException err) {
                    Thread.currentThread().interrupt();
                    throw new HDBException(err);
                }
                catch (TimeoutException err) {
                    throw new HDBException(err);
                }
            }
            reply.close();
        }
        return dMLResult;
    }

    @Override
    public CompletableFuture<DMLResult> executeUpdateAsync(String tableSpace, String query, long tx, boolean returnValues, boolean usePreparedStatement, List<Object> params) {
        CompletableFuture<DMLResult> res = new CompletableFuture<DMLResult>();
        try {
            Channel channel = this.ensureOpen();
            long requestId = channel.generateRequestId();
            long statementId = usePreparedStatement ? this.prepareQuery(tableSpace, query) : 0L;
            query = statementId > 0L ? "" : query;
            ByteBuf message = PduCodec.ExecuteStatement.write((long)requestId, (String)tableSpace, (String)query, (long)tx, (boolean)returnValues, (long)statementId, params);
            channel.sendRequestWithAsyncReply(requestId, message, this.timeout, (msg, error) -> {
                if (error != null) {
                    res.completeExceptionally(error);
                    return;
                }
                try (Pdu reply = msg;){
                    if (reply.type == 4) {
                        this.handleGenericError(reply, statementId);
                        return;
                    }
                    if (reply.type != 6) {
                        throw new HDBException(reply);
                    }
                    long updateCount = PduCodec.ExecuteStatementResult.readUpdateCount((Pdu)reply);
                    long transactionId = PduCodec.ExecuteStatementResult.readTx((Pdu)reply);
                    boolean hasData = PduCodec.ExecuteStatementResult.hasRecord((Pdu)reply);
                    Object key = null;
                    Map<RawString, Object> newvalue = null;
                    if (hasData) {
                        PduCodec.ObjectListReader parametersReader = PduCodec.ExecuteStatementResult.readRecord((Pdu)reply);
                        newvalue = this.readParametersListAsMap(parametersReader);
                        key = newvalue.get(RAWSTRING_KEY);
                    }
                    res.complete(new DMLResult(updateCount, key, newvalue, transactionId));
                }
                catch (ClientSideMetadataProviderException | HDBException err) {
                    res.completeExceptionally(err);
                }
            });
        }
        catch (ClientSideMetadataProviderException | HDBException err) {
            res.completeExceptionally(err);
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DMLResult> executeUpdates(String tableSpace, String query, long tx, boolean returnValues, boolean usePreparedStatement, List<List<Object>> batch) throws HDBException, ClientSideMetadataProviderException {
        try {
            Channel channel = this.ensureOpen();
            long requestId = channel.generateRequestId();
            long statementId = usePreparedStatement ? this.prepareQuery(tableSpace, query) : 0L;
            query = statementId > 0L ? "" : query;
            ByteBuf message = PduCodec.ExecuteStatements.write((long)requestId, (String)tableSpace, (String)query, (long)tx, (boolean)returnValues, (long)statementId, batch);
            try (Pdu reply = channel.sendMessageWithPduReply(requestId, message, this.timeout);){
                if (reply.type == 4) {
                    this.handleGenericError(reply, statementId);
                    List<DMLResult> list = Collections.emptyList();
                    return list;
                }
                if (reply.type != 16) {
                    throw new HDBException(reply);
                }
                long transactionId = PduCodec.ExecuteStatementsResult.readTx((Pdu)reply);
                List updateCounts = PduCodec.ExecuteStatementsResult.readUpdateCounts((Pdu)reply);
                int numResults = updateCounts.size();
                ArrayList<DMLResult> results = new ArrayList<DMLResult>(numResults);
                PduCodec.ListOfListsReader resultRecords = PduCodec.ExecuteStatementsResult.startResultRecords((Pdu)reply);
                int numResultRecords = resultRecords.getNumLists();
                for (int i = 0; i < numResults; ++i) {
                    PduCodec.ObjectListReader list;
                    Map<RawString, Object> newvalue = null;
                    Object key = null;
                    if (numResultRecords > 0 && (newvalue = this.readParametersListAsMap(list = resultRecords.nextList())) != null) {
                        key = newvalue.get(RAWSTRING_KEY);
                    }
                    long updateCount = (Long)updateCounts.get(i);
                    DMLResult res = new DMLResult(updateCount, key, newvalue, transactionId);
                    results.add(res);
                }
                ArrayList<DMLResult> arrayList = results;
                return arrayList;
            }
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new HDBException(err);
        }
        catch (TimeoutException err) {
            throw new HDBException(err);
        }
    }

    @Override
    public CompletableFuture<List<DMLResult>> executeUpdatesAsync(String tableSpace, String query, long tx, boolean returnValues, boolean usePreparedStatement, List<List<Object>> batch) {
        CompletableFuture<List<DMLResult>> res = new CompletableFuture<List<DMLResult>>();
        try {
            Channel channel = this.ensureOpen();
            long requestId = channel.generateRequestId();
            long statementId = usePreparedStatement ? this.prepareQuery(tableSpace, query) : 0L;
            query = statementId > 0L ? "" : query;
            ByteBuf message = PduCodec.ExecuteStatements.write((long)requestId, (String)tableSpace, (String)query, (long)tx, (boolean)returnValues, (long)statementId, batch);
            channel.sendRequestWithAsyncReply(requestId, message, this.timeout, (msg, error) -> {
                if (error != null) {
                    res.completeExceptionally(error);
                    return;
                }
                try (Pdu reply = msg;){
                    if (reply.type == 4) {
                        this.handleGenericError(reply, statementId);
                        return;
                    }
                    if (reply.type != 16) {
                        throw new HDBException(reply);
                    }
                    long transactionId = PduCodec.ExecuteStatementsResult.readTx((Pdu)reply);
                    List updateCounts = PduCodec.ExecuteStatementsResult.readUpdateCounts((Pdu)reply);
                    int numResults = updateCounts.size();
                    ArrayList<DMLResult> results = new ArrayList<DMLResult>(numResults);
                    PduCodec.ListOfListsReader resultRecords = PduCodec.ExecuteStatementsResult.startResultRecords((Pdu)reply);
                    int numResultRecords = resultRecords.getNumLists();
                    for (int i = 0; i < numResults; ++i) {
                        PduCodec.ObjectListReader list;
                        Map<RawString, Object> newvalue = null;
                        Object key = null;
                        if (numResultRecords > 0 && (newvalue = this.readParametersListAsMap(list = resultRecords.nextList())) != null) {
                            key = newvalue.get(RAWSTRING_KEY);
                        }
                        long updateCount = (Long)updateCounts.get(i);
                        DMLResult _res = new DMLResult(updateCount, key, newvalue, transactionId);
                        results.add(_res);
                    }
                    res.complete(results);
                }
                catch (ClientSideMetadataProviderException | HDBException err) {
                    res.completeExceptionally(err);
                }
            });
        }
        catch (ClientSideMetadataProviderException | HDBException err) {
            res.completeExceptionally(err);
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GetResult executeGet(String tableSpace, String query, long tx, boolean usePreparedStatement, List<Object> params) throws HDBException, ClientSideMetadataProviderException {
        Channel channel = this.ensureOpen();
        try {
            long requestId = channel.generateRequestId();
            long statementId = usePreparedStatement ? this.prepareQuery(tableSpace, query) : 0L;
            query = statementId > 0L ? "" : query;
            ByteBuf message = PduCodec.ExecuteStatement.write((long)requestId, (String)tableSpace, (String)query, (long)tx, (boolean)true, (long)statementId, params);
            try (Pdu reply = channel.sendMessageWithPduReply(requestId, message, this.timeout);){
                GetResult getResult;
                if (reply.type == 4) {
                    this.handleGenericError(reply, statementId);
                } else if (reply.type != 6) {
                    throw new HDBException(reply);
                }
                long updateCount = PduCodec.ExecuteStatementResult.readUpdateCount((Pdu)reply);
                long transactionId = PduCodec.ExecuteStatementResult.readTx((Pdu)reply);
                boolean hasData = PduCodec.ExecuteStatementResult.hasRecord((Pdu)reply);
                Map<RawString, Object> data = null;
                if (hasData) {
                    PduCodec.ObjectListReader parametersReader = PduCodec.ExecuteStatementResult.readRecord((Pdu)reply);
                    data = this.readParametersListAsMap(parametersReader);
                }
                if (updateCount <= 0L) {
                    getResult = new GetResult(null, transactionId);
                    return getResult;
                }
                getResult = new GetResult(data, transactionId);
                return getResult;
            }
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new HDBException(err);
        }
        catch (TimeoutException err) {
            throw new HDBException(err);
        }
    }

    Map<RawString, Object> readParametersListAsMap(PduCodec.ObjectListReader parametersReader) {
        HashMap<RawString, Object> data = new HashMap<RawString, Object>();
        for (int i = 0; i < parametersReader.getNumParams(); i += 2) {
            RawString _key = (RawString)parametersReader.nextObject();
            Object _value = parametersReader.nextObject();
            data.put(_key, _value);
        }
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long beginTransaction(String tableSpace) throws HDBException, ClientSideMetadataProviderException {
        Channel channel = this.ensureOpen();
        try {
            long requestId = channel.generateRequestId();
            ByteBuf message = PduCodec.TxCommand.write((long)requestId, (byte)3, (long)0L, (String)tableSpace);
            try (Pdu reply = channel.sendMessageWithPduReply(requestId, message, this.timeout);){
                if (reply.type == 4) {
                    this.handleGenericError(reply, 0L);
                    long l = -1L;
                    return l;
                }
                if (reply.type != 25) throw new HDBException(reply);
                long tx = PduCodec.TxCommandResult.readTx((Pdu)reply);
                if (tx <= 0L) {
                    throw new HDBException("Server did not create a new transaction");
                }
                long l = tx;
                return l;
            }
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new HDBException(err);
        }
        catch (TimeoutException err) {
            throw new HDBException(err);
        }
    }

    @Override
    public void commitTransaction(String tableSpace, long tx) throws HDBException, ClientSideMetadataProviderException {
        Channel channel = this.ensureOpen();
        try {
            long requestId = channel.generateRequestId();
            ByteBuf message = PduCodec.TxCommand.write((long)requestId, (byte)2, (long)tx, (String)tableSpace);
            try (Pdu reply = channel.sendMessageWithPduReply(requestId, message, this.timeout);){
                if (reply.type == 4) {
                    this.handleGenericError(reply, 0L);
                    return;
                }
                if (reply.type != 25) {
                    throw new HDBException(reply);
                }
            }
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new HDBException(err);
        }
        catch (TimeoutException err) {
            throw new HDBException(err);
        }
    }

    @Override
    public void rollbackTransaction(String tableSpace, long tx) throws HDBException, ClientSideMetadataProviderException {
        Channel channel = this.ensureOpen();
        try {
            long requestId = channel.generateRequestId();
            ByteBuf message = PduCodec.TxCommand.write((long)requestId, (byte)1, (long)tx, (String)tableSpace);
            try (Pdu reply = channel.sendMessageWithPduReply(requestId, message, this.timeout);){
                if (reply.type == 4) {
                    this.handleGenericError(reply, 0L);
                    return;
                }
                if (reply.type != 25) {
                    throw new HDBException(reply);
                }
            }
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new HDBException(err);
        }
        catch (TimeoutException err) {
            throw new HDBException(err);
        }
    }

    void handleGenericError(Pdu reply, long statementId) throws HDBException, ClientSideMetadataProviderException {
        this.handleGenericError(reply, statementId, false);
    }

    void handleGenericError(Pdu reply, long statementId, boolean release) throws HDBException, ClientSideMetadataProviderException {
        boolean notLeader = PduCodec.ErrorResponse.readIsNotLeader((Pdu)reply);
        boolean missingPreparedStatement = PduCodec.ErrorResponse.readIsMissingPreparedStatementError((Pdu)reply);
        boolean sqlIntegrityViolation = PduCodec.ErrorResponse.readIsSqlIntegrityViolationError((Pdu)reply);
        String msg = PduCodec.ErrorResponse.readError((Pdu)reply);
        if (release) {
            reply.close();
        }
        if (notLeader) {
            throw new LeaderChangedException(msg);
        }
        if (missingPreparedStatement) {
            LOGGER.log(Level.INFO, "Statement was flushed from server side cache " + msg);
            this.preparedStatements.invalidate(statementId);
            throw new RetryRequestException(msg);
        }
        if (sqlIntegrityViolation) {
            LOGGER.log(Level.INFO, "SQLIntegrityViolationException: " + msg);
            throw new HDBException(msg, new SQLIntegrityConstraintViolationException(msg));
        }
        throw new HDBException(msg);
    }

    @Override
    public ScanResultSet executeScan(String tableSpace, String query, boolean usePreparedStatement, List<Object> params, long tx, int maxRows, int fetchSize, boolean keepReadLocks) throws HDBException, ClientSideMetadataProviderException {
        Channel channel = this.ensureOpen();
        Pdu reply = null;
        try {
            long scannerId = this.scannerIdGenerator.incrementAndGet();
            long requestId = channel.generateRequestId();
            long statementId = usePreparedStatement ? this.prepareQuery(tableSpace, query) : 0L;
            query = statementId > 0L ? "" : query;
            ByteBuf message = PduCodec.OpenScanner.write((long)requestId, (String)tableSpace, (String)query, (long)scannerId, (long)tx, params, (long)statementId, (int)fetchSize, (int)maxRows, (boolean)keepReadLocks);
            LOGGER.log(Level.FINEST, "open scanner {0} for query {1}, params {2}", new Object[]{scannerId, query, params});
            reply = channel.sendMessageWithPduReply(requestId, message, this.timeout);
            if (reply.type == 4) {
                this.handleGenericError(reply, statementId, true);
                return null;
            }
            if (reply.type != 8) {
                HDBException err = new HDBException(reply);
                reply.close();
                throw err;
            }
            boolean last = PduCodec.ResultSetChunk.readIsLast((Pdu)reply);
            long transactionId = PduCodec.ResultSetChunk.readTx((Pdu)reply);
            RecordsBatch data = PduCodec.ResultSetChunk.startReadingData((Pdu)reply);
            ScanResultSetImpl impl = new ScanResultSetImpl(scannerId, data, fetchSize, last, transactionId, channel);
            return impl;
        }
        catch (InterruptedException err) {
            if (reply != null) {
                reply.close();
            }
            Thread.currentThread().interrupt();
            throw new HDBException(err);
        }
        catch (TimeoutException err) {
            if (reply != null) {
                reply.close();
            }
            throw new HDBException(err);
        }
    }

    @Override
    public void dumpTableSpace(String tableSpace, int fetchSize, boolean includeTransactionLog, TableSpaceDumpReceiver receiver) throws HDBException, ClientSideMetadataProviderException {
        Channel channel = this.ensureOpen();
        try {
            String dumpId = this.clientId + ":" + this.scannerIdGenerator.incrementAndGet();
            long requestId = channel.generateRequestId();
            ByteBuf message = PduCodec.RequestTablespaceDump.write((long)requestId, (String)tableSpace, (String)dumpId, (int)fetchSize, (boolean)includeTransactionLog);
            LOGGER.log(Level.SEVERE, "dumpTableSpace id {0} for tablespace {1}", new Object[]{dumpId, tableSpace});
            this.dumpReceivers.put(dumpId, receiver);
            try (Pdu reply = channel.sendMessageWithPduReply(requestId, message, this.timeout);){
                LOGGER.log(Level.SEVERE, "dumpTableSpace id {0} for tablespace {1}: first reply {2}", new Object[]{dumpId, tableSpace, reply});
                if (reply.type == 4) {
                    this.handleGenericError(reply, 0L);
                } else if (reply.type != 0) {
                    throw new HDBException(reply);
                }
            }
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new HDBException(err);
        }
        catch (TimeoutException err) {
            throw new HDBException(err);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void restoreTableSpace(String tableSpace, TableSpaceRestoreSource source) throws HDBException, ClientSideMetadataProviderException {
        ArrayList<DumpedTableMetadata> tables = new ArrayList<DumpedTableMetadata>();
        try {
            String entryType;
            block17: while (true) {
                entryType = source.nextEntryType();
                LOGGER.log(Level.FINEST, "restore, entryType:{0}", entryType);
                switch (entryType) {
                    case "start": {
                        continue block17;
                    }
                    case "table": {
                        DumpedTableMetadata table = source.nextTable();
                        Channel channel = this.ensureOpen();
                        long id = channel.generateRequestId();
                        ByteBuf message_create_table = PduCodec.RequestTableRestore.write((long)id, (String)tableSpace, (byte[])table.table.serialize(), (long)table.logSequenceNumber.ledgerId, (long)table.logSequenceNumber.offset);
                        this.sendMessageAndCheckNoError(channel, id, message_create_table);
                        List<KeyValue> chunk = source.nextTableDataChunk();
                        while (chunk != null) {
                            id = channel.generateRequestId();
                            ByteBuf message = PduCodec.PushTableData.write((long)id, (String)tableSpace, (String)table.table.name, chunk);
                            this.sendMessageAndCheckNoError(channel, id, message);
                            chunk = source.nextTableDataChunk();
                        }
                        tables.add(table);
                        continue block17;
                    }
                    case "txlogchunk": {
                        Channel channel = this.ensureOpen();
                        Object chunk = source.nextTransactionLogChunk();
                        long id = channel.generateRequestId();
                        ByteBuf message = PduCodec.PushTxLogChunk.write((long)id, (String)tableSpace, (List)chunk);
                        this.sendMessageAndCheckNoError(channel, id, message);
                        continue block17;
                    }
                    case "transactions": {
                        Channel channel = this.ensureOpen();
                        Object chunk = source.nextTransactionsBlock();
                        long id = channel.generateRequestId();
                        ByteBuf message = PduCodec.PushTransactionsBlock.write((long)id, (String)tableSpace, (List)chunk);
                        this.sendMessageAndCheckNoError(channel, id, message);
                        continue block17;
                    }
                    case "end": {
                        Channel channel = this.ensureOpen();
                        Object chunk = tables.iterator();
                        while (true) {
                            if (!chunk.hasNext()) {
                                long id = channel.generateRequestId();
                                ByteBuf message_restore_finished = PduCodec.RestoreFinished.write((long)id, (String)tableSpace);
                                this.sendMessageAndCheckNoError(channel, id, message_restore_finished);
                                return;
                            }
                            DumpedTableMetadata table = (DumpedTableMetadata)chunk.next();
                            List indexes = table.indexes.stream().map(Index::serialize).collect(Collectors.toList());
                            long id = channel.generateRequestId();
                            ByteBuf message_table_finished = PduCodec.TableRestoreFinished.write((long)id, (String)tableSpace, (String)table.table.name, indexes);
                            this.sendMessageAndCheckNoError(channel, id, message_table_finished);
                        }
                    }
                }
                break;
            }
            throw new HDBException("bad entryType " + entryType);
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new HDBException(err);
        }
        catch (TimeoutException err) {
            throw new HDBException(err);
        }
    }

    private void sendMessageAndCheckNoError(Channel channel, long id, ByteBuf message) throws HDBException, InterruptedException, TimeoutException {
        try (Pdu reply = channel.sendMessageWithPduReply(id, message, this.timeout);){
            if (reply.type == 4) {
                throw new HDBException(reply);
            }
        }
    }

    private class ScanResultSetImpl
    extends ScanResultSet {
        private final long scannerId;
        private final ScanResultSetMetadata metadata;
        RecordsBatch fetchBuffer;
        DataAccessor next;
        boolean finished;
        boolean noMoreData;
        int fetchSize;
        boolean lastChunk;
        final Channel channel;

        private ScanResultSetImpl(long scannerId, RecordsBatch firstFetchBuffer, int fetchSize, boolean onlyOneChunk, long tx, Channel channel) {
            super(tx);
            this.channel = channel;
            this.scannerId = scannerId;
            this.metadata = new ScanResultSetMetadata(firstFetchBuffer.columnNames);
            this.fetchSize = fetchSize;
            this.fetchBuffer = firstFetchBuffer;
            if (firstFetchBuffer.isEmpty()) {
                this.finished = true;
                this.noMoreData = true;
            }
            if (onlyOneChunk) {
                this.lastChunk = true;
            }
        }

        @Override
        public ScanResultSetMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        public void close() {
            this.finished = true;
            this.releaseBuffer();
            if (!this.noMoreData) {
                long requestId = this.channel.generateRequestId();
                ByteBuf message = PduCodec.CloseScanner.write((long)requestId, (long)this.scannerId);
                this.channel.sendOneWayMessage(message, error -> {
                    if (error != null) {
                        LOGGER.log(Level.SEVERE, "Cannot release scanner " + this.scannerId + ", con " + RoutedClientSideConnection.this, error);
                    }
                });
            }
        }

        private void releaseBuffer() {
            if (this.fetchBuffer != null) {
                this.fetchBuffer.release();
                this.fetchBuffer = null;
            }
        }

        @Override
        public boolean hasNext() throws HDBException {
            if (this.finished) {
                return false;
            }
            return this.ensureNext();
        }

        private void fillBuffer() throws HDBException {
            this.releaseBuffer();
            if (this.lastChunk) {
                this.noMoreData = true;
                return;
            }
            Pdu result = null;
            try {
                long requestId = this.channel.generateRequestId();
                ByteBuf message = PduCodec.FetchScannerData.write((long)requestId, (long)this.scannerId, (int)this.fetchSize);
                result = this.channel.sendMessageWithPduReply(requestId, message, RoutedClientSideConnection.this.timeout);
                if (result.type == 4) {
                    try {
                        throw new HDBException(result);
                    }
                    catch (Throwable throwable) {
                        result.close();
                        throw throwable;
                    }
                }
                if (result.type != 8) {
                    this.finished = true;
                    try {
                        throw new HDBException("protocol error: " + result);
                    }
                    catch (Throwable throwable) {
                        result.close();
                        throw throwable;
                    }
                }
                this.lastChunk = PduCodec.ResultSetChunk.readIsLast((Pdu)result);
                this.fetchBuffer = PduCodec.ResultSetChunk.startReadingData((Pdu)result);
                if (!this.fetchBuffer.hasNext()) {
                    this.noMoreData = true;
                }
            }
            catch (InterruptedException err) {
                if (result != null) {
                    result.close();
                }
                Thread.currentThread().interrupt();
                throw new HDBException(err);
            }
            catch (TimeoutException err) {
                if (result != null) {
                    result.close();
                }
                throw new HDBException(err);
            }
        }

        private boolean ensureNext() throws HDBException {
            if (this.next != null) {
                return true;
            }
            if (!this.fetchBuffer.hasNext()) {
                this.fillBuffer();
                if (this.noMoreData) {
                    this.finished = true;
                    return false;
                }
            }
            this.next = this.fetchBuffer.next();
            return true;
        }

        @Override
        public DataAccessor next() throws HDBException {
            if (this.finished) {
                throw new HDBException("Scanner is exhausted");
            }
            DataAccessor _next = this.next;
            this.next = null;
            return _next;
        }

        @Override
        public String getCursorName() {
            return "<scanner-" + this.scannerId + "-@tx" + this.transactionId + ">";
        }
    }
}

