/*
 * Decompiled with CFR 0.152.
 */
package herddb.client;

import herddb.client.ClientSideConnectionPeer;
import herddb.client.ClientSideMetadataProviderException;
import herddb.client.DMLResult;
import herddb.client.GetResult;
import herddb.client.HDBException;
import herddb.client.RoutedClientSideConnection;
import herddb.client.ScanResultSet;
import herddb.client.TableSpaceDumpReceiver;
import herddb.client.TableSpaceRestoreSource;
import herddb.network.Channel;
import herddb.network.netty.LocalVMChannel;
import herddb.server.ServerSideConnectionPeer;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class NonMarshallingClientSideConnectionPeer
implements ClientSideConnectionPeer {
    private final RoutedClientSideConnection realConnection;

    public NonMarshallingClientSideConnectionPeer(RoutedClientSideConnection fallback) {
        this.realConnection = fallback;
    }

    @Override
    public String getNodeId() {
        return this.realConnection.getNodeId();
    }

    @Override
    public String getClientId() {
        return this.realConnection.getClientId();
    }

    @Override
    public void close() {
        this.realConnection.close();
    }

    @Override
    public Channel getChannel() {
        return this.realConnection.getChannel();
    }

    @Override
    public Channel ensureOpen() throws HDBException {
        return this.realConnection.ensureOpen();
    }

    @Override
    public DMLResult executeUpdate(String tableSpace, String query, long tx, boolean returnValues, boolean usePreparedStatement, List<Object> params) throws HDBException, ClientSideMetadataProviderException {
        LocalVMChannel channel = (LocalVMChannel)this.realConnection.ensureOpen();
        ServerSideConnectionPeer serverSidePeer = (ServerSideConnectionPeer)channel.getServerSideChannel().getMessagesReceiver();
        return serverSidePeer.executeUpdate(tableSpace, query, tx, returnValues, params);
    }

    @Override
    public CompletableFuture<DMLResult> executeUpdateAsync(String tableSpace, String query, long tx, boolean returnValues, boolean usePreparedStatement, List<Object> params) {
        CompletableFuture<DMLResult> res = new CompletableFuture<DMLResult>();
        try {
            res.complete(this.executeUpdate(tableSpace, query, tx, returnValues, usePreparedStatement, params));
        }
        catch (ClientSideMetadataProviderException | HDBException t) {
            res.completeExceptionally(t);
        }
        return res;
    }

    @Override
    public List<DMLResult> executeUpdates(String tableSpace, String query, long tx, boolean returnValues, boolean usePreparedStatement, List<List<Object>> batch) throws HDBException, ClientSideMetadataProviderException {
        LocalVMChannel channel = (LocalVMChannel)this.realConnection.ensureOpen();
        ServerSideConnectionPeer serverSidePeer = (ServerSideConnectionPeer)channel.getServerSideChannel().getMessagesReceiver();
        return serverSidePeer.executeUpdates(tableSpace, query, tx, returnValues, batch);
    }

    @Override
    public CompletableFuture<List<DMLResult>> executeUpdatesAsync(String tableSpace, String query, long tx, boolean returnValues, boolean usePreparedStatement, List<List<Object>> batch) {
        CompletableFuture<List<DMLResult>> res = new CompletableFuture<List<DMLResult>>();
        try {
            res.complete(this.executeUpdates(tableSpace, query, tx, returnValues, usePreparedStatement, batch));
        }
        catch (ClientSideMetadataProviderException | HDBException t) {
            res.completeExceptionally(t);
        }
        return res;
    }

    @Override
    public GetResult executeGet(String tableSpace, String query, long tx, boolean usePreparedStatement, List<Object> params) throws HDBException, ClientSideMetadataProviderException {
        LocalVMChannel channel = (LocalVMChannel)this.realConnection.ensureOpen();
        ServerSideConnectionPeer serverSidePeer = (ServerSideConnectionPeer)channel.getServerSideChannel().getMessagesReceiver();
        return serverSidePeer.executeGet(tableSpace, query, tx, params);
    }

    @Override
    public long beginTransaction(String tableSpace) throws HDBException, ClientSideMetadataProviderException {
        LocalVMChannel channel = (LocalVMChannel)this.realConnection.ensureOpen();
        ServerSideConnectionPeer serverSidePeer = (ServerSideConnectionPeer)channel.getServerSideChannel().getMessagesReceiver();
        return serverSidePeer.beginTransaction(tableSpace);
    }

    @Override
    public void commitTransaction(String tableSpace, long tx) throws HDBException, ClientSideMetadataProviderException {
        LocalVMChannel channel = (LocalVMChannel)this.realConnection.ensureOpen();
        ServerSideConnectionPeer serverSidePeer = (ServerSideConnectionPeer)channel.getServerSideChannel().getMessagesReceiver();
        serverSidePeer.commitTransaction(tableSpace, tx);
    }

    @Override
    public void rollbackTransaction(String tableSpace, long tx) throws HDBException, ClientSideMetadataProviderException {
        LocalVMChannel channel = (LocalVMChannel)this.realConnection.ensureOpen();
        ServerSideConnectionPeer serverSidePeer = (ServerSideConnectionPeer)channel.getServerSideChannel().getMessagesReceiver();
        serverSidePeer.rollbackTransaction(tableSpace, tx);
    }

    @Override
    public ScanResultSet executeScan(String tableSpace, String query, boolean usePreparedStatement, List<Object> params, long tx, int maxRows, int fetchSize, boolean keepReadLocks) throws HDBException, ClientSideMetadataProviderException {
        LocalVMChannel channel = (LocalVMChannel)this.realConnection.ensureOpen();
        ServerSideConnectionPeer serverSidePeer = (ServerSideConnectionPeer)channel.getServerSideChannel().getMessagesReceiver();
        return serverSidePeer.executeScan(tableSpace, query, usePreparedStatement, params, tx, maxRows, fetchSize, keepReadLocks);
    }

    @Override
    public void dumpTableSpace(String tableSpace, int fetchSize, boolean includeTransactionLog, TableSpaceDumpReceiver receiver) throws HDBException, ClientSideMetadataProviderException {
        this.realConnection.dumpTableSpace(tableSpace, fetchSize, includeTransactionLog, receiver);
    }

    @Override
    public void restoreTableSpace(String tableSpace, TableSpaceRestoreSource source) throws HDBException, ClientSideMetadataProviderException {
        this.realConnection.restoreTableSpace(tableSpace, source);
    }
}

