/*
 * Decompiled with CFR 0.152.
 */
package herddb.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClientSideQueryCache {
    private final ConcurrentHashMap<String, Long> preparedStatements = new ConcurrentHashMap();

    public long getQueryId(String tableSpace, String query) {
        return this.preparedStatements.getOrDefault(tableSpace + "#" + query, 0L);
    }

    public void registerQueryId(String tableSpace, String text, long id) {
        this.preparedStatements.put(tableSpace + "#" + text, id);
    }

    void invalidate(long statementId) {
        String query = null;
        for (Map.Entry<String, Long> next : this.preparedStatements.entrySet()) {
            Long value = next.getValue();
            if (value == null || value != statementId) continue;
            query = next.getKey();
        }
        if (query != null) {
            this.preparedStatements.remove(query, statementId);
        }
    }

    void clear() {
        this.preparedStatements.clear();
    }
}

