/*
 * Decompiled with CFR 0.152.
 */
package herddb.backup;

import herddb.backup.DumpedTableMetadata;
import herddb.backup.ProgressListener;
import herddb.client.TableSpaceRestoreSource;
import herddb.log.LogSequenceNumber;
import herddb.model.Index;
import herddb.model.Table;
import herddb.storage.DataStorageManagerException;
import herddb.utils.Bytes;
import herddb.utils.ExtendedDataInputStream;
import herddb.utils.KeyValue;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

class TableSpaceRestoreSourceFromFile
extends TableSpaceRestoreSource {
    private final ExtendedDataInputStream in;
    private final ProgressListener listener;
    private long currentTableSize;

    public TableSpaceRestoreSourceFromFile(ExtendedDataInputStream in, ProgressListener listener) {
        this.in = in;
        this.listener = listener;
    }

    @Override
    public String nextEntryType() throws DataStorageManagerException {
        try {
            return this.in.readUTF();
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
    }

    @Override
    public List<KeyValue> nextTransactionLogChunk() throws DataStorageManagerException {
        try {
            int numRecords = this.in.readVInt();
            this.listener.log("nexttxchunk", "sending " + numRecords + " tx log entries", Collections.singletonMap("count", numRecords));
            ArrayList<KeyValue> records = new ArrayList<KeyValue>(numRecords);
            for (int i = 0; i < numRecords; ++i) {
                long ledgerId = this.in.readVLong();
                long offset = this.in.readVLong();
                Bytes value = this.in.readBytes();
                records.add(new KeyValue(Bytes.from_array((byte[])new LogSequenceNumber(ledgerId, offset).serialize()), value));
            }
            return records;
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
    }

    @Override
    public List<byte[]> nextTransactionsBlock() throws DataStorageManagerException {
        try {
            int numRecords = this.in.readVInt();
            this.listener.log("nextTransactionsBlock", "sending " + numRecords + " tx entries", Collections.singletonMap("count", numRecords));
            ArrayList<byte[]> records = new ArrayList<byte[]>(numRecords);
            for (int i = 0; i < numRecords; ++i) {
                byte[] value = this.in.readArray();
                records.add(value);
            }
            return records;
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
    }

    @Override
    public List<KeyValue> nextTableDataChunk() throws DataStorageManagerException {
        try {
            int numRecords = this.in.readVInt();
            if (Integer.MIN_VALUE == numRecords) {
                this.listener.log("tablefinished", "table finished after " + this.currentTableSize + " records", Collections.singletonMap("count", numRecords));
                return null;
            }
            this.listener.log("sendtabledata", "sending " + numRecords + ", total " + this.currentTableSize, Collections.singletonMap("count", numRecords));
            ArrayList<KeyValue> records = new ArrayList<KeyValue>(numRecords);
            for (int i = 0; i < numRecords; ++i) {
                Bytes key = this.in.readBytes();
                Bytes value = this.in.readBytes();
                records.add(new KeyValue(key, value));
            }
            this.currentTableSize += (long)numRecords;
            return records;
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
    }

    @Override
    public DumpedTableMetadata nextTable() throws DataStorageManagerException {
        this.currentTableSize = 0L;
        try {
            long dumpLedgerId = this.in.readLong();
            long dumpOffset = this.in.readLong();
            byte[] table = this.in.readArray();
            int numIndexes = this.in.readInt();
            ArrayList<byte[]> indexesData = new ArrayList<byte[]>();
            for (int i = 0; i < numIndexes; ++i) {
                byte[] index = this.in.readArray();
                indexesData.add(index);
            }
            List<Index> indexes = indexesData.stream().map(Index::deserialize).collect(Collectors.toList());
            Table tableMetadata = Table.deserialize(table);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("table", tableMetadata.name);
            data.put("dumpLedgerId", dumpLedgerId);
            data.put("dumpOffset", dumpOffset);
            data.put("indexes", indexesData.size());
            this.listener.log("starttable", "starting table " + tableMetadata.name, data);
            return new DumpedTableMetadata(tableMetadata, new LogSequenceNumber(dumpLedgerId, dumpOffset), indexes);
        }
        catch (EOFException end) {
            return null;
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
    }
}

