/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules.materialize;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.AggregateProjectPullUpConstantsRule;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.materialize.MaterializedViewRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;

public abstract class MaterializedViewAggregateRule
extends MaterializedViewRule {
    protected static final ImmutableList<TimeUnitRange> SUPPORTED_DATE_TIME_ROLLUP_UNITS = ImmutableList.of((Object)TimeUnitRange.YEAR, (Object)TimeUnitRange.QUARTER, (Object)TimeUnitRange.MONTH, (Object)TimeUnitRange.DAY, (Object)TimeUnitRange.HOUR, (Object)TimeUnitRange.MINUTE, (Object)TimeUnitRange.SECOND, (Object)TimeUnitRange.MILLISECOND, (Object)TimeUnitRange.MICROSECOND);
    protected final RelOptRule filterProjectTransposeRule;
    protected final RelOptRule filterAggregateTransposeRule;
    protected final RelOptRule aggregateProjectPullUpConstantsRule;
    protected final RelOptRule projectMergeRule;

    protected MaterializedViewAggregateRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description, boolean generateUnionRewriting, HepProgram unionRewritingPullProgram) {
        this(operand, relBuilderFactory, description, generateUnionRewriting, unionRewritingPullProgram, new FilterProjectTransposeRule(Filter.class, Project.class, true, true, relBuilderFactory), new FilterAggregateTransposeRule(Filter.class, relBuilderFactory, Aggregate.class), new AggregateProjectPullUpConstantsRule(Aggregate.class, Filter.class, relBuilderFactory, "AggFilterPullUpConstants"), new ProjectMergeRule(true, 100, relBuilderFactory));
    }

    protected MaterializedViewAggregateRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description, boolean generateUnionRewriting, HepProgram unionRewritingPullProgram, RelOptRule filterProjectTransposeRule, RelOptRule filterAggregateTransposeRule, RelOptRule aggregateProjectPullUpConstantsRule, RelOptRule projectMergeRule) {
        super(operand, relBuilderFactory, description, generateUnionRewriting, unionRewritingPullProgram, false);
        this.filterProjectTransposeRule = filterProjectTransposeRule;
        this.filterAggregateTransposeRule = filterAggregateTransposeRule;
        this.aggregateProjectPullUpConstantsRule = aggregateProjectPullUpConstantsRule;
        this.projectMergeRule = projectMergeRule;
    }

    @Override
    protected boolean isValidPlan(Project topProject, RelNode node, RelMetadataQuery mq) {
        if (!(node instanceof Aggregate)) {
            return false;
        }
        Aggregate aggregate = (Aggregate)node;
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            return false;
        }
        return this.isValidRelNodePlan(aggregate.getInput(), mq);
    }

    @Override
    protected MaterializedViewRule.ViewPartialRewriting compensateViewPartial(RelBuilder relBuilder, RexBuilder rexBuilder, RelMetadataQuery mq, RelNode input, Project topProject, RelNode node, Set<RexTableInputRef.RelTableRef> queryTableRefs, MaterializedViewRule.EquivalenceClasses queryEC, Project topViewProject, RelNode viewNode, Set<RexTableInputRef.RelTableRef> viewTableRefs) {
        HashSet<RexTableInputRef.RelTableRef> extraTableRefs = new HashSet<RexTableInputRef.RelTableRef>();
        for (RexTableInputRef.RelTableRef tRef : queryTableRefs) {
            if (viewTableRefs.contains(tRef)) continue;
            extraTableRefs.add(tRef);
        }
        Collection tableScanNodes = mq.getNodeTypes(node).get(TableScan.class);
        ArrayList<RelNode> newRels = new ArrayList<RelNode>();
        block1: for (RexTableInputRef.RelTableRef tRef : extraTableRefs) {
            int i = 0;
            for (RelNode relNode : tableScanNodes) {
                if (!tRef.getQualifiedName().equals(relNode.getTable().getQualifiedName()) || tRef.getEntityNumber() != i++) continue;
                newRels.add(relNode);
                continue block1;
            }
        }
        assert (extraTableRefs.size() == newRels.size());
        relBuilder.push(input);
        for (RelNode newRel : newRels) {
            relBuilder.push(newRel);
            relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
        }
        RelNode newView = relBuilder.build();
        Aggregate aggregateViewNode = (Aggregate)viewNode;
        relBuilder.push(aggregateViewNode.getInput());
        int offset = 0;
        for (RelNode newRel : newRels) {
            relBuilder.push(newRel);
            relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
            offset += newRel.getRowType().getFieldCount();
        }
        ImmutableBitSet.Builder groupSet = ImmutableBitSet.builder();
        groupSet.addAll(aggregateViewNode.getGroupSet());
        groupSet.addAll(ImmutableBitSet.range(aggregateViewNode.getInput().getRowType().getFieldCount(), aggregateViewNode.getInput().getRowType().getFieldCount() + offset));
        Aggregate newViewNode = aggregateViewNode.copy(aggregateViewNode.getTraitSet(), relBuilder.build(), groupSet.build(), null, aggregateViewNode.getAggCallList());
        relBuilder.push(newViewNode);
        ArrayList<RexNode> nodes = new ArrayList<RexNode>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (topViewProject != null) {
            int i;
            Mappings.TargetMapping shiftMapping = Mappings.createShiftMapping(newViewNode.getRowType().getFieldCount(), 0, 0, aggregateViewNode.getGroupCount(), newViewNode.getGroupCount(), aggregateViewNode.getGroupCount(), aggregateViewNode.getAggCallList().size());
            for (i = 0; i < topViewProject.getProjects().size(); ++i) {
                nodes.add(topViewProject.getProjects().get(i).accept(new RexPermuteInputsShuttle(shiftMapping, newViewNode)));
                fieldNames.add(topViewProject.getRowType().getFieldNames().get(i));
            }
            for (i = aggregateViewNode.getRowType().getFieldCount(); i < newViewNode.getRowType().getFieldCount(); ++i) {
                int idx = i - aggregateViewNode.getAggCallList().size();
                nodes.add(rexBuilder.makeInputRef(newViewNode, idx));
                fieldNames.add(newViewNode.getRowType().getFieldNames().get(idx));
            }
        } else {
            for (int i = 0; i < newViewNode.getRowType().getFieldCount(); ++i) {
                int idx = i < aggregateViewNode.getGroupCount() ? i : (i < aggregateViewNode.getRowType().getFieldCount() ? i + offset : i - aggregateViewNode.getAggCallList().size());
                nodes.add(rexBuilder.makeInputRef(newViewNode, idx));
                fieldNames.add(newViewNode.getRowType().getFieldNames().get(idx));
            }
        }
        relBuilder.project(nodes, fieldNames, true);
        Project newTopViewProject = (Project)relBuilder.build();
        return MaterializedViewRule.ViewPartialRewriting.of(newView, newTopViewProject, newViewNode);
    }

    @Override
    protected RelNode rewriteQuery(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, RexNode compensationColumnsEquiPred, RexNode otherCompensationPred, Project topProject, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping, MaterializedViewRule.EquivalenceClasses viewEC, MaterializedViewRule.EquivalenceClasses queryEC) {
        Aggregate aggregate = (Aggregate)node;
        RelNode newAggregateInput = aggregate.getInput(0);
        RelNode target = aggregate.getInput(0);
        if (this.unionRewritingPullProgram != null) {
            HepPlanner tmpPlanner = new HepPlanner(this.unionRewritingPullProgram);
            tmpPlanner.setRoot(newAggregateInput);
            newAggregateInput = tmpPlanner.findBestExp();
            target = newAggregateInput.getInput(0);
        }
        List<RexNode> queryExprs = this.extractReferences(rexBuilder, target);
        if (!compensationColumnsEquiPred.isAlwaysTrue() && (compensationColumnsEquiPred = this.rewriteExpression(rexBuilder, mq, target, target, queryExprs, queryToViewTableMapping, queryEC, false, compensationColumnsEquiPred)) == null) {
            return null;
        }
        if (!otherCompensationPred.isAlwaysTrue() && (otherCompensationPred = this.rewriteExpression(rexBuilder, mq, target, target, queryExprs, queryToViewTableMapping, viewEC, true, otherCompensationPred)) == null) {
            return null;
        }
        RexNode queryCompensationPred = RexUtil.not(RexUtil.composeConjunction(rexBuilder, (Iterable<? extends RexNode>)ImmutableList.of((Object)compensationColumnsEquiPred, (Object)otherCompensationPred)));
        RelNode rewrittenPlan = relBuilder.push(target).filter(simplify.simplifyUnknownAsFalse(queryCompensationPred)).build();
        if (this.unionRewritingPullProgram != null) {
            return aggregate.copy(aggregate.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)newAggregateInput.copy(newAggregateInput.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)rewrittenPlan))));
        }
        return aggregate.copy(aggregate.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)rewrittenPlan));
    }

    @Override
    protected RelNode createUnion(RelBuilder relBuilder, RexBuilder rexBuilder, RelNode topProject, RelNode unionInputQuery, RelNode unionInputView) {
        RelNode result;
        relBuilder.push(unionInputQuery);
        relBuilder.push(unionInputView);
        relBuilder.union(true);
        ArrayList<RexNode> exprList = new ArrayList<RexNode>(relBuilder.peek().getRowType().getFieldCount());
        ArrayList<String> nameList = new ArrayList<String>(relBuilder.peek().getRowType().getFieldCount());
        for (int i = 0; i < relBuilder.peek().getRowType().getFieldCount(); ++i) {
            RelDataTypeField field = unionInputQuery.getRowType().getFieldList().get(i);
            exprList.add(rexBuilder.ensureType(field.getType(), rexBuilder.makeInputRef(relBuilder.peek(), i), true));
            nameList.add(field.getName());
        }
        relBuilder.project(exprList, nameList);
        Aggregate aggregate = (Aggregate)unionInputQuery;
        ImmutableBitSet groupSet = ImmutableBitSet.range(aggregate.getGroupCount());
        ArrayList<RelBuilder.AggCall> aggregateCalls = new ArrayList<RelBuilder.AggCall>();
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            AggregateCall aggCall = aggregate.getAggCallList().get(i);
            if (aggCall.isDistinct()) {
                return null;
            }
            SqlAggFunction rollupAgg = this.getRollup(aggCall.getAggregation());
            if (rollupAgg == null) {
                return null;
            }
            RexInputRef operand = rexBuilder.makeInputRef(relBuilder.peek(), aggregate.getGroupCount() + i);
            aggregateCalls.add(relBuilder.aggregateCall(rollupAgg, operand).distinct(aggCall.isDistinct()).approximate(aggCall.isApproximate()).as(aggCall.name));
        }
        RelNode prevNode = relBuilder.peek();
        if (prevNode == (result = relBuilder.aggregate(relBuilder.groupKey(groupSet), (Iterable<RelBuilder.AggCall>)aggregateCalls).build()) && groupSet.cardinality() != result.getRowType().getFieldCount()) {
            result = relBuilder.push(result).project((Iterable<? extends RexNode>)relBuilder.fields(groupSet)).build();
        }
        if (topProject != null) {
            return topProject.copy(topProject.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)result));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected RelNode rewriteView(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, MaterializedViewRule.MatchModality matchModality, boolean unionRewriting, RelNode input, Project topProject, RelNode node, Project topViewProject, RelNode viewNode, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping, MaterializedViewRule.EquivalenceClasses queryEC) {
        RelDataType topRowType;
        Aggregate queryAggregate = (Aggregate)node;
        Aggregate viewAggregate = (Aggregate)viewNode;
        ImmutableBitSet.Builder indexes = ImmutableBitSet.builder();
        ImmutableBitSet references = null;
        if (topProject != null && !unionRewriting) {
            int i;
            RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(new LinkedHashSet<RelDataTypeField>());
            inputFinder.visitEach(topProject.getProjects());
            references = inputFinder.build();
            for (i = 0; i < queryAggregate.getGroupCount(); ++i) {
                indexes.set(queryAggregate.getGroupSet().nth(i));
            }
            for (i = 0; i < queryAggregate.getAggCallList().size(); ++i) {
                if (!references.get(queryAggregate.getGroupCount() + i)) continue;
                for (int inputIdx : queryAggregate.getAggCallList().get(i).getArgList()) {
                    indexes.set(inputIdx);
                }
            }
        } else {
            for (int i = 0; i < queryAggregate.getGroupCount(); ++i) {
                indexes.set(queryAggregate.getGroupSet().nth(i));
            }
            for (AggregateCall queryAggCall : queryAggregate.getAggCallList()) {
                for (int inputIdx : queryAggCall.getArgList()) {
                    indexes.set(inputIdx);
                }
            }
        }
        ArrayList<RexNode> rollupNodes = new ArrayList<RexNode>();
        Multimap<Integer, Integer> m = this.generateMapping(rexBuilder, simplify, mq, queryAggregate.getInput(), viewAggregate.getInput(), indexes.build(), queryToViewTableMapping, queryEC, rollupNodes);
        if (m == null) {
            return null;
        }
        int viewAggregateAdditionalFieldCount = rollupNodes.size();
        int viewInputFieldCount = viewAggregate.getInput().getRowType().getFieldCount();
        int viewInputDifferenceViewFieldCount = viewAggregate.getRowType().getFieldCount() - viewInputFieldCount;
        int viewAggregateTotalFieldCount = viewAggregate.getRowType().getFieldCount() + rollupNodes.size();
        boolean forceRollup = false;
        Mapping aggregateMapping = Mappings.create(MappingType.FUNCTION, queryAggregate.getRowType().getFieldCount(), viewAggregateTotalFieldCount);
        for (int i = 0; i < queryAggregate.getGroupCount(); ++i) {
            Collection c = m.get((Object)queryAggregate.getGroupSet().nth(i));
            Iterator iterator = c.iterator();
            while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                if (j >= viewAggregate.getInput().getRowType().getFieldCount()) {
                    aggregateMapping.set(i, j + viewInputDifferenceViewFieldCount);
                    forceRollup = true;
                    break;
                }
                int targetIdx = viewAggregate.getGroupSet().indexOf(j);
                if (targetIdx == -1) continue;
                aggregateMapping.set(i, targetIdx);
                break;
            }
            if (aggregateMapping.getTargetOpt(i) != -1) continue;
            return null;
        }
        boolean containsDistinctAgg = false;
        block8: for (int idx = 0; idx < queryAggregate.getAggCallList().size(); ++idx) {
            if (references != null && !references.get(queryAggregate.getGroupCount() + idx)) continue;
            AggregateCall queryAggCall = queryAggregate.getAggCallList().get(idx);
            if (queryAggCall.filterArg >= 0) {
                return null;
            }
            ArrayList queryAggCallIndexes = new ArrayList();
            for (int aggCallIdx : queryAggCall.getArgList()) {
                queryAggCallIndexes.add(m.get((Object)aggCallIdx).iterator().next());
            }
            for (int j = 0; j < viewAggregate.getAggCallList().size(); ++j) {
                AggregateCall viewAggCall = viewAggregate.getAggCallList().get(j);
                if (queryAggCall.getAggregation().getKind() != viewAggCall.getAggregation().getKind() || queryAggCall.isDistinct() != viewAggCall.isDistinct() || queryAggCall.getArgList().size() != viewAggCall.getArgList().size() || queryAggCall.getType() != viewAggCall.getType() || viewAggCall.filterArg >= 0 || !queryAggCallIndexes.equals(viewAggCall.getArgList())) continue;
                aggregateMapping.set(queryAggregate.getGroupCount() + idx, viewAggregate.getGroupCount() + j);
                if (!queryAggCall.isDistinct()) continue block8;
                containsDistinctAgg = true;
                continue block8;
            }
        }
        if (topViewProject == null) {
            topViewProject = (Project)relBuilder.push(viewNode).project((Iterable<? extends RexNode>)relBuilder.fields(), (Iterable<String>)ImmutableList.of(), true).build();
        }
        ArrayList<RexInputRef> additionalViewExprs = new ArrayList<RexInputRef>();
        ImmutableMultimap rewritingMapping = null;
        RelNode result = relBuilder.push(input).build();
        ArrayList<RexNode> inputViewExprs = new ArrayList<RexNode>();
        inputViewExprs.addAll((Collection<RexNode>)relBuilder.push(result).fields());
        relBuilder.clear();
        if (forceRollup || queryAggregate.getGroupCount() != viewAggregate.getGroupCount() || matchModality == MaterializedViewRule.MatchModality.VIEW_PARTIAL) {
            if (containsDistinctAgg) {
                return null;
            }
            ImmutableMultimap.Builder rewritingMappingB = ImmutableMultimap.builder();
            ImmutableBitSet.Builder groupSetB = ImmutableBitSet.builder();
            for (int i = 0; i < queryAggregate.getGroupCount(); ++i) {
                int targetIdx = aggregateMapping.getTargetOpt(i);
                if (targetIdx == -1) {
                    return null;
                }
                boolean added = false;
                if (targetIdx >= viewAggregate.getRowType().getFieldCount()) {
                    RexNode rexNode = (RexNode)rollupNodes.get(targetIdx - viewInputFieldCount - viewInputDifferenceViewFieldCount);
                    ArrayListMultimap exprsLineage = ArrayListMultimap.create();
                    ImmutableBitSet refs = RelOptUtil.InputFinder.bits(rexNode);
                    for (int childTargetIdx : refs) {
                        added = false;
                        for (int k = 0; k < topViewProject.getProjects().size() && !added; ++k) {
                            int ref;
                            RexNode n = topViewProject.getProjects().get(k);
                            if (!n.isA(SqlKind.INPUT_REF) || (ref = ((RexInputRef)n).getIndex()) != childTargetIdx) continue;
                            exprsLineage.put((Object)new RexInputRef(ref, rexNode.getType()), (Object)k);
                            added = true;
                        }
                        if (added) continue;
                        return null;
                    }
                    groupSetB.set(inputViewExprs.size());
                    rewritingMappingB.put((Object)inputViewExprs.size(), (Object)i);
                    additionalViewExprs.add(new RexInputRef(targetIdx, rexNode.getType()));
                    inputViewExprs.add(this.shuttleReferences(rexBuilder, rexNode, (Multimap<RexNode, Integer>)exprsLineage));
                    added = true;
                } else {
                    void var36_57;
                    boolean bl = false;
                    while (var36_57 < topViewProject.getProjects().size() && !added) {
                        int ref;
                        RexNode n = topViewProject.getProjects().get((int)var36_57);
                        if (n.isA(SqlKind.INPUT_REF) && (ref = ((RexInputRef)n).getIndex()) == targetIdx) {
                            groupSetB.set((int)var36_57);
                            rewritingMappingB.put((Object)((int)var36_57), (Object)i);
                            added = true;
                        }
                        ++var36_57;
                    }
                }
                if (added) continue;
                return null;
            }
            ImmutableBitSet groupSet = groupSetB.build();
            ArrayList<RelBuilder.AggCall> aggregateCalls = new ArrayList<RelBuilder.AggCall>();
            for (int i = 0; i < queryAggregate.getAggCallList().size(); ++i) {
                if (references != null && !references.get(queryAggregate.getGroupCount() + i)) continue;
                int n = queryAggregate.getGroupCount() + i;
                int targetIdx = aggregateMapping.getTargetOpt(n);
                if (targetIdx < 0) {
                    return null;
                }
                AggregateCall queryAggCall = queryAggregate.getAggCallList().get(i);
                boolean added = false;
                for (int k = 0; k < topViewProject.getProjects().size() && !added; ++k) {
                    int ref;
                    RexNode n2 = topViewProject.getProjects().get(k);
                    if (!n2.isA(SqlKind.INPUT_REF) || (ref = ((RexInputRef)n2).getIndex()) != targetIdx) continue;
                    SqlAggFunction rollupAgg = this.getRollup(queryAggCall.getAggregation());
                    if (rollupAgg == null) {
                        return null;
                    }
                    rewritingMappingB.put((Object)k, (Object)(queryAggregate.getGroupCount() + aggregateCalls.size()));
                    RexInputRef operand = rexBuilder.makeInputRef(input, k);
                    aggregateCalls.add(relBuilder.aggregateCall(rollupAgg, operand).approximate(queryAggCall.isApproximate()).distinct(queryAggCall.isDistinct()).as(queryAggCall.name));
                    added = true;
                }
                if (added) continue;
                return null;
            }
            Iterator prevNode = result;
            relBuilder.push(result);
            if (inputViewExprs.size() != result.getRowType().getFieldCount()) {
                relBuilder.project(inputViewExprs);
            }
            if (prevNode == (result = relBuilder.aggregate(relBuilder.groupKey(groupSet), (Iterable<RelBuilder.AggCall>)aggregateCalls).build()) && groupSet.cardinality() != result.getRowType().getFieldCount()) {
                result = relBuilder.push(result).project((Iterable<? extends RexNode>)relBuilder.fields(groupSet)).build();
            }
            rewritingMapping = rewritingMappingB.build();
            ImmutableMultimap immutableMultimap = rewritingMapping.inverse();
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
            ImmutableBitSet.Builder addedProjects = ImmutableBitSet.builder();
            for (int i = 0; i < queryAggregate.getGroupCount(); ++i) {
                int pos = groupSet.indexOf((Integer)immutableMultimap.get((Object)i).iterator().next());
                addedProjects.set(pos);
                projects.add(rexBuilder.makeInputRef(result, pos));
            }
            ImmutableBitSet projectedCols = addedProjects.build();
            for (int i = 0; i < result.getRowType().getFieldCount(); ++i) {
                if (projectedCols.get(i)) continue;
                projects.add(rexBuilder.makeInputRef(result, i));
            }
            result = relBuilder.push(result).project(projects).build();
        }
        ArrayList<RexNode> topExprs = new ArrayList<RexNode>();
        if (topProject != null && !unionRewriting) {
            topExprs.addAll(topProject.getProjects());
            topRowType = topProject.getRowType();
        } else {
            for (int pos = 0; pos < queryAggregate.getRowType().getFieldCount(); ++pos) {
                topExprs.add(rexBuilder.makeInputRef(queryAggregate, pos));
            }
            topRowType = queryAggregate.getRowType();
        }
        ArrayListMultimap viewExprs = ArrayListMultimap.create();
        int numberViewExprs = 0;
        for (RexNode rexNode : topViewProject.getProjects()) {
            viewExprs.put((Object)rexNode, (Object)numberViewExprs++);
        }
        for (RexNode rexNode : additionalViewExprs) {
            viewExprs.put((Object)rexNode, (Object)numberViewExprs++);
        }
        ArrayList<RexNode> rewrittenExprs = new ArrayList<RexNode>(topExprs.size());
        for (RexNode expr : topExprs) {
            RexNode rewrittenExpr = this.shuttleReferences(rexBuilder, expr, aggregateMapping);
            if (rewrittenExpr == null) {
                return null;
            }
            if ((rewrittenExpr = this.shuttleReferences(rexBuilder, rewrittenExpr, (Multimap<RexNode, Integer>)viewExprs, result, (Multimap<Integer, Integer>)rewritingMapping)) == null) {
                return null;
            }
            rewrittenExprs.add(rewrittenExpr);
        }
        return relBuilder.push(result).project(rewrittenExprs).convert(topRowType, false).build();
    }

    protected Multimap<Integer, Integer> generateMapping(RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, RelNode node, RelNode target, ImmutableBitSet positions, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, MaterializedViewRule.EquivalenceClasses sourceEC, List<RexNode> additionalExprs) {
        Preconditions.checkArgument((boolean)additionalExprs.isEmpty());
        ArrayListMultimap m = ArrayListMultimap.create();
        Map<RexTableInputRef, Set<RexTableInputRef>> equivalenceClassesMap = sourceEC.getEquivalenceClassesMap();
        ArrayListMultimap exprsLineage = ArrayListMultimap.create();
        ArrayList<RexNode> timestampExprs = new ArrayList<RexNode>();
        for (int i = 0; i < target.getRowType().getFieldCount(); ++i) {
            Set<RexNode> s = mq.getExpressionLineage(target, rexBuilder.makeInputRef(target, i));
            if (s == null) continue;
            RexNode e = (RexNode)Iterables.getOnlyElement(s);
            RexNode simplified = simplify.simplifyUnknownAsFalse(e);
            RexNode expr = RexUtil.swapTableColumnReferences(rexBuilder, simplified, (Map<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)tableMapping.inverse(), equivalenceClassesMap);
            exprsLineage.put((Object)expr, (Object)i);
            SqlTypeName sqlTypeName = expr.getType().getSqlTypeName();
            if (sqlTypeName != SqlTypeName.TIMESTAMP && sqlTypeName != SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) continue;
            timestampExprs.add(expr);
        }
        for (RexNode timestampExpr : timestampExprs) {
            for (TimeUnitRange value : SUPPORTED_DATE_TIME_ROLLUP_UNITS) {
                RexNode floorExpr;
                Object rewrittenFloorExpr;
                RexNode ceilExpr = rexBuilder.makeCall((SqlOperator)this.getCeilSqlFunction(value), timestampExpr, rexBuilder.makeFlag((Enum)value));
                RexNode rewrittenCeilExpr = this.shuttleReferences(rexBuilder, ceilExpr, (Multimap<RexNode, Integer>)exprsLineage);
                if (rewrittenCeilExpr != null) {
                    additionalExprs.add(rewrittenCeilExpr);
                    RexNode simplified = simplify.simplifyUnknownAsFalse(ceilExpr);
                    exprsLineage.put((Object)simplified, (Object)(target.getRowType().getFieldCount() + additionalExprs.size() - 1));
                }
                if ((rewrittenFloorExpr = this.shuttleReferences(rexBuilder, floorExpr = rexBuilder.makeCall((SqlOperator)this.getFloorSqlFunction(value), timestampExpr, rexBuilder.makeFlag((Enum)value)), (Multimap<RexNode, Integer>)exprsLineage)) == null) continue;
                additionalExprs.add((RexNode)rewrittenFloorExpr);
                RexNode simplified = simplify.simplifyUnknownAsFalse(floorExpr);
                exprsLineage.put((Object)simplified, (Object)(target.getRowType().getFieldCount() + additionalExprs.size() - 1));
            }
        }
        Iterator<Object> iterator = positions.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Set<RexNode> s = mq.getExpressionLineage(node, rexBuilder.makeInputRef(node, i));
            if (s == null) {
                return null;
            }
            RexNode e = (RexNode)Iterables.getOnlyElement(s);
            RexNode simplified = simplify.simplifyUnknownAsFalse(e);
            RexNode targetExpr = RexUtil.swapColumnReferences(rexBuilder, simplified, equivalenceClassesMap);
            Collection c = exprsLineage.get((Object)targetExpr);
            if (!c.isEmpty()) {
                for (Integer j : c) {
                    m.put((Object)i, (Object)j);
                }
                continue;
            }
            RexNode rewrittenTargetExpr = this.shuttleReferences(rexBuilder, targetExpr, (Multimap<RexNode, Integer>)exprsLineage);
            if (rewrittenTargetExpr == null) {
                return null;
            }
            m.put((Object)i, (Object)(target.getRowType().getFieldCount() + additionalExprs.size()));
            additionalExprs.add(rewrittenTargetExpr);
        }
        return m;
    }

    protected SqlFunction getCeilSqlFunction(TimeUnitRange flag) {
        return SqlStdOperatorTable.CEIL;
    }

    protected SqlFunction getFloorSqlFunction(TimeUnitRange flag) {
        return SqlStdOperatorTable.FLOOR;
    }

    protected SqlAggFunction getRollup(SqlAggFunction aggregation) {
        if (aggregation == SqlStdOperatorTable.SUM || aggregation == SqlStdOperatorTable.MIN || aggregation == SqlStdOperatorTable.MAX || aggregation == SqlStdOperatorTable.SUM0 || aggregation == SqlStdOperatorTable.ANY_VALUE) {
            return aggregation;
        }
        if (aggregation == SqlStdOperatorTable.COUNT) {
            return SqlStdOperatorTable.SUM0;
        }
        return null;
    }

    @Override
    public Pair<RelNode, RelNode> pushFilterToOriginalViewPlan(RelBuilder builder, RelNode topViewProject, RelNode viewNode, RexNode cond) {
        HepProgramBuilder pushFiltersProgram = new HepProgramBuilder();
        if (topViewProject != null) {
            pushFiltersProgram.addRuleInstance(this.filterProjectTransposeRule);
        }
        pushFiltersProgram.addRuleInstance(this.filterAggregateTransposeRule).addRuleInstance(this.aggregateProjectPullUpConstantsRule).addRuleInstance(this.projectMergeRule);
        HepPlanner tmpPlanner = new HepPlanner(pushFiltersProgram.build());
        RelNode topNode = builder.push(topViewProject != null ? topViewProject : viewNode).filter(cond).build();
        tmpPlanner.setRoot(topNode);
        topNode = tmpPlanner.findBestExp();
        RelNode resultTopViewProject = null;
        RelNode resultViewNode = null;
        while (topNode != null) {
            if (topNode instanceof Project) {
                if (resultTopViewProject != null) {
                    return Pair.of(topViewProject, viewNode);
                }
                resultTopViewProject = topNode;
                topNode = topNode.getInput(0);
                continue;
            }
            if (topNode instanceof Aggregate) {
                resultViewNode = topNode;
                topNode = null;
                continue;
            }
            topNode = topNode.getInput(0);
        }
        return Pair.of(resultTopViewProject, resultViewNode);
    }
}

