/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;

public class UnionPullUpConstantsRule
extends RelOptRule
implements TransformationRule {
    @Deprecated
    public static final UnionPullUpConstantsRule INSTANCE = CoreRules.UNION_PULL_UP_CONSTANTS;

    public UnionPullUpConstantsRule(Class<? extends Union> unionClass, RelBuilderFactory relBuilderFactory) {
        super(UnionPullUpConstantsRule.operandJ(unionClass, null, union -> union.getRowType().getFieldCount() > 1, UnionPullUpConstantsRule.any()), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Union union = (Union)call.rel(0);
        RexBuilder rexBuilder = union.getCluster().getRexBuilder();
        RelMetadataQuery mq = call.getMetadataQuery();
        RelOptPredicateList predicates = mq.getPulledUpPredicates(union);
        if (predicates == null) {
            return;
        }
        HashMap constants = new HashMap();
        for (Map.Entry e : predicates.constantMap.entrySet()) {
            if (!(e.getKey() instanceof RexInputRef)) continue;
            constants.put(((RexInputRef)e.getKey()).getIndex(), e.getValue());
        }
        if (constants.isEmpty()) {
            return;
        }
        List<RelDataTypeField> fields = union.getRowType().getFieldList();
        List<Object> topChildExprs = new ArrayList<RexNode>();
        ArrayList<String> topChildExprsFields = new ArrayList<String>();
        ArrayList<RexNode> refs = new ArrayList<RexNode>();
        ImmutableBitSet.Builder refsIndexBuilder = ImmutableBitSet.builder();
        for (RelDataTypeField field : fields) {
            RexNode constant = (RexNode)constants.get(field.getIndex());
            if (constant != null) {
                topChildExprs.add(constant);
                topChildExprsFields.add(field.getName());
                continue;
            }
            RexInputRef expr = rexBuilder.makeInputRef(union, field.getIndex());
            topChildExprs.add(expr);
            topChildExprsFields.add(field.getName());
            refs.add(expr);
            refsIndexBuilder.set(field.getIndex());
        }
        ImmutableBitSet refsIndex = refsIndexBuilder.build();
        Mapping mapping = RelOptUtil.permutation(refs, union.getInput(0).getRowType()).inverse();
        topChildExprs = RexUtil.apply((Mappings.TargetMapping)mapping, topChildExprs);
        RelBuilder relBuilder = call.builder();
        for (RelNode input : union.getInputs()) {
            ArrayList<Pair<Object, String>> newChildExprs = new ArrayList<Pair<Object, String>>();
            for (int j : refsIndex) {
                newChildExprs.add(Pair.of(rexBuilder.makeInputRef(input, j), input.getRowType().getFieldList().get(j).getName()));
            }
            if (newChildExprs.isEmpty()) {
                newChildExprs.add(Pair.of(topChildExprs.get(0), topChildExprsFields.get(0)));
            }
            relBuilder.push(input);
            relBuilder.project(Pair.left(newChildExprs), Pair.right(newChildExprs));
        }
        relBuilder.union(union.all, union.getInputs().size());
        relBuilder.project(topChildExprs, topChildExprsFields);
        relBuilder.convert(union.getRowType(), false);
        call.transformTo(relBuilder.build());
    }
}

