/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rex.RexBuilder;

public class SortRemoveConstantKeysRule
extends RelOptRule
implements SubstitutionRule {
    @Deprecated
    public static final SortRemoveConstantKeysRule INSTANCE = CoreRules.SORT_REMOVE_CONSTANT_KEYS;

    @Deprecated
    SortRemoveConstantKeysRule() {
        super(SortRemoveConstantKeysRule.operand(Sort.class, SortRemoveConstantKeysRule.any()), RelFactories.LOGICAL_BUILDER, "SortRemoveConstantKeysRule");
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode input;
        Sort sort = (Sort)call.rel(0);
        RelMetadataQuery mq = call.getMetadataQuery();
        RelOptPredicateList predicates = mq.getPulledUpPredicates(input = sort.getInput());
        if (predicates == null) {
            return;
        }
        RexBuilder rexBuilder = sort.getCluster().getRexBuilder();
        List<RelFieldCollation> collationsList = sort.getCollation().getFieldCollations().stream().filter(fc -> !predicates.constantMap.containsKey((Object)rexBuilder.makeInputRef(input, fc.getFieldIndex()))).collect(Collectors.toList());
        if (collationsList.size() == sort.collation.getFieldCollations().size()) {
            return;
        }
        if (collationsList.isEmpty() && sort.offset == null && sort.fetch == null) {
            call.transformTo(input);
            call.getPlanner().prune(sort);
            return;
        }
        Sort result = sort.copy(sort.getTraitSet(), input, RelCollations.of(collationsList));
        call.transformTo(result);
        call.getPlanner().prune(sort);
    }
}

