/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.tools.RelBuilderFactory;

public class SortJoinTransposeRule
extends RelOptRule
implements TransformationRule {
    @Deprecated
    public static final SortJoinTransposeRule INSTANCE = CoreRules.SORT_JOIN_TRANSPOSE;

    @Deprecated
    public SortJoinTransposeRule(Class<? extends Sort> sortClass, Class<? extends Join> joinClass) {
        this(sortClass, joinClass, RelFactories.LOGICAL_BUILDER);
    }

    public SortJoinTransposeRule(Class<? extends Sort> sortClass, Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        super(SortJoinTransposeRule.operand(sortClass, SortJoinTransposeRule.operand(joinClass, SortJoinTransposeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        Join join = (Join)call.rel(1);
        RelMetadataQuery mq = call.getMetadataQuery();
        JoinInfo joinInfo = JoinInfo.of(join.getLeft(), join.getRight(), join.getCondition());
        if (join.getJoinType() == JoinRelType.LEFT) {
            if (sort.getCollation() != RelCollations.EMPTY) {
                for (RelFieldCollation relFieldCollation : sort.getCollation().getFieldCollations()) {
                    if (relFieldCollation.getFieldIndex() < join.getLeft().getRowType().getFieldCount()) continue;
                    return false;
                }
            }
            if (sort.offset != null && !RelMdUtil.areColumnsDefinitelyUnique(mq, join.getRight(), joinInfo.rightSet())) {
                return false;
            }
        } else if (join.getJoinType() == JoinRelType.RIGHT) {
            if (sort.getCollation() != RelCollations.EMPTY) {
                for (RelFieldCollation relFieldCollation : sort.getCollation().getFieldCollations()) {
                    if (relFieldCollation.getFieldIndex() >= join.getLeft().getRowType().getFieldCount()) continue;
                    return false;
                }
            }
            if (sort.offset != null && !RelMdUtil.areColumnsDefinitelyUnique(mq, join.getLeft(), joinInfo.leftSet())) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode newRightInput;
        RelNode newLeftInput;
        Sort sort = (Sort)call.rel(0);
        Join join = (Join)call.rel(1);
        RelMetadataQuery mq = call.getMetadataQuery();
        if (join.getJoinType() == JoinRelType.LEFT) {
            if (RelMdUtil.checkInputForCollationAndLimit(mq, join.getLeft(), sort.getCollation(), sort.offset, sort.fetch)) {
                return;
            }
            newLeftInput = sort.copy(sort.getTraitSet(), join.getLeft(), sort.getCollation(), sort.offset, sort.fetch);
            newRightInput = join.getRight();
        } else {
            RelCollation rightCollation = RelCollationTraitDef.INSTANCE.canonize(RelCollations.shift(sort.getCollation(), -join.getLeft().getRowType().getFieldCount()));
            if (RelMdUtil.checkInputForCollationAndLimit(mq, join.getRight(), rightCollation, sort.offset, sort.fetch)) {
                return;
            }
            newLeftInput = join.getLeft();
            newRightInput = sort.copy(sort.getTraitSet().replace(rightCollation), join.getRight(), rightCollation, sort.offset, sort.fetch);
        }
        Join joinCopy = join.copy(join.getTraitSet(), join.getCondition(), newLeftInput, newRightInput, join.getJoinType(), join.isSemiJoinDone());
        Sort sortCopy = sort.copy(sort.getTraitSet(), joinCopy, sort.getCollation(), sort.offset, sort.fetch);
        call.transformTo(sortCopy);
    }
}

